/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.tweak.carry;

import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import pl.asie.charset.ModCharset;
import pl.asie.charset.api.carry.CustomCarryHandler;
import pl.asie.charset.api.carry.ICarryHandler;
import pl.asie.charset.api.lib.ICacheable;
import pl.asie.charset.api.lib.IMovable;
import pl.asie.charset.api.lib.IMultiblockStructure;
import pl.asie.charset.api.locks.Lockable;
import pl.asie.charset.lib.capability.Capabilities;
import pl.asie.charset.lib.capability.CapabilityHelper;
import pl.asie.charset.lib.capability.CapabilityProviderFactory;
import pl.asie.charset.lib.utils.RotationUtils;
import pl.asie.charset.module.tweak.carry.CharsetTweakBlockCarrying;

public class CarryHandler
implements ICacheable,
ICarryHandler {
    public static CapabilityProviderFactory<CarryHandler> PROVIDER;
    public static final BlockPos ACCESS_POS;
    private Entity player;
    private Access access = new Access();
    private IBlockState block;
    private NBTTagCompound tile;
    private TileEntity tileInstance;
    private float grabbedYaw;
    protected CustomCarryHandler customCarryHandler;

    public CarryHandler setPlayer(Entity player) {
        this.player = player;
        return this;
    }

    public void update() {
        if (this.customCarryHandler != null) {
            this.customCarryHandler.tick();
        }
    }

    private void setTile(TileEntity tile) {
        if (tile != null) {
            this.tile = tile.func_189515_b(new NBTTagCompound());
            this.tile.func_74768_a("x", 0);
            this.tile.func_74768_a("y", 64);
            this.tile.func_74768_a("z", 0);
        } else {
            this.tile = null;
        }
        this.tileInstance = null;
    }

    protected void setCustomCarryHandler(boolean emptied) {
        TileEntity tile;
        CustomCarryHandler.Provider provider;
        this.customCarryHandler = !emptied && this.block != null ? ((provider = (CustomCarryHandler.Provider)CapabilityHelper.getBlockCapability((IBlockAccess)this.access, (BlockPos)ACCESS_POS, (IBlockState)this.block, null, (Capability)Capabilities.CUSTOM_CARRY_PROVIDER)) != null ? provider.create((ICarryHandler)this) : ((tile = this.getTile()) != null && tile.hasCapability(Capabilities.CUSTOM_CARRY_PROVIDER, null) ? ((CustomCarryHandler.Provider)tile.getCapability(Capabilities.CUSTOM_CARRY_PROVIDER, null)).create((ICarryHandler)this) : null)) : null;
    }

    public IBlockAccess getBlockAccess() {
        return this.access;
    }

    public float getGrabbedYaw() {
        return this.grabbedYaw;
    }

    public boolean isCarrying() {
        return this.block != null;
    }

    public void put(IBlockState state, TileEntity tile) {
        this.grabbedYaw = this.player != null ? this.player.field_70177_z : 0.0f;
        this.block = state;
        this.setTile(tile);
        this.setCustomCarryHandler(false);
    }

    public boolean grab(World world, BlockPos pos) {
        if (this.block == null) {
            this.grabbedYaw = this.player != null ? this.player.field_70177_z : 0.0f;
            this.block = world.func_180495_p(pos);
            if (this.block.func_177230_c().isAir(this.block, (IBlockAccess)world, pos) || !this.canPickUp(world, pos, this.block)) {
                this.block = null;
                return false;
            }
            if (this.block.func_177230_c().hasTileEntity(this.block)) {
                this.setTile(world.func_175625_s(pos));
                world.func_175713_t(pos);
            } else {
                this.setTile(null);
            }
            this.setCustomCarryHandler(false);
            world.func_175698_g(pos);
            if (!this.block.func_177230_c().func_176196_c(world, pos)) {
                ModCharset.logger.warn("Block " + this.block.func_177230_c().getRegistryName() + " could not be placed in the position it was just picked up from. Interesting?");
            }
            return true;
        }
        return false;
    }

    private boolean canPickUp(World world, BlockPos pos, IBlockState block) {
        IMovable movable;
        if (this.player instanceof EntityPlayer && ((EntityPlayer)this.player).func_184812_l_()) {
            return true;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityLockable && ((TileEntityLockable)tile).func_174893_q_()) {
            return false;
        }
        IMultiblockStructure structure = (IMultiblockStructure)CapabilityHelper.get((IBlockAccess)world, (BlockPos)pos, (Capability)Capabilities.MULTIBLOCK_STRUCTURE, null, (boolean)true, (boolean)true, (boolean)false);
        if (structure != null && !structure.isSeparable()) {
            int count = 0;
            Iterator it = structure.iterator();
            while (it.hasNext()) {
                if (++count < 2) continue;
                return false;
            }
        }
        if ((movable = (IMovable)CapabilityHelper.get((IBlockAccess)world, (BlockPos)pos, (Capability)Capabilities.MOVABLE, null, (boolean)true, (boolean)true, (boolean)false)) != null && !movable.canMoveFrom()) {
            return false;
        }
        Lockable lockable = (Lockable)CapabilityHelper.get((IBlockAccess)world, (BlockPos)pos, (Capability)Capabilities.LOCKABLE, null, (boolean)true, (boolean)true, (boolean)false);
        return lockable == null || !lockable.hasLock();
    }

    public boolean place(World world, BlockPos pos, EnumFacing facing, EntityPlayer player) {
        if (this.block != null) {
            IMovable movable;
            if (this.hasTileEntity() && (movable = (IMovable)CapabilityHelper.get((Capability)Capabilities.MOVABLE, (ICapabilityProvider)this.getTile(), null)) != null && !movable.canMoveTo(world, pos)) {
                return false;
            }
            if (world.func_175660_a(player, pos) && world.func_190527_a(this.block.func_177230_c(), pos, false, facing, (Entity)player)) {
                float yawDiff;
                world.func_175656_a(pos, this.block);
                IBlockState oldBlock = this.block;
                if (this.tile != null) {
                    this.tile.func_74768_a("x", pos.func_177958_n());
                    this.tile.func_74768_a("y", pos.func_177956_o());
                    this.tile.func_74768_a("z", pos.func_177952_p());
                    world.func_175690_a(pos, TileEntity.func_190200_a((World)world, (NBTTagCompound)this.tile));
                    this.setTile(null);
                }
                if (this.customCarryHandler != null) {
                    this.customCarryHandler.onPlace(world, pos);
                }
                float f = yawDiff = player != null ? this.grabbedYaw - player.field_70177_z : 0.0f;
                while (yawDiff < 0.0f) {
                    yawDiff += 360.0f;
                }
                int rotCycles = MathHelper.func_76128_c((double)((double)(yawDiff * 4.0f / 360.0f) + 0.5)) & 3;
                if (rotCycles > 0) {
                    RotationUtils.rotateAround((World)world, (BlockPos)pos, (EnumFacing)EnumFacing.UP, (int)rotCycles);
                }
                this.block = null;
                IBlockState newState = world.func_180495_p(pos);
                if (player instanceof EntityPlayer) {
                    SoundType soundtype = newState.func_177230_c().getSoundType(newState, world, pos, (Entity)player);
                    world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                }
                try {
                    newState.func_189546_a(world, pos, oldBlock.func_177230_c(), pos);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                CharsetTweakBlockCarrying.syncCarryWithAllClients((Entity)player);
                this.setCustomCarryHandler(true);
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean hasTileEntity() {
        return this.tile != null;
    }

    public void empty() {
        this.block = null;
        this.setTile(null);
        this.setCustomCarryHandler(true);
    }

    public IBlockState getState() {
        return this.block;
    }

    public NBTTagCompound getTileNBT() {
        return this.tile;
    }

    public TileEntity getTile() {
        if (this.tileInstance != null) {
            this.tileInstance.func_145834_a(this.player.field_70170_p);
            return this.tileInstance;
        }
        return this.tile != null ? (this.tileInstance = TileEntity.func_190200_a((World)this.player.field_70170_p, (NBTTagCompound)this.tile)) : null;
    }

    public Entity getCarrier() {
        return this.player;
    }

    public static void register() {
        Storage storage = new Storage();
        CapabilityManager.INSTANCE.register(CarryHandler.class, (Capability.IStorage)storage, CarryHandler::new);
        PROVIDER = new CapabilityProviderFactory(CharsetTweakBlockCarrying.CAPABILITY, (Capability.IStorage)storage);
    }

    public boolean isCacheValid() {
        return !this.player.field_70128_L;
    }

    static {
        ACCESS_POS = new BlockPos(0, 64, 0);
    }

    private class Access
    implements IBlockAccess {
        private Access() {
        }

        private BlockPos getPlayerPos() {
            return CarryHandler.this.player != null ? new BlockPos(((CarryHandler)CarryHandler.this).player.field_70165_t, ((CarryHandler)CarryHandler.this).player.field_70163_u + (double)CarryHandler.this.player.func_70047_e(), ((CarryHandler)CarryHandler.this).player.field_70161_v) : ACCESS_POS;
        }

        @Nullable
        public TileEntity func_175625_s(BlockPos pos) {
            return pos.equals((Object)ACCESS_POS) ? CarryHandler.this.getTile() : null;
        }

        public int func_175626_b(BlockPos pos, int lightValue) {
            return CarryHandler.this.player != null ? ((CarryHandler)CarryHandler.this).player.field_70170_p.func_175626_b(this.getPlayerPos(), lightValue) : 0xF000F0;
        }

        public IBlockState func_180495_p(BlockPos pos) {
            return pos.equals((Object)ACCESS_POS) ? CarryHandler.this.block : Blocks.field_150350_a.func_176223_P();
        }

        public boolean func_175623_d(BlockPos pos) {
            return !pos.equals((Object)ACCESS_POS);
        }

        public Biome func_180494_b(BlockPos pos) {
            return CarryHandler.this.player != null ? ((CarryHandler)CarryHandler.this).player.field_70170_p.func_180494_b(this.getPlayerPos()) : Biome.func_150568_d((int)1);
        }

        public int func_175627_a(BlockPos pos, EnumFacing direction) {
            return 0;
        }

        public WorldType func_175624_G() {
            return CarryHandler.this.player != null ? ((CarryHandler)CarryHandler.this).player.field_70170_p.func_175624_G() : WorldType.field_77137_b;
        }

        public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
            return false;
        }
    }

    public static class Storage
    implements Capability.IStorage<CarryHandler> {
        public NBTBase writeNBT(Capability<CarryHandler> capability, CarryHandler instance, EnumFacing side) {
            NBTTagCompound compound = new NBTTagCompound();
            if (instance.block != null) {
                compound.func_74778_a("b:name", instance.block.func_177230_c().getRegistryName().toString());
                compound.func_74774_a("b:meta", (byte)instance.block.func_177230_c().func_176201_c(instance.block));
                compound.func_74776_a("p:yaw", instance.grabbedYaw);
                if (instance.tile != null) {
                    compound.func_74782_a("b:tile", (NBTBase)instance.tile);
                }
            }
            return compound;
        }

        public void readNBT(Capability<CarryHandler> capability, CarryHandler instance, EnumFacing side, NBTBase nbt) {
            NBTTagCompound compound;
            instance.empty();
            if (nbt instanceof NBTTagCompound && (compound = (NBTTagCompound)nbt).func_74764_b("b:name") && compound.func_74764_b("b:meta")) {
                Block block = Block.func_149684_b((String)compound.func_74779_i("b:name"));
                instance.block = block.func_176203_a((int)compound.func_74771_c("b:meta"));
                instance.grabbedYaw = compound.func_74760_g("p:yaw");
                if (compound.func_74764_b("b:tile")) {
                    instance.tile = compound.func_74775_l("b:tile");
                    instance.setCustomCarryHandler(false);
                }
            }
        }
    }
}

