/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.tweak.carry;

import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEndPortal;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockPistonExtension;
import net.minecraft.block.BlockPistonMoving;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import pl.asie.charset.ModCharset;
import pl.asie.charset.lib.CharsetIMC;
import pl.asie.charset.lib.config.CharsetLoadConfigEvent;
import pl.asie.charset.lib.config.ConfigUtils;
import pl.asie.charset.lib.loader.CharsetModule;
import pl.asie.charset.lib.loader.ModuleProfile;
import pl.asie.charset.lib.network.Packet;
import pl.asie.charset.lib.network.PacketRegistry;
import pl.asie.charset.lib.utils.ThreeState;
import pl.asie.charset.module.tweak.carry.CarryHandler;
import pl.asie.charset.module.tweak.carry.CarryTransformerEntityMinecart;
import pl.asie.charset.module.tweak.carry.CarryTransformerRegistry;
import pl.asie.charset.module.tweak.carry.ICarryTransformer;
import pl.asie.charset.module.tweak.carry.PacketCarryGrab;
import pl.asie.charset.module.tweak.carry.PacketCarrySync;
import pl.asie.charset.module.tweak.carry.TweakCarryEventHandler;
import pl.asie.charset.module.tweak.carry.TweakCarryRender;

@CharsetModule(name="tweak.carry", description="Allow players to carry blocks via shift-pickblock", profile=ModuleProfile.FORCED)
public class CharsetTweakBlockCarrying {
    protected static final String KEY_FORGEDATA_WRAPPED_ENTITY = "$_wrapped_entity";
    protected static final String KEY_FORGEDATA_WRAPPED_TILE = "$_wrapped_tile";
    public static final ResourceLocation CAP_IDENTIFIER = new ResourceLocation("charsettweaks:carry");
    @CapabilityInject(value=CarryHandler.class)
    public static Capability<CarryHandler> CAPABILITY;
    @CharsetModule.Configuration
    public static Configuration config;
    @CharsetModule.PacketRegistry
    public static PacketRegistry packet;
    public static boolean enabledCreative;

    @Mod.EventHandler
    public void loadConfig(CharsetLoadConfigEvent event) {
        enabledCreative = ConfigUtils.getBoolean((Configuration)config, (String)"general", (String)"enabledInCreative", (boolean)true, (String)"Should block carrying be enabled in creative mode?", (boolean)true);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        packet.registerPacket(1, PacketCarryGrab.class);
        packet.registerPacket(2, PacketCarrySync.class);
        CarryTransformerRegistry.INSTANCE.registerEntityTransformer(new CarryTransformerEntityMinecart());
        CarryHandler.register();
        MinecraftForge.EVENT_BUS.register((Object)new TweakCarryEventHandler());
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void initClient(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new TweakCarryRender());
    }

    protected static boolean canCarry(World world, BlockPos pos) {
        ThreeState allowedIMC;
        TileEntity tile;
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        boolean hasTileEntity = state.func_177230_c().hasTileEntity(state);
        boolean isVanilla = "minecraft".equals(block.getRegistryName().func_110624_b());
        HashSet<ResourceLocation> locs = new HashSet<ResourceLocation>();
        locs.add(state.func_177230_c().getRegistryName());
        if (hasTileEntity && (tile = world.func_175625_s(pos)) != null) {
            Class<?> tileClass = tile.getClass();
            locs.add(TileEntity.func_190559_a(tileClass));
        }
        if ((allowedIMC = CharsetIMC.INSTANCE.allows("carry", locs)) == ThreeState.NO) {
            return false;
        }
        if (allowedIMC == ThreeState.YES) {
            return true;
        }
        if (!isVanilla && hasTileEntity) {
            return false;
        }
        if (block instanceof BlockPistonExtension || block instanceof BlockPistonMoving) {
            return false;
        }
        if (block instanceof BlockPistonBase && (!state.func_177227_a().contains(BlockPistonBase.field_176320_b) || ((Boolean)state.func_177229_b((IProperty)BlockPistonBase.field_176320_b)).booleanValue())) {
            return false;
        }
        if (block instanceof IFluidBlock || block instanceof BlockLiquid) {
            return false;
        }
        return !(block instanceof BlockPortal) && !(block instanceof BlockEndPortal);
    }

    protected static boolean canCarry(Entity entity) {
        Class<?> entityClass = entity.getClass();
        EntityEntry entry = EntityRegistry.getEntry(entityClass);
        if (entry == null) {
            ModCharset.logger.warn(entityClass.getName() + " has no EntityEntry!");
        } else {
            ThreeState allowedIMC = CharsetIMC.INSTANCE.allows("carry", entry.getRegistryName());
            if (allowedIMC == ThreeState.NO) {
                return false;
            }
            if (allowedIMC == ThreeState.YES) {
                return true;
            }
        }
        return true;
    }

    public static boolean canPlayerConsiderCarryingBlock(EntityPlayer player) {
        return player.func_184586_b(EnumHand.MAIN_HAND).func_190926_b() && player.func_184586_b(EnumHand.OFF_HAND).func_190926_b() && !player.func_70608_bn() && !player.func_184218_aH() && (player.field_71070_bA == null || player.field_71070_bA == player.field_71069_bz);
    }

    public static void grabBlock(EntityPlayer player, World world, BlockPos pos) {
        if (!(player instanceof EntityPlayerMP)) {
            packet.sendToServer((Packet)new PacketCarryGrab(world, pos));
            return;
        }
        CarryHandler carryHandler = (CarryHandler)player.getCapability(CAPABILITY, null);
        if (carryHandler != null && !carryHandler.isCarrying()) {
            BlockEvent.BreakEvent event;
            boolean canCarry = CharsetTweakBlockCarrying.canCarry(world, pos);
            if (canCarry && world.func_180495_p(pos).func_185903_a(player, world, pos) < 0.0f) {
                canCarry = false;
            }
            if (canCarry && !world.func_175660_a(player, pos)) {
                canCarry = false;
            }
            if (canCarry && MinecraftForge.EVENT_BUS.post((Event)(event = new BlockEvent.BreakEvent(world, pos, world.func_180495_p(pos), player)))) {
                canCarry = false;
            }
            if (canCarry) {
                carryHandler.grab(world, pos);
                CharsetTweakBlockCarrying.syncCarryWithAllClients((Entity)player);
            } else {
                CharsetTweakBlockCarrying.syncCarryWithClient((Entity)player, player);
            }
        }
    }

    protected static void wrapForgeData(NBTTagCompound from, NBTTagCompound to, String source, String target) {
        if (!from.func_82582_d()) {
            NBTTagCompound wrap = from.func_74737_b();
            if (from.func_150297_b(target, 10)) {
                NBTTagCompound prevWrap = from.func_74775_l(target);
                for (String s : prevWrap.func_150296_c()) {
                    to.func_74782_a(s, prevWrap.func_74781_a(s));
                }
            }
            to.func_74782_a(source, (NBTBase)wrap);
        }
    }

    public static void grabEntity(EntityPlayer player, World world, Entity entity) {
        CarryHandler carryHandler;
        if (!(player instanceof EntityPlayerMP)) {
            packet.sendToServer((Packet)new PacketCarryGrab(world, entity));
        }
        if ((carryHandler = (CarryHandler)player.getCapability(CAPABILITY, null)) != null && !carryHandler.isCarrying()) {
            if (CharsetTweakBlockCarrying.canCarry(entity)) {
                for (ICarryTransformer<Entity> transformer : CarryTransformerRegistry.INSTANCE.getEntityTransformers()) {
                    if (transformer.extract(entity, true) == null) continue;
                    Pair<IBlockState, TileEntity> pair = transformer.extract(entity, false);
                    CharsetTweakBlockCarrying.wrapForgeData(entity.getEntityData(), ((TileEntity)pair.getRight()).getTileData(), KEY_FORGEDATA_WRAPPED_ENTITY, KEY_FORGEDATA_WRAPPED_TILE);
                    carryHandler.put((IBlockState)pair.getLeft(), (TileEntity)pair.getRight());
                    CharsetTweakBlockCarrying.syncCarryWithAllClients((Entity)player);
                    return;
                }
            } else {
                CharsetTweakBlockCarrying.syncCarryWithClient((Entity)player, player);
            }
        }
    }

    protected static boolean dropCarriedBlock(EntityPlayer entity, boolean must) {
        return CharsetTweakBlockCarrying.dropCarriedBlock(entity, must, must ? 4 : 2);
    }

    protected static boolean dropCarriedBlock(EntityPlayer entity, boolean must, int maxRadius) {
        CarryHandler carryHandler = (CarryHandler)entity.getCapability(CAPABILITY, null);
        if (carryHandler != null && carryHandler.isCarrying()) {
            World world = entity.func_130014_f_();
            if (world.field_72995_K) {
                carryHandler.empty();
                return true;
            }
            BlockPos base = entity.func_180425_c();
            for (int method = 0; method <= (must ? 2 : 1); ++method) {
                for (int radius = 0; radius <= maxRadius; ++radius) {
                    Vec3i radiusVec = new Vec3i(radius, radius, radius);
                    for (BlockPos pos : BlockPos.func_177975_b((BlockPos)base.func_177973_b(radiusVec), (BlockPos)base.func_177971_a(radiusVec))) {
                        if (!(!world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos) || method <= 1 && world.func_175623_d(pos.func_177977_b()) || method <= 0 && !world.isSideSolid(pos.func_177977_b(), EnumFacing.UP))) {
                            carryHandler.place(world, pos.func_185334_h(), EnumFacing.UP, entity);
                        }
                        if (carryHandler.isCarrying()) continue;
                        break;
                    }
                    if (!carryHandler.isCarrying()) break;
                }
                if (!carryHandler.isCarrying()) break;
            }
            if (carryHandler.isCarrying()) {
                if (must) {
                    ModCharset.logger.error("Could not drop carried block from player " + entity.func_70005_c_() + "! This is a bug!");
                }
                return false;
            }
            CharsetTweakBlockCarrying.syncCarryWithAllClients((Entity)entity);
            return true;
        }
        return true;
    }

    protected static void syncCarryWithClient(Entity who, EntityPlayer target) {
        if (who instanceof EntityPlayerMP && who.hasCapability(CAPABILITY, null)) {
            packet.sendTo((Packet)new PacketCarrySync(who, who == target), target);
        }
    }

    protected static void syncCarryWithAllClients(Entity who) {
        if (who instanceof EntityPlayerMP && who.hasCapability(CAPABILITY, null)) {
            packet.sendTo((Packet)new PacketCarrySync(who, true), (EntityPlayer)who);
            packet.sendToWatching((Packet)new PacketCarrySync(who, false), who, who);
        }
    }
}

