/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.tweak.carry;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetHandler;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import pl.asie.charset.lib.network.Packet;
import pl.asie.charset.module.tweak.carry.CharsetTweakBlockCarrying;

public class PacketCarryGrab
extends Packet {
    private EntityPlayer player;
    private Type type;
    private World world;
    private BlockPos pos;
    private int dim;
    private int entityId;

    public PacketCarryGrab() {
    }

    public PacketCarryGrab(World world, BlockPos pos) {
        this.world = world;
        this.type = Type.BLOCK;
        this.pos = pos;
    }

    public PacketCarryGrab(World world, Entity entity) {
        this.world = world;
        this.type = Type.ENTITY;
        this.entityId = entity.func_145782_y();
    }

    public void readData(INetHandler handler, PacketBuffer buf) {
        this.dim = buf.readInt();
        this.type = Type.values()[buf.readByte()];
        switch (this.type) {
            case BLOCK: {
                int x = buf.readInt();
                int y = buf.readInt();
                int z = buf.readInt();
                this.pos = new BlockPos(x, y, z);
                break;
            }
            case ENTITY: {
                this.entityId = buf.readInt();
            }
        }
    }

    public void apply(INetHandler handler) {
        this.player = PacketCarryGrab.getPlayer((INetHandler)handler);
        this.world = PacketCarryGrab.getWorld((INetHandler)handler, (int)this.dim);
        if (this.player != null && this.world != null) {
            switch (this.type) {
                case BLOCK: {
                    CharsetTweakBlockCarrying.grabBlock(this.player, this.world, this.pos);
                    break;
                }
                case ENTITY: {
                    Entity entity = this.world.func_73045_a(this.entityId);
                    if (entity == null) break;
                    CharsetTweakBlockCarrying.grabEntity(this.player, this.world, entity);
                }
            }
        }
    }

    public void writeData(PacketBuffer buf) {
        buf.writeInt(this.world.field_73011_w.getDimension());
        switch (this.type) {
            case BLOCK: {
                buf.writeByte(0);
                buf.writeInt(this.pos.func_177958_n());
                buf.writeInt(this.pos.func_177956_o());
                buf.writeInt(this.pos.func_177952_p());
                break;
            }
            case ENTITY: {
                buf.writeByte(1);
                buf.writeInt(this.entityId);
            }
        }
    }

    public boolean isAsynchronous() {
        return false;
    }

    static enum Type {
        BLOCK,
        ENTITY;

    }
}

