/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.tweak.carry;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetHandler;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import pl.asie.charset.lib.network.Packet;
import pl.asie.charset.module.tweak.carry.CarryHandler;
import pl.asie.charset.module.tweak.carry.CharsetTweakBlockCarrying;

public class PacketCarrySync
extends Packet {
    private Entity player;
    private NBTTagCompound tag;
    private boolean isSelf;
    private int playerId;
    private int dimension;

    public PacketCarrySync() {
    }

    public PacketCarrySync(Entity player, boolean isSelf) {
        this.player = player;
        this.isSelf = isSelf;
        this.tag = (NBTTagCompound)CarryHandler.PROVIDER.getStorage().writeNBT(CharsetTweakBlockCarrying.CAPABILITY, player.getCapability(CharsetTweakBlockCarrying.CAPABILITY, null), null);
    }

    public void readData(INetHandler handler, PacketBuffer buf) {
        this.isSelf = buf.readBoolean();
        if (!this.isSelf) {
            this.dimension = buf.readInt();
            this.playerId = buf.readInt();
        }
        this.tag = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void apply(INetHandler handler) {
        if (this.isSelf) {
            this.player = PacketCarrySync.getPlayer((INetHandler)handler);
        } else {
            World world = PacketCarrySync.getWorld((INetHandler)handler, (int)this.dimension);
            if (world != null) {
                this.player = world.func_73045_a(this.playerId);
            }
        }
        if (this.player != null && this.player.hasCapability(CharsetTweakBlockCarrying.CAPABILITY, null)) {
            CarryHandler carryHandler = (CarryHandler)this.player.getCapability(CharsetTweakBlockCarrying.CAPABILITY, null);
            carryHandler.setPlayer(this.player);
            CarryHandler.PROVIDER.getStorage().readNBT(CharsetTweakBlockCarrying.CAPABILITY, (Object)carryHandler, null, (NBTBase)this.tag);
        }
    }

    public void writeData(PacketBuffer buf) {
        buf.writeBoolean(this.isSelf);
        if (!this.isSelf) {
            buf.writeInt(this.player.func_130014_f_().field_73011_w.getDimension());
            buf.writeInt(this.player.func_145782_y());
        }
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tag);
    }

    public boolean isAsynchronous() {
        return false;
    }
}

