/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.tweak.carry;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.charset.lib.utils.AttributeUtils;
import pl.asie.charset.module.tweak.carry.CarryHandler;
import pl.asie.charset.module.tweak.carry.CarryTransformerRegistry;
import pl.asie.charset.module.tweak.carry.CharsetTweakBlockCarrying;
import pl.asie.charset.module.tweak.carry.ICarryTransformer;

public class TweakCarryEventHandler {
    private static final AttributeModifier MODIFIER_CARRY = AttributeUtils.newModifierSingleton((String)"charsettweaks:carry", (double)-0.25, (AttributeUtils.Operation)AttributeUtils.Operation.ADD_MULTIPLIED);

    private void cancelIfCarrying(Event event, EntityPlayer player) {
        CarryHandler carryHandler = (CarryHandler)player.getCapability(CharsetTweakBlockCarrying.CAPABILITY, null);
        if (carryHandler != null && carryHandler.isCarrying()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerUpdate(TickEvent.PlayerTickEvent event) {
        CarryHandler carryHandler;
        if (event.phase == TickEvent.Phase.END && (carryHandler = (CarryHandler)event.player.getCapability(CharsetTweakBlockCarrying.CAPABILITY, null)) != null && carryHandler.isCarrying()) {
            carryHandler.update();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onLivingFall(LivingFallEvent event) {
        CarryHandler carryHandler = (CarryHandler)event.getEntityLiving().getCapability(CharsetTweakBlockCarrying.CAPABILITY, null);
        if (carryHandler != null && event.getEntityLiving() instanceof EntityPlayer && carryHandler.isCarrying() && event.getDistance() >= 4.0f) {
            CharsetTweakBlockCarrying.dropCarriedBlock((EntityPlayer)event.getEntityLiving(), false);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onLivingHurt(LivingHurtEvent event) {
        CarryHandler carryHandler = (CarryHandler)event.getEntityLiving().getCapability(CharsetTweakBlockCarrying.CAPABILITY, null);
        if (carryHandler != null && event.getEntityLiving() instanceof EntityPlayer && carryHandler.isCarrying() && event.getSource() != DamageSource.field_76379_h && event.getSource() != DamageSource.field_76367_g) {
            CharsetTweakBlockCarrying.dropCarriedBlock((EntityPlayer)event.getEntityLiving(), false);
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            CharsetTweakBlockCarrying.dropCarriedBlock((EntityPlayer)event.getEntityLiving(), true);
        }
    }

    @SubscribeEvent
    public void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(CharsetTweakBlockCarrying.CAP_IDENTIFIER, CarryHandler.PROVIDER.create((Object)new CarryHandler().setPlayer((Entity)((EntityPlayer)event.getObject()))));
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        CharsetTweakBlockCarrying.syncCarryWithAllClients((Entity)event.player);
    }

    @SubscribeEvent
    public void onPlayerRespawnEvent(PlayerEvent.PlayerRespawnEvent event) {
        CharsetTweakBlockCarrying.syncCarryWithAllClients((Entity)event.player);
    }

    @SubscribeEvent
    public void onPlayerChangedDimensionEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        CharsetTweakBlockCarrying.syncCarryWithAllClients((Entity)event.player);
    }

    @SubscribeEvent
    public void onPlayerStartTracking(PlayerEvent.StartTracking event) {
        CharsetTweakBlockCarrying.syncCarryWithClient(event.getTarget(), event.getEntityPlayer());
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        CarryHandler carryHandler = (CarryHandler)event.player.getCapability(CharsetTweakBlockCarrying.CAPABILITY, null);
        IAttributeInstance movementSpeed = event.player.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111263_d);
        if (carryHandler != null && carryHandler.isCarrying()) {
            if (event.player.func_70051_ag()) {
                event.player.func_70031_b(false);
            }
            if (!event.player.func_70644_a(MobEffects.field_76420_g) && !movementSpeed.func_180374_a(MODIFIER_CARRY)) {
                movementSpeed.func_111121_a(MODIFIER_CARRY);
            }
        } else if (movementSpeed.func_180374_a(MODIFIER_CARRY)) {
            movementSpeed.func_111124_b(MODIFIER_CARRY);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private boolean startCarry(boolean allowCreative) {
        boolean result = false;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        CarryHandler carryHandler = (CarryHandler)player.getCapability(CharsetTweakBlockCarrying.CAPABILITY, null);
        if (!player.func_184812_l_()) {
            result = true;
        } else if (!allowCreative || !CharsetTweakBlockCarrying.enabledCreative) {
            return false;
        }
        if (CharsetTweakBlockCarrying.canPlayerConsiderCarryingBlock((EntityPlayer)player) && carryHandler != null) {
            if (player.func_184812_l_()) {
                result = true;
            }
            RayTraceResult mouseOver = Minecraft.func_71410_x().field_71476_x;
            if (mouseOver.field_72313_a == RayTraceResult.Type.BLOCK) {
                CharsetTweakBlockCarrying.grabBlock((EntityPlayer)player, player.func_130014_f_(), mouseOver.func_178782_a());
            } else if (mouseOver.field_72313_a == RayTraceResult.Type.ENTITY) {
                Entity entity = mouseOver.field_72308_g;
                CharsetTweakBlockCarrying.grabEntity((EntityPlayer)player, player.func_130014_f_(), entity);
            }
        }
        return result;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onMouse(MouseEvent event) {
        if (event.isButtonstate() && Minecraft.func_71410_x().field_71474_y.field_74322_I.isActiveAndMatches(-100 + event.getButton()) && Minecraft.func_71410_x().field_71474_y.field_74311_E.func_151470_d() && this.startCarry(true)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onKey(InputEvent.KeyInputEvent event) {
        if (Minecraft.func_71410_x().field_71474_y.field_74322_I.func_151470_d() && Minecraft.func_71410_x().field_71474_y.field_74311_E.func_151470_d()) {
            this.startCarry(false);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        CarryHandler carryHandler = (CarryHandler)player.getCapability(CharsetTweakBlockCarrying.CAPABILITY, null);
        if (carryHandler != null && carryHandler.isCarrying()) {
            event.setCanceled(true);
            World world = event.getWorld();
            BlockPos pos = event.getPos();
            EnumFacing facing = event.getFace();
            IBlockState state = world.func_180495_p(pos);
            if (!state.func_177230_c().func_176200_f((IBlockAccess)world, pos)) {
                pos = pos.func_177972_a(facing);
            }
            carryHandler.place(world, pos, facing, player);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onEntityInteractSpecific(PlayerInteractEvent.EntityInteractSpecific event) {
        EntityPlayer player = event.getEntityPlayer();
        CarryHandler carryHandler = (CarryHandler)player.getCapability(CharsetTweakBlockCarrying.CAPABILITY, null);
        if (carryHandler != null && carryHandler.isCarrying()) {
            event.setCanceled(true);
            Entity entity = event.getTarget();
            for (ICarryTransformer<Entity> transformer : CarryTransformerRegistry.INSTANCE.getEntityTransformers()) {
                TileEntity tile;
                IBlockState state;
                if (!transformer.insert(entity, state = carryHandler.getState(), tile = carryHandler.getTile(), true)) continue;
                carryHandler.empty();
                transformer.insert(entity, state, tile, false);
                CharsetTweakBlockCarrying.wrapForgeData(tile.getTileData(), entity.getEntityData(), "$_wrapped_tile", "$_wrapped_entity");
                CharsetTweakBlockCarrying.syncCarryWithAllClients((Entity)player);
                return;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        this.cancelIfCarrying((Event)event, event.getEntityPlayer());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        this.cancelIfCarrying((Event)event, event.getEntityPlayer());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        this.cancelIfCarrying((Event)event, event.getEntityPlayer());
    }
}

