/*
 * Decompiled with CFR 0.152.
 */
package nihiltres.engineersdoors;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;
import nihiltres.engineersdoors.common.item.IOre;
import nihiltres.engineersdoors.common.module.Doors;
import nihiltres.engineersdoors.common.module.Fencegates;
import nihiltres.engineersdoors.common.module.Module;
import nihiltres.engineersdoors.common.module.Trapdoors;
import nihiltres.engineersdoors.proxy.CommonProxy;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

@Mod(modid="engineersdoors", name="Engineer's Doors", version="0.7.2", dependencies="required-after:immersiveengineering;", acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber
public class EngineersDoors {
    @Mod.Instance(value="engineersdoors")
    public static EngineersDoors instance;
    @SidedProxy(serverSide="nihiltres.engineersdoors.proxy.CommonProxy", clientSide="nihiltres.engineersdoors.proxy.ClientProxy")
    public static CommonProxy proxy;
    public static CreativeTabs creativeTab;
    public static Set<Module> modules;
    private static Logger edLog;

    public static void log(String msg) {
        edLog.log(Level.INFO, msg);
    }

    public static void debug(Throwable e) {
        EngineersDoors.debug(e.getClass().toString().substring(6));
        String msg = e.getMessage();
        if (msg != null) {
            EngineersDoors.debug(msg);
        }
        for (StackTraceElement ste : e.getStackTrace()) {
            EngineersDoors.debug(ste.toString());
        }
    }

    public static void debug(String msg) {
        edLog.log(Level.WARN, msg);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        edLog = event.getModLog();
        for (Module module : modules) {
            EngineersDoors.log(String.format("Pre-initializing %s module", module.getName()));
            module.preInit();
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        for (Module module : modules) {
            EngineersDoors.log(String.format("Initializing %s module", module.getName()));
            module.init();
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        for (Module module : modules) {
            EngineersDoors.log(String.format("Post-initializing %s module", module.getName()));
            module.postInit();
        }
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        for (Module module : modules) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])module.getBlocks());
        }
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        for (Module module : modules) {
            for (Item item : module.getItems()) {
                event.getRegistry().register((IForgeRegistryEntry)item);
                if (!(item instanceof IOre)) continue;
                for (String s : ((IOre)item).getOreNames()) {
                    OreDictionary.registerOre((String)s, (Item)item);
                }
            }
        }
    }

    static {
        creativeTab = ImmersiveEngineering.creativeTab;
        modules = new HashSet<Module>();
        modules.add(new Doors());
        modules.add(new Fencegates());
        modules.add(new Trapdoors());
    }
}

