/*
 * Decompiled with CFR 0.152.
 */
package nihiltres.engineersdoors.common.block;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import nihiltres.engineersdoors.EngineersDoors;
import nihiltres.engineersdoors.common.EDConfig;
import nihiltres.engineersdoors.common.block.IQuickSetup;
import nihiltres.engineersdoors.common.item.IOre;
import nihiltres.engineersdoors.common.item.ItemEDDoor;

public class BlockEDDoor
extends BlockDoor
implements IQuickSetup,
IOre {
    public String name;
    public ArrayList<String> oreNames = new ArrayList();
    public boolean opensManually;
    public ItemEDDoor item;
    private static boolean quarkDoubleDoors = false;

    public BlockEDDoor(Material materialIn, String nameIn, String oreNameIn) {
        super(materialIn == null ? Material.field_151575_d : materialIn);
        boolean bl = this.opensManually = this.field_149764_J != Material.field_151573_f;
        if (nameIn == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        if (oreNameIn == null) {
            throw new IllegalArgumentException("Ore name list cannot be null");
        }
        this.setName(nameIn);
        this.oreNames.add(oreNameIn);
        this.item = new ItemEDDoor((Block)this, nameIn, oreNameIn);
    }

    public BlockEDDoor(Material materialIn, String nameIn, String oreNameIn, boolean manual) {
        this(materialIn, nameIn, oreNameIn);
        this.opensManually = manual;
    }

    public void setName(String nameIn) {
        this.name = nameIn;
        ((Block)this.setRegistryName(this.name)).func_149663_c(this.name);
        if (this.item != null) {
            ((Item)this.item.setRegistryName(this.name)).func_77655_b(this.name);
        }
    }

    @Override
    public BlockEDDoor setBlockProperties(float hardness, float resistance, String harvestTool, int harvestLevel) {
        this.func_149711_c(hardness).func_149752_b(resistance).setHarvestLevel(harvestTool, harvestLevel);
        return this;
    }

    public ArrayList<String> getOreNames() {
        return this.oreNames;
    }

    @Override
    public BlockEDDoor addOreName(String oreNameIn) {
        this.oreNames.add(oreNameIn);
        this.item.addOreName(oreNameIn);
        return this;
    }

    public boolean toggleOpen(@Nullable EntityPlayer playerIn, World worldIn, BlockPos posIn, IBlockState state, EnumFacing facing) {
        IBlockState stateAtPos;
        BlockPos pos = state.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.LOWER ? posIn : posIn.func_177977_b();
        IBlockState iBlockState = stateAtPos = posIn.equals((Object)pos) ? state : worldIn.func_180495_p(pos);
        if (!(stateAtPos.func_177230_c() instanceof BlockDoor)) {
            return false;
        }
        IBlockState newState = stateAtPos.func_177231_a((IProperty)field_176519_b);
        worldIn.func_180501_a(pos, newState, 10);
        worldIn.func_175704_b(pos, posIn);
        worldIn.func_180498_a(playerIn, (Boolean)state.func_177229_b((IProperty)field_176519_b) != false ? this.getOpenSound() : this.getCloseSound(), pos, 0);
        return true;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!this.opensManually && !EDConfig.manualSteelDoors) {
            return false;
        }
        if (quarkDoubleDoors && EDConfig.manualSteelDoors && !playerIn.func_70093_af() && this.field_149764_J == Material.field_151573_f) {
            IBlockState actualState = state.func_185899_b((IBlockAccess)worldIn, pos);
            boolean isOpen = (Boolean)actualState.func_177229_b((IProperty)BlockDoor.field_176519_b);
            EnumFacing direction = (EnumFacing)actualState.func_177229_b((IProperty)BlockDoor.field_176520_a);
            BlockDoor.EnumHingePosition hinge = (BlockDoor.EnumHingePosition)actualState.func_177229_b((IProperty)BlockDoor.field_176521_M);
            BlockPos mirrorPos = pos.func_177972_a(hinge == BlockDoor.EnumHingePosition.RIGHT ? direction.func_176735_f() : direction.func_176746_e());
            IBlockState other = worldIn.func_180495_p(mirrorPos).func_185899_b((IBlockAccess)worldIn, mirrorPos);
            if (other.func_177230_c() instanceof BlockDoor && other.func_177229_b((IProperty)BlockDoor.field_176520_a) == direction && (Boolean)other.func_177229_b((IProperty)BlockDoor.field_176519_b) == isOpen && other.func_177229_b((IProperty)BlockDoor.field_176521_M) != hinge) {
                boolean flag = this.toggleOpen(playerIn, worldIn, pos, state, facing);
                if (flag) {
                    this.toggleOpen(playerIn, worldIn, mirrorPos, other, facing);
                }
                return flag;
            }
        }
        return this.toggleOpen(playerIn, worldIn, pos, state, facing);
    }

    private int getCloseSound() {
        return this.field_149764_J == Material.field_151573_f ? 1011 : 1012;
    }

    private int getOpenSound() {
        return this.field_149764_J == Material.field_151573_f ? 1005 : 1006;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return state.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.UPPER ? Items.field_190931_a : this.item;
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Item)this.item);
    }

    public static void checkForQuarkDoubleDoors() {
        if (Loader.isModLoaded((String)"quark")) {
            try {
                Method qIsFeatureEnabled = Class.forName("vazkii.quark.base.module.ModuleLoader").getMethod("isFeatureEnabled", Class.class);
                Class<?> qDoubleDoorsClass = Class.forName("vazkii.quark.tweaks.feature.DoubleDoors");
                boolean oldQDD = quarkDoubleDoors;
                quarkDoubleDoors = (Boolean)qIsFeatureEnabled.invoke(null, qDoubleDoorsClass);
                if (quarkDoubleDoors && !oldQDD) {
                    EngineersDoors.log("Quark double-door compatibility enabled");
                }
                if (oldQDD && !quarkDoubleDoors) {
                    EngineersDoors.log("Quark double-door compatibility disabled");
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }
}

