/*
 * Decompiled with CFR 0.152.
 */
package nihiltres.engineersdoors.common.block;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.blocks.metal.BlockMetalLadder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import nihiltres.engineersdoors.EngineersDoors;
import nihiltres.engineersdoors.common.EDConfig;
import nihiltres.engineersdoors.common.block.IQuickSetup;
import nihiltres.engineersdoors.common.item.IOre;
import nihiltres.engineersdoors.common.item.ItemBlockOre;

public class BlockEDTrapdoor
extends BlockTrapDoor
implements IOre,
IQuickSetup {
    public String name;
    public ArrayList<String> oreNames = new ArrayList();
    public ItemBlockOre itemBlock;
    public boolean opensManually = this.field_149764_J != Material.field_151573_f;
    private static Set<Class<?>> ladderClasses = new HashSet();

    public BlockEDTrapdoor(Material materialIn, String nameIn, String oreNameIn) {
        super(materialIn == null ? Material.field_151575_d : materialIn);
        this.func_149647_a(EngineersDoors.creativeTab);
        if (nameIn == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        if (oreNameIn == null) {
            throw new IllegalArgumentException("Ore name cannot be null");
        }
        this.setName(nameIn);
        this.oreNames.add(oreNameIn);
        this.itemBlock = new ItemBlockOre((Block)this, this.name, oreNameIn);
    }

    public BlockEDTrapdoor(Material materialIn, String nameIn, String oreNameIn, boolean manual) {
        this(materialIn, nameIn, oreNameIn);
        this.opensManually = manual;
    }

    public void setName(String nameIn) {
        this.name = nameIn;
        ((Block)this.setRegistryName(this.name)).func_149663_c(this.name);
        if (this.itemBlock != null) {
            ((Item)this.itemBlock.setRegistryName(this.name)).func_77655_b(this.name);
        }
    }

    public ArrayList<String> getOreNames() {
        return this.oreNames;
    }

    @Override
    public BlockEDTrapdoor addOreName(String oreNameIn) {
        this.oreNames.add(oreNameIn);
        this.itemBlock.addOreName(oreNameIn);
        return this;
    }

    @Override
    public BlockEDTrapdoor setBlockProperties(float hardness, float resistance, String harvestTool, int harvestLevel) {
        this.func_149711_c(hardness).func_149752_b(resistance).setHarvestLevel(harvestTool, harvestLevel);
        return this;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!this.opensManually && !EDConfig.manualSteelDoors) {
            return false;
        }
        state = state.func_177231_a((IProperty)field_176283_b);
        worldIn.func_180501_a(pos, state, 2);
        this.func_185731_a(playerIn, worldIn, pos, (Boolean)state.func_177229_b((IProperty)field_176283_b));
        return true;
    }

    public static boolean addLadderClass(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("The null class is not allowed");
        }
        return ladderClasses.add(clazz);
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        if (!((Boolean)state.func_177229_b((IProperty)field_176283_b)).booleanValue()) {
            return false;
        }
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)field_176284_a);
        IBlockState downState = world.func_180495_p(pos.func_177977_b());
        Class<?> downClass = downState.func_177230_c().getClass();
        if (BlockLadder.class.isAssignableFrom(downClass)) {
            return downState.func_177229_b((IProperty)BlockLadder.field_176382_a) == facing;
        }
        if (downClass == BlockMetalLadder.class) {
            return downState.func_177230_c().func_176221_a(downState, world, pos.func_177977_b()).func_177229_b((IProperty)IEProperties.FACING_HORIZONTAL) == facing;
        }
        if (Loader.isModLoaded((String)"quark")) {
            try {
                Class<?> qLadderClass = Class.forName("vazkii.quark.decoration.block.BlockIronLadder");
                IProperty qLadderFacing = (IProperty)qLadderClass.getField("FACING").get(null);
                if (downClass == qLadderClass) {
                    return downState.func_177229_b(qLadderFacing) == facing;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        return ladderClasses.contains(downClass);
    }

    public static void checkForModLadders() {
    }

    private static void addModLadder(String modID, String modLadderClassName) {
        if (Loader.isModLoaded((String)modID)) {
            try {
                Class<?> modLadderClass = Class.forName(modLadderClassName);
                if (BlockEDTrapdoor.addLadderClass(modLadderClass)) {
                    EngineersDoors.log("Ladder compatibility enabled for " + modLadderClassName);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }
}

