/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features.registries.cell;

import appeng.api.AEApi;
import appeng.api.implementations.tiles.IChestOrDrive;
import appeng.api.storage.ICellHandler;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.ISaveProvider;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AEPartLocation;
import appeng.core.sync.GuiBridge;
import appeng.me.storage.CellInventory;
import appeng.me.storage.CellInventoryHandler;
import appeng.util.Platform;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class BasicCellHandler
implements ICellHandler {
    @Override
    public boolean isCell(ItemStack is) {
        return CellInventory.isCell(is);
    }

    @Override
    public <T extends IAEStack<T>> IMEInventoryHandler<T> getCellInventory(ItemStack is, ISaveProvider container, IStorageChannel<T> channel) {
        if (channel == AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)) {
            return CellInventory.getCell(is, container);
        }
        return null;
    }

    public void openChestGui(EntityPlayer player, IChestOrDrive chest, ICellHandler cellHandler, IMEInventoryHandler inv, ItemStack is, IStorageChannel chan) {
        Platform.openGUI(player, (TileEntity)chest, AEPartLocation.fromFacing(chest.getUp()), GuiBridge.GUI_ME);
    }

    public int getStatusForCell(ItemStack is, IMEInventory handler) {
        if (handler instanceof CellInventoryHandler) {
            CellInventoryHandler ci = (CellInventoryHandler)handler;
            return ci.getStatusForCell();
        }
        return 0;
    }

    public double cellIdleDrain(ItemStack is, IMEInventory handler) {
        ICellInventory inv = ((ICellInventoryHandler)handler).getCellInv();
        return inv.getIdleDrain();
    }
}

