/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features.registries.cell;

import appeng.api.storage.ICellHandler;
import appeng.api.storage.ICellRegistry;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.ISaveProvider;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;

public class CellRegistry
implements ICellRegistry {
    private final List<ICellHandler> handlers = new ArrayList<ICellHandler>();

    @Override
    public void addCellHandler(ICellHandler h) {
        if (h != null) {
            this.handlers.add(h);
        }
    }

    @Override
    public boolean isCellHandled(ItemStack is) {
        if (is.func_190926_b()) {
            return false;
        }
        for (ICellHandler ch : this.handlers) {
            if (!ch.isCell(is)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ICellHandler getHandler(ItemStack is) {
        if (is.func_190926_b()) {
            return null;
        }
        for (ICellHandler ch : this.handlers) {
            if (!ch.isCell(is)) continue;
            return ch;
        }
        return null;
    }

    @Override
    public <T extends IAEStack<T>> IMEInventoryHandler<T> getCellInventory(ItemStack is, ISaveProvider container, IStorageChannel<T> chan) {
        if (is.func_190926_b()) {
            return null;
        }
        for (ICellHandler ch : this.handlers) {
            if (!ch.isCell(is)) continue;
            return ch.getCellInventory(is, container, chan);
        }
        return null;
    }
}

