/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.worlddata;

import appeng.core.AELog;
import appeng.util.UUIDMatcher;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Property;

class PlayerMappingsInitializer {
    private final Map<Integer, UUID> playerMappings;

    PlayerMappingsInitializer(ConfigCategory playerList) {
        UUIDMatcher matcher = new UUIDMatcher();
        int capacity = playerList.size();
        this.playerMappings = new HashMap<Integer, UUID>(capacity);
        for (Map.Entry entry : playerList.getValues().entrySet()) {
            String maybeUUID = (String)entry.getKey();
            int id = ((Property)entry.getValue()).getInt();
            if (matcher.isUUID(maybeUUID)) {
                UUID uuidString = UUID.fromString(maybeUUID);
                this.playerMappings.put(id, uuidString);
                continue;
            }
            AELog.warn("The configuration for players contained an outdated entry instead an expected UUID " + maybeUUID + " for the player " + id + ". Please clean this up.", new Object[0]);
        }
    }

    public Map<Integer, UUID> getPlayerMappings() {
        return this.playerMappings;
    }
}

