/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.storage;

import appeng.api.AEApi;
import appeng.api.config.FuzzyMode;
import appeng.api.config.IncludeExclude;
import appeng.api.exceptions.MissingDefinitionException;
import appeng.api.implementations.items.IItemGroup;
import appeng.api.implementations.items.IStorageCell;
import appeng.api.implementations.items.IUpgradeModule;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.core.AEConfig;
import appeng.core.features.AEFeature;
import appeng.core.localization.GuiText;
import appeng.items.AEBaseItem;
import appeng.items.contents.CellConfig;
import appeng.items.contents.CellUpgrades;
import appeng.items.materials.MaterialType;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import java.util.List;
import java.util.Set;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;

public final class ItemBasicStorageCell
extends AEBaseItem
implements IStorageCell,
IItemGroup {
    private final MaterialType component;
    private final int totalBytes;
    private final int perType;
    private final double idleDrain;

    public ItemBasicStorageCell(MaterialType whichCell, int kilobytes) {
        this.func_77625_d(1);
        this.totalBytes = kilobytes * 1024;
        this.component = whichCell;
        switch (this.component) {
            case CELL1K_PART: {
                this.idleDrain = 0.5;
                this.perType = 8;
                break;
            }
            case CELL4K_PART: {
                this.idleDrain = 1.0;
                this.perType = 32;
                break;
            }
            case CELL16K_PART: {
                this.idleDrain = 1.5;
                this.perType = 128;
                break;
            }
            case CELL64K_PART: {
                this.idleDrain = 2.0;
                this.perType = 512;
                break;
            }
            default: {
                this.idleDrain = 0.0;
                this.perType = 8;
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addCheckedInformation(ItemStack stack, World world, List<String> lines, ITooltipFlag advancedTooltips) {
        ICellInventoryHandler handler;
        ICellInventory cellInventory;
        IMEInventoryHandler<IAEItemStack> inventory = AEApi.instance().registries().cell().getCellInventory(stack, null, AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
        if (inventory instanceof ICellInventoryHandler && (cellInventory = (handler = (ICellInventoryHandler)inventory).getCellInv()) != null) {
            lines.add(cellInventory.getUsedBytes() + " " + GuiText.Of.getLocal() + ' ' + cellInventory.getTotalBytes() + ' ' + GuiText.BytesUsed.getLocal());
            lines.add(cellInventory.getStoredItemTypes() + " " + GuiText.Of.getLocal() + ' ' + cellInventory.getTotalItemTypes() + ' ' + GuiText.Types.getLocal());
            if (handler.isPreformatted()) {
                String list = (handler.getIncludeExcludeMode() == IncludeExclude.WHITELIST ? GuiText.Included : GuiText.Excluded).getLocal();
                if (handler.isFuzzy()) {
                    lines.add(GuiText.Partitioned.getLocal() + " - " + list + ' ' + GuiText.Fuzzy.getLocal());
                } else {
                    lines.add(GuiText.Partitioned.getLocal() + " - " + list + ' ' + GuiText.Precise.getLocal());
                }
            }
        }
    }

    @Override
    public int getBytes(ItemStack cellItem) {
        return this.totalBytes;
    }

    @Override
    public int getBytesPerType(ItemStack cellItem) {
        return this.perType;
    }

    @Override
    public int getTotalTypes(ItemStack cellItem) {
        return 63;
    }

    @Override
    public boolean isBlackListed(ItemStack cellItem, IAEItemStack requestedAddition) {
        return false;
    }

    @Override
    public boolean storableInStorageCell() {
        return false;
    }

    @Override
    public boolean isStorageCell(ItemStack i) {
        return true;
    }

    @Override
    public double getIdleDrain() {
        return this.idleDrain;
    }

    @Override
    public String getUnlocalizedGroupName(Set<ItemStack> others, ItemStack is) {
        return GuiText.StorageCells.getUnlocalized();
    }

    @Override
    public boolean isEditable(ItemStack is) {
        return true;
    }

    @Override
    public IItemHandler getUpgradesInventory(ItemStack is) {
        return new CellUpgrades(is, 2);
    }

    @Override
    public IItemHandler getConfigInventory(ItemStack is) {
        return new CellConfig(is);
    }

    @Override
    public FuzzyMode getFuzzyMode(ItemStack is) {
        String fz = Platform.openNbtData(is).func_74779_i("FuzzyMode");
        try {
            return FuzzyMode.valueOf(fz);
        }
        catch (Throwable t) {
            return FuzzyMode.IGNORE_ALL;
        }
    }

    @Override
    public void setFuzzyMode(ItemStack is, FuzzyMode fzMode) {
        Platform.openNbtData(is).func_74778_a("FuzzyMode", fzMode.name());
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        this.disassembleDrive(player.func_184586_b(hand), world, player);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    private boolean disassembleDrive(ItemStack stack, World world, EntityPlayer player) {
        if (player.func_70093_af()) {
            if (Platform.isClient()) {
                return false;
            }
            InventoryPlayer playerInventory = player.field_71071_by;
            IMEInventoryHandler<IAEItemStack> inv = AEApi.instance().registries().cell().getCellInventory(stack, null, AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
            if (inv != null && playerInventory.func_70448_g() == stack) {
                InventoryAdaptor ia = InventoryAdaptor.getAdaptor(player);
                IItemList list = inv.getAvailableItems(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class).createList());
                if (list.isEmpty() && ia != null) {
                    playerInventory.func_70299_a(playerInventory.field_70461_c, ItemStack.field_190927_a);
                    ItemStack extraB = ia.addItems(this.component.stack(1));
                    if (!extraB.func_190926_b()) {
                        player.func_71019_a(extraB, false);
                    }
                    IItemHandler upgradesInventory = this.getUpgradesInventory(stack);
                    for (int upgradeIndex = 0; upgradeIndex < upgradesInventory.getSlots(); ++upgradeIndex) {
                        ItemStack upgradeStack = upgradesInventory.getStackInSlot(upgradeIndex);
                        ItemStack leftStack = ia.addItems(upgradeStack);
                        if (leftStack.func_190926_b() || !(upgradeStack.func_77973_b() instanceof IUpgradeModule)) continue;
                        player.func_71019_a(upgradeStack, false);
                    }
                    AEApi.instance().definitions().materials().emptyStorageCell().maybeStack(1).ifPresent(is -> {
                        ItemStack extraA = ia.addItems((ItemStack)is);
                        if (!extraA.func_190926_b()) {
                            player.func_71019_a(extraA, false);
                        }
                    });
                    if (player.field_71069_bz != null) {
                        player.field_71069_bz.func_75142_b();
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        return this.disassembleDrive(player.func_184586_b(hand), world, player) ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        return AEApi.instance().definitions().materials().emptyStorageCell().maybeStack(1).orElseThrow(() -> new MissingDefinitionException("Tried to use empty storage cells while basic storage cells are defined."));
    }

    public boolean hasContainerItem(ItemStack stack) {
        return AEConfig.instance().isFeatureEnabled(AEFeature.ENABLE_DISASSEMBLY_CRAFTING);
    }
}

