/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.helpers;

import appeng.util.inv.IInternalItemHandler;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ItemHandlerUtil {
    private ItemHandlerUtil() {
    }

    public static void setStackInSlot(IItemHandler inv, int slot, ItemStack stack) {
        if (inv instanceof IItemHandlerModifiable) {
            ((IItemHandlerModifiable)inv).setStackInSlot(slot, stack);
        } else {
            inv.extractItem(slot, Integer.MAX_VALUE, false);
            inv.insertItem(slot, stack, false);
        }
    }

    public static void clear(IItemHandler inv) {
        for (int x = 0; x < inv.getSlots(); ++x) {
            ItemHandlerUtil.setStackInSlot(inv, x, ItemStack.field_190927_a);
        }
    }

    public static boolean isEmpty(IItemHandler inv) {
        for (int x = 0; x < inv.getSlots(); ++x) {
            if (inv.getStackInSlot(x).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public static void markDirty(IItemHandler inv, int slot) {
        if (inv instanceof IInternalItemHandler) {
            ((IInternalItemHandler)inv).markDirty(slot);
        }
    }

    public static boolean isItemValidForSlot(IItemHandler inv, int slot, ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (inv instanceof IInternalItemHandler) {
            return ((IInternalItemHandler)inv).isItemValidForSlot(slot, stack);
        }
        ItemStack currentStack = inv.getStackInSlot(slot);
        ItemHandlerUtil.setStackInSlot(inv, slot, ItemStack.field_190927_a);
        ItemStack remainder = inv.insertItem(slot, stack, true);
        ItemHandlerUtil.setStackInSlot(inv, slot, currentStack);
        return remainder.func_190926_b() || remainder.func_190916_E() < stack.func_190916_E();
    }

    public static void copy(IItemHandler from, IItemHandler to, boolean deepCopy) {
        for (int i = 0; i < Math.min(from.getSlots(), to.getSlots()); ++i) {
            ItemHandlerUtil.setStackInSlot(to, i, deepCopy ? from.getStackInSlot(i).func_77946_l() : from.getStackInSlot(i));
        }
    }

    public static void copy(InventoryCrafting from, IItemHandler to, boolean deepCopy) {
        for (int i = 0; i < Math.min(from.func_70302_i_(), to.getSlots()); ++i) {
            ItemHandlerUtil.setStackInSlot(to, i, deepCopy ? from.func_70301_a(i).func_77946_l() : from.func_70301_a(i));
        }
    }
}

