/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.helpers;

import appeng.api.util.AEColor;
import com.google.common.base.Preconditions;
import net.minecraft.util.text.TextFormatting;

public class P2PHelper {
    public AEColor[] toColors(short frequency) {
        AEColor[] colors = new AEColor[4];
        for (int i = 0; i < 4; ++i) {
            int nibble = frequency >> 4 * (3 - i) & 0xF;
            colors[i] = AEColor.values()[nibble];
        }
        return colors;
    }

    public short fromColors(AEColor[] colors) {
        Preconditions.checkArgument((colors.length == 4 ? 1 : 0) != 0);
        int t = 0;
        for (int i = 0; i < 4; ++i) {
            int code = colors[3 - i].ordinal() << 4 * i;
            t |= code;
        }
        return (short)(t & 0xFFFF);
    }

    public String toHexDigit(AEColor color) {
        return String.format("%01X", color.ordinal());
    }

    public String toHexString(short frequency) {
        return String.format("%04X", frequency);
    }

    public String toColorHexDigit(AEColor color) {
        return TextFormatting.func_175744_a((int)color.ordinal()) + this.toHexDigit(color);
    }

    public String toColorHexString(short frequency) {
        AEColor[] colors = this.toColors(frequency);
        StringBuilder builder = new StringBuilder();
        for (AEColor aeColor : colors) {
            builder.append(this.toColorHexDigit(aeColor));
        }
        return builder.toString();
    }
}

