/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.misc.feature;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import vazkii.arl.util.ProxyRegistry;
import vazkii.quark.base.module.Feature;
import vazkii.quark.misc.item.ItemAncientTome;

public class AncientTomes
extends Feature {
    public static Item ancient_tome;
    public static List<Enchantment> validEnchants;
    private String[] enchantNames;
    int dungeonWeight;
    int libraryWeight;
    int itemQuality;
    int mergeTomeCost;
    int applyTomeCost;

    @Override
    public void setupConfig() {
        this.enchantNames = this.loadPropStringList("Valid Enchantments", "", this.generateDefaultEnchantmentList());
        this.dungeonWeight = this.loadPropInt("Dungeon loot weight", "", 8);
        this.libraryWeight = this.loadPropInt("Stronghold Library loot weight", "", 12);
        this.itemQuality = this.loadPropInt("Item quality for loot", "", 2);
        this.mergeTomeCost = this.loadPropInt("Cost to apply tome", "", 35);
        this.applyTomeCost = this.loadPropInt("Cost to apply upgraded book to item", "", 35);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        ancient_tome = new ItemAncientTome();
        LootFunctionManager.func_186582_a((LootFunction.Serializer)new EnchantTomeFunction.Serializer());
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        validEnchants.clear();
        for (String s : this.enchantNames) {
            ResourceLocation r = new ResourceLocation(s);
            Enchantment e = (Enchantment)Enchantment.field_185264_b.func_82594_a((Object)r);
            if (e == null) continue;
            validEnchants.add(e);
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        if (event.getName().equals((Object)LootTableList.field_186426_h)) {
            event.getTable().getPool("main").addEntry((LootEntry)new LootEntryItem(ancient_tome, this.libraryWeight, this.itemQuality, new LootFunction[]{new EnchantTomeFunction()}, new LootCondition[0], "quark:ancient_tome"));
        } else if (event.getName().equals((Object)LootTableList.field_186422_d)) {
            event.getTable().getPool("main").addEntry((LootEntry)new LootEntryItem(ancient_tome, this.dungeonWeight, this.itemQuality, new LootFunction[]{new EnchantTomeFunction()}, new LootCondition[0], "quark:ancient_tome"));
        }
    }

    @SubscribeEvent
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        if (!left.func_190926_b() && !right.func_190926_b()) {
            if (left.func_77973_b() == Items.field_151134_bR && right.func_77973_b() == ancient_tome) {
                this.handleTome(left, right, event);
            } else if (right.func_77973_b() == Items.field_151134_bR && left.func_77973_b() == ancient_tome) {
                this.handleTome(right, left, event);
            } else if (right.func_77973_b() == Items.field_151134_bR) {
                Map enchants = EnchantmentHelper.func_82781_a((ItemStack)right);
                Map currentEnchants = EnchantmentHelper.func_82781_a((ItemStack)left);
                boolean hasOverLevel = false;
                boolean hasMatching = false;
                for (Map.Entry entry : enchants.entrySet()) {
                    Enchantment ench = (Enchantment)entry.getKey();
                    if (ench == null) continue;
                    int level = (Integer)entry.getValue();
                    if (level > ench.func_77325_b()) {
                        hasOverLevel = true;
                        if (!ench.func_92089_a(left)) continue;
                        hasMatching = true;
                        Iterator iterator = currentEnchants.keySet().iterator();
                        while (iterator.hasNext()) {
                            Enchantment enchCompare = (Enchantment)iterator.next();
                            if (enchCompare == ench || enchCompare.func_191560_c(ench)) continue;
                            iterator.remove();
                        }
                        currentEnchants.put(ench, level);
                        continue;
                    }
                    if (!ench.func_92089_a(left)) continue;
                    boolean compatible = true;
                    for (Enchantment enchCompare : currentEnchants.keySet()) {
                        if (enchCompare == ench || enchCompare.func_191560_c(ench)) continue;
                        compatible = false;
                        break;
                    }
                    if (!compatible) continue;
                    currentEnchants.put(ench, level);
                }
                if (hasOverLevel) {
                    if (hasMatching) {
                        ItemStack out = left.func_77946_l();
                        EnchantmentHelper.func_82782_a((Map)currentEnchants, (ItemStack)out);
                        String name = event.getName();
                        int cost = this.applyTomeCost;
                        if (name != null && !name.isEmpty()) {
                            out.func_151001_c(name);
                            ++cost;
                        }
                        event.setOutput(out);
                        event.setCost(cost);
                    } else {
                        event.setCanceled(true);
                    }
                }
            }
        }
    }

    private void handleTome(ItemStack book, ItemStack tome, AnvilUpdateEvent event) {
        Map enchantsBook = EnchantmentHelper.func_82781_a((ItemStack)book);
        Map enchantsTome = EnchantmentHelper.func_82781_a((ItemStack)tome);
        for (Map.Entry entry : enchantsTome.entrySet()) {
            if (enchantsBook.getOrDefault(entry.getKey(), 0).equals(entry.getValue())) {
                enchantsBook.put(entry.getKey(), (Integer)entry.getValue() + 1);
                continue;
            }
            return;
        }
        ItemStack output = ProxyRegistry.newStack((Item)Items.field_151134_bR);
        for (Map.Entry entry : enchantsBook.entrySet()) {
            ItemEnchantedBook.func_92115_a((ItemStack)output, (EnchantmentData)new EnchantmentData((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue()));
        }
        event.setOutput(output);
        event.setCost(this.mergeTomeCost);
    }

    private String[] generateDefaultEnchantmentList() {
        Enchantment[] enchants = new Enchantment[]{Enchantments.field_180309_e, Enchantments.field_92091_k, Enchantments.field_185302_k, Enchantments.field_185303_l, Enchantments.field_180312_n, Enchantments.field_180313_o, Enchantments.field_77334_n, Enchantments.field_185304_p, Enchantments.field_191530_r, Enchantments.field_185305_q, Enchantments.field_185307_s, Enchantments.field_185308_t, Enchantments.field_185309_u, Enchantments.field_185310_v, Enchantments.field_151370_z, Enchantments.field_151369_A};
        ArrayList<String> strings = new ArrayList<String>();
        for (Enchantment e : enchants) {
            if (e == null || e.getRegistryName() == null) continue;
            strings.add(e.getRegistryName().toString());
        }
        return strings.toArray(new String[strings.size()]);
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    static {
        validEnchants = new ArrayList<Enchantment>();
    }

    public static class EnchantTomeFunction
    extends LootFunction {
        protected EnchantTomeFunction() {
            super(new LootCondition[0]);
        }

        public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
            Enchantment enchantment = validEnchants.get(rand.nextInt(validEnchants.size()));
            stack.func_77966_a(enchantment, enchantment.func_77325_b());
            return stack;
        }

        public static class Serializer
        extends LootFunction.Serializer<EnchantTomeFunction> {
            protected Serializer() {
                super(new ResourceLocation("quark", "enchant_tome"), EnchantTomeFunction.class);
            }

            public void serialize(JsonObject object, EnchantTomeFunction functionClazz, JsonSerializationContext serializationContext) {
            }

            public EnchantTomeFunction deserialize(JsonObject object, JsonDeserializationContext deserializationContext, LootCondition[] conditionsIn) {
                return new EnchantTomeFunction();
            }
        }
    }
}

