/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.feature;

import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import vazkii.quark.base.Quark;
import vazkii.quark.base.handler.DimensionConfig;
import vazkii.quark.base.module.Feature;
import vazkii.quark.world.client.render.RenderPirate;
import vazkii.quark.world.entity.EntityPirate;
import vazkii.quark.world.item.ItemPirateHat;
import vazkii.quark.world.world.PirateShipGenerator;

public class PirateShips
extends Feature {
    public static final ResourceLocation PIRATE_CHEST_LOOT_TABLE = new ResourceLocation("quark", "chests/pirate_chest");
    public static final ResourceLocation SHIP_STRUCTURE = new ResourceLocation("quark", "pirate_ship");
    public static Item pirate_hat;
    boolean onlyHat;
    public static int rarity;
    DimensionConfig dims;

    @Override
    public void setupConfig() {
        this.onlyHat = this.loadPropBool("Only hat", "Disables the pirate mob and generator, only adds the hat", false);
        rarity = this.loadPropInt("Pirate Ship Rarity", "Given this value as X, 1 ship will spawn in X ocean biome chunks", 4000);
        this.dims = new DimensionConfig(this.configCategory);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        pirate_hat = new ItemPirateHat();
        if (this.onlyHat) {
            return;
        }
        String pirateName = "quark:pirate";
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(pirateName), EntityPirate.class, (String)pirateName, (int)3, (Object)Quark.instance, (int)80, (int)3, (boolean)true, (int)0x4D1D14, (int)11310615);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new PirateShipGenerator(this.dims), (int)0);
    }

    @Override
    public void preInitClient(FMLPreInitializationEvent event) {
        if (!this.onlyHat) {
            RenderingRegistry.registerEntityRenderingHandler(EntityPirate.class, (IRenderFactory)RenderPirate.FACTORY);
        }
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }
}

