/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.immersivecables.tileentity.ae;

import appeng.api.AEApi;
import appeng.api.exceptions.FailedConnectionException;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.helpers.IGridProxyable;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.TileEntityImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.WireApi;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.Utils;
import de.sanandrew.mods.immersivecables.util.ICConstants;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import org.apache.logging.log4j.Level;

public abstract class TileFluixConnectable
extends TileEntityImmersiveConnectable
implements IActionHost,
IGridProxyable,
ITickable,
IEBlockInterfaces.IAdvancedSelectionBounds {
    private Queue<IGridConnection> connections = new ConcurrentLinkedQueue<IGridConnection>();
    AENetworkProxy proxy = this.createProxy();
    public EntityPlayer ownerCache;
    List<AxisAlignedBB> cachedSelectionBounds;
    private boolean loaded = false;

    private AENetworkProxy createProxy() {
        return new AENetworkProxy((IGridProxyable)this, "proxy", new ItemStack(Blocks.field_189880_di), true);
    }

    public IGridNode getGridNode(AEPartLocation aePartLocation) {
        return this.proxy.getNode();
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.connections.forEach(IGridConnection::destroy);
        this.proxy.onChunkUnload();
    }

    public void securityBreak() {
        this.field_145850_b.func_175655_b(this.field_174879_c, true);
    }

    protected void onReady() {
        this.proxy.setVisualRepresentation(this.getMachineRepresentation());
        this.proxy.setIdlePowerUsage(this.getIdlePowerUsage());
        this.proxy.setValidSides(this.getConnectableSides());
        this.proxy.setFlags(this.getFlags());
        if (this.ownerCache != null) {
            this.proxy.setOwner(this.ownerCache);
        }
        this.proxy.onReady();
        this.proxy.getNode().updateState();
    }

    public boolean canConnect() {
        return true;
    }

    public ItemStack getMachineRepresentation() {
        return new ItemStack(this.func_145838_q(), 1, this.func_145832_p() & 1);
    }

    public void connectCable(WireType cableType, TargetingInfo target, IImmersiveConnectable other) {
        super.connectCable(cableType, target, other);
        this.connectTo(Utils.toCC((Object)other));
    }

    public boolean allowEnergyToPass(ImmersiveNetHandler.Connection con) {
        return false;
    }

    public boolean canConnectCable(WireType cableType, TargetingInfo target, Vec3i offset) {
        String category = cableType.getCategory();
        return this.getWireCategory().equals(category) && (this.limitType == null || this.isRelay() && WireApi.canMix((WireType)this.limitType, (WireType)cableType));
    }

    public void removeCable(ImmersiveNetHandler.Connection connection) {
        if (!this.field_145850_b.field_72995_K && connection != null) {
            BlockPos opposite = connection.end;
            if (opposite.equals((Object)Utils.toCC((Object)((Object)this)))) {
                return;
            }
            for (IGridConnection gridConnection : this.connections) {
                DimensionalCoord locA = gridConnection.a().getGridBlock().getLocation();
                DimensionalCoord locB = gridConnection.b().getGridBlock().getLocation();
                if ((opposite.func_177958_n() != locA.x || opposite.func_177952_p() != locA.z || opposite.func_177956_o() != locA.y) && (opposite.func_177958_n() != locB.x || opposite.func_177952_p() != locB.z || opposite.func_177956_o() != locB.y)) continue;
                gridConnection.destroy();
                this.connections.remove(gridConnection);
                break;
            }
        }
        super.removeCable(connection);
    }

    public abstract double getIdlePowerUsage();

    public abstract EnumSet<EnumFacing> getConnectableSides();

    public abstract GridFlags[] getFlags();

    protected abstract String getWireCategory();

    public void func_73660_a() {
        if (!this.loaded && this.func_145830_o()) {
            this.loaded = true;
            if (!this.field_145850_b.field_72995_K) {
                this.onReady();
                Set connections = ImmersiveNetHandler.INSTANCE.getConnections(this.field_145850_b, Utils.toCC((Object)((Object)this)));
                if (connections != null) {
                    for (ImmersiveNetHandler.Connection connection : connections) {
                        BlockPos opposite = connection.end;
                        if (opposite.equals((Object)Utils.toCC((Object)((Object)this)))) continue;
                        this.connectTo(opposite);
                    }
                }
            }
        }
    }

    public boolean hasFastRenderer() {
        return true;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.connections.forEach(IGridConnection::destroy);
        this.proxy.invalidate();
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.proxy.validate();
    }

    public AENetworkProxy getProxy() {
        return this.proxy;
    }

    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    public void gridChanged() {
    }

    public IGridNode getActionableNode() {
        return this.proxy.getNode();
    }

    public void connectTo(BlockPos pos) {
        TileEntity teOpposite = this.field_145850_b.func_175625_s(pos);
        if (teOpposite instanceof IGridHost) {
            IGridNode nodeA = ((IGridHost)teOpposite).getGridNode(AEPartLocation.INTERNAL);
            IGridNode nodeB = this.getGridNode(AEPartLocation.INTERNAL);
            try {
                if (nodeA != null) {
                    IGridConnection conn = AEApi.instance().grid().createGridConnection(nodeA, nodeB);
                    this.connections.add(conn);
                }
            }
            catch (FailedConnectionException ex) {
                ICConstants.LOG.log(Level.DEBUG, ex.getMessage());
            }
        }
    }

    protected EnumFacing getFacing() {
        return !this.field_145850_b.func_175623_d(this.field_174879_c) ? (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockDirectional.field_176387_N) : EnumFacing.UP;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        this.proxy.writeToNBT(compound);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.proxy.readFromNBT(compound);
    }

    public boolean isOverrideBox(AxisAlignedBB box, EntityPlayer entityPlayer, RayTraceResult ray, ArrayList<AxisAlignedBB> arrayList) {
        return box.func_72314_b(0.002, 0.002, 0.002).func_72318_a(ray.field_72307_f);
    }

    public float[] getBlockBounds() {
        return null;
    }
}

