/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.guide;

import com.blakebr0.cucumber.guide.GuiButtonArrow;
import com.blakebr0.cucumber.guide.GuiButtonEntry;
import com.blakebr0.cucumber.guide.Guide;
import com.blakebr0.cucumber.guide.GuideBookHelper;
import com.blakebr0.cucumber.guide.GuideEntry;
import com.blakebr0.cucumber.helper.RenderHelper;
import com.blakebr0.cucumber.helper.ResourceHelper;
import com.blakebr0.cucumber.network.NetworkHandler;
import com.blakebr0.cucumber.network.messages.MessageUpdateGuideNBT;
import com.blakebr0.cucumber.util.Utils;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiGuide
extends GuiScreen {
    public static final ResourceLocation GUI_TEX = ResourceHelper.getResource("cucumber", "textures/gui/guide.png");
    public static final ResourceLocation WIDGET_TEX = ResourceHelper.getResource("cucumber", "textures/gui/guide_widgets.png");
    public static final int ENTRIES_PER_PAGE = 9;
    public static final int COMPONENT_SPACING = 6;
    public ItemStack book;
    public Guide guide;
    public int xSize;
    public int ySize;
    public int xStart;
    public int yStart;
    public int topicsPage;
    public int maxTopicsPage;
    public int entryPage;
    public int maxEntryPage;
    public GuideEntry entry;
    public int entryId;
    public GuiButtonArrow prevEntry;
    public GuiButtonArrow nextEntry;
    public GuiButtonArrow prevPage;
    public GuiButtonArrow nextPage;

    public GuiGuide(ItemStack book, Guide guide) {
        this.book = book;
        this.guide = guide;
        this.xSize = 436;
        this.ySize = 240;
        this.topicsPage = GuideBookHelper.getTopicsPage(this.book);
        this.maxTopicsPage = this.guide.getEntryCount() / 9 - 1;
        this.entryId = GuideBookHelper.getEntryId(this.book);
        this.entry = this.entryId > -1 ? this.guide.getEntryById(this.entryId) : (this.guide.hasEntries() ? this.guide.getEntryById(0) : null);
        this.entryPage = GuideBookHelper.getEntryPage(this.book);
        int n = this.maxEntryPage = this.entry != null ? this.entry.getPageCount() - 2 : -1;
        if (this.entry != null && this.entryId == -1) {
            this.entryId = 0;
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.xStart = (this.field_146294_l - this.xSize) / 2;
        this.yStart = (this.field_146295_m - this.ySize) / 2;
        this.prevEntry = (GuiButtonArrow)this.func_189646_b(new GuiButtonArrow(10000, this.xStart + 17, this.yStart + 207, true));
        this.nextEntry = (GuiButtonArrow)this.func_189646_b(new GuiButtonArrow(10001, this.xStart + 145, this.yStart + 207, false));
        this.prevPage = (GuiButtonArrow)this.func_189646_b(new GuiButtonArrow(10002, this.xStart + 196, this.yStart + 207, true));
        this.nextPage = (GuiButtonArrow)this.func_189646_b(new GuiButtonArrow(10003, this.xStart + 390, this.yStart + 207, false));
        this.updateEntryButtons();
        this.updatePageButtons();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(GUI_TEX);
        RenderHelper.drawTexturedModelRect(this.xStart, this.yStart, 0.0, 0.0, this.xSize, this.ySize, 512.0, 512.0);
        RenderHelper.drawScaledCenteredWrappedTextXY(this.field_146289_q, "\u00a7l" + this.guide.getName(), this.xStart + 95, this.yStart + 22, 1.0f, 120.0f, -1.0f, 0, false);
        if (this.entry != null) {
            RenderHelper.drawScaledCenteredWrappedTextY(this.field_146289_q, "\u00a7l" + this.entry.getTitle(), this.xStart + 227, this.yStart + 25, 1.0f, 190.0f, -1.0f, 0, false);
            RenderHelper.drawScaledItemIntoGui(this.field_146296_j, this.entry.getIconStack(), this.xStart + 197, this.yStart + 18, 1.54f);
            if (this.entry.hasPages()) {
                this.entry.getPage(this.entryPage).draw(this.field_146297_k, mouseX, mouseY, partialTicks, this.xStart + 200, this.yStart + 63, 220, 130);
            }
        }
        RenderHelper.drawCenteredText(this.field_146289_q, Utils.localize("guide.cu.page_indicator", this.topicsPage + 1, this.maxTopicsPage + 2), this.xStart + 96, this.yStart + 211, 0);
        RenderHelper.drawCenteredText(this.field_146289_q, Utils.localize("guide.cu.page_indicator", this.entryPage + 1, Math.max(this.maxEntryPage + 2, 1)), this.xStart + 308, this.yStart + 211, 0);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button instanceof GuiButtonEntry) {
            this.entry = this.guide.getEntryById(button.field_146127_k);
            this.entryId = button.field_146127_k;
            this.entryPage = 0;
            this.maxEntryPage = this.entry.getPageCount() - 2;
            this.updateEntryButtons();
            this.updatePageButtons();
        } else if (button == this.prevEntry && this.topicsPage > 0) {
            --this.topicsPage;
            this.updateEntryButtons();
        } else if (button == this.nextEntry && this.topicsPage <= this.maxTopicsPage) {
            ++this.topicsPage;
            this.updateEntryButtons();
        } else if (button == this.prevPage) {
            --this.entryPage;
            this.updatePageButtons();
        } else if (button == this.nextPage && this.entryPage <= this.maxEntryPage) {
            ++this.entryPage;
            this.updatePageButtons();
        }
    }

    public void func_146281_b() {
        NetworkHandler.INSTANCE.sendToServer((IMessage)new MessageUpdateGuideNBT(this.topicsPage, this.entryPage, this.entryId));
        super.func_146281_b();
    }

    public boolean func_73868_f() {
        return false;
    }

    public void updateEntryButtons() {
        this.field_146292_n.removeIf(b -> b.field_146127_k < 10000);
        this.prevEntry.field_146124_l = this.topicsPage > 0;
        this.nextEntry.field_146124_l = this.topicsPage <= this.maxTopicsPage;
        int i = 9 * this.topicsPage;
        for (int x = 0; x < 9 && i < this.guide.getEntryCount(); ++i, ++x) {
            GuideEntry entry = this.guide.getEntryById(i);
            GuiButtonEntry button = new GuiButtonEntry(i, this.xStart + 20, this.yStart + 41 + x * 18, 151, 16, entry.getTitle(), entry.getIconStack());
            if (i == this.entryId) {
                button.field_146124_l = false;
            }
            this.func_189646_b(button);
        }
    }

    public void updatePageButtons() {
        this.prevPage.field_146124_l = this.entryPage > 0;
        this.nextPage.field_146124_l = this.entryPage <= this.maxEntryPage;
    }
}

