/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.config;

import com.google.common.collect.ImmutableMap;
import java.awt.Color;
import java.io.File;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.JustEnoughItems;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.color.ColorGetter;
import mezz.jei.color.ColorNamer;
import mezz.jei.config.ConfigValues;
import mezz.jei.config.EditModeToggleEvent;
import mezz.jei.config.KeyBindings;
import mezz.jei.config.LocalizedConfiguration;
import mezz.jei.config.OverlayToggleEvent;
import mezz.jei.config.SessionData;
import mezz.jei.network.packets.PacketRequestCheatPermission;
import mezz.jei.startup.ForgeModIdHelper;
import mezz.jei.startup.IModIdHelper;
import mezz.jei.util.GiveMode;
import mezz.jei.util.Log;
import mezz.jei.util.Translator;
import net.minecraft.network.NetworkManager;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public final class Config {
    private static final String configKeyPrefix = "config.jei";
    public static final String CATEGORY_SEARCH = "search";
    public static final String CATEGORY_ADVANCED = "advanced";
    public static final String CATEGORY_SEARCH_COLORS = "searchColors";
    public static final String defaultModNameFormatFriendly = "blue italic";
    public static final int smallestNumColumns = 4;
    public static final int largestNumColumns = 100;
    @Nullable
    private static LocalizedConfiguration config;
    @Nullable
    private static Configuration worldConfig;
    @Nullable
    private static LocalizedConfiguration itemBlacklistConfig;
    @Nullable
    private static LocalizedConfiguration searchColorsConfig;
    private static final ConfigValues defaultValues;
    private static final ConfigValues values;
    @Nullable
    private static String modNameFormatOverride;
    private static final Set<String> itemBlacklist;
    private static final String[] defaultItemBlacklist;

    private Config() {
    }

    public static boolean isOverlayEnabled() {
        return Config.values.overlayEnabled || KeyBindings.toggleOverlay.func_151463_i() == 0;
    }

    public static void toggleOverlayEnabled() {
        boolean bl = Config.values.overlayEnabled = !Config.values.overlayEnabled;
        if (worldConfig != null) {
            NetworkManager networkManager = FMLClientHandler.instance().getClientToServerNetworkManager();
            String worldCategory = SessionData.getWorldUid(networkManager);
            Property property = worldConfig.get(worldCategory, "overlayEnabled", Config.defaultValues.overlayEnabled);
            property.set(Config.values.overlayEnabled);
            if (worldConfig.hasChanged()) {
                worldConfig.save();
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new OverlayToggleEvent(Config.values.overlayEnabled));
    }

    public static boolean isCheatItemsEnabled() {
        return Config.values.cheatItemsEnabled;
    }

    public static void toggleCheatItemsEnabled() {
        Config.setCheatItemsEnabled(!Config.values.cheatItemsEnabled);
    }

    public static void setCheatItemsEnabled(boolean value) {
        if (Config.values.cheatItemsEnabled != value) {
            Config.values.cheatItemsEnabled = value;
            if (worldConfig != null) {
                NetworkManager networkManager = FMLClientHandler.instance().getClientToServerNetworkManager();
                String worldCategory = SessionData.getWorldUid(networkManager);
                Property property = worldConfig.get(worldCategory, "cheatItemsEnabled", Config.defaultValues.cheatItemsEnabled);
                property.set(Config.values.cheatItemsEnabled);
                if (worldConfig.hasChanged()) {
                    worldConfig.save();
                }
            }
            if (Config.values.cheatItemsEnabled && SessionData.isJeiOnServer()) {
                JustEnoughItems.getProxy().sendPacketToServer(new PacketRequestCheatPermission());
            }
        }
    }

    public static boolean isEditModeEnabled() {
        return Config.values.editModeEnabled;
    }

    public static boolean isDebugModeEnabled() {
        return Config.values.debugModeEnabled;
    }

    public static boolean isDeleteItemsInCheatModeActive() {
        return Config.values.cheatItemsEnabled && SessionData.isJeiOnServer();
    }

    public static boolean isCenterSearchBarEnabled() {
        return Config.values.centerSearchBarEnabled;
    }

    public static GiveMode getGiveMode() {
        return Config.values.giveMode;
    }

    public static String getModNameFormat() {
        String override = modNameFormatOverride;
        if (override != null) {
            return override;
        }
        return Config.values.modNameFormat;
    }

    public static boolean isModNameFormatOverrideActive() {
        return modNameFormatOverride != null;
    }

    public static void checkForModNameFormatOverride() {
        IModIdHelper modIdHelper = ForgeModIdHelper.getInstance();
        modNameFormatOverride = modIdHelper.getModNameTooltipFormatting();
        if (config != null) {
            Config.updateModNameFormat(config);
        }
    }

    public static int getMaxColumns() {
        return Config.values.maxColumns;
    }

    public static SearchMode getModNameSearchMode() {
        return Config.values.modNameSearchMode;
    }

    public static SearchMode getTooltipSearchMode() {
        return Config.values.tooltipSearchMode;
    }

    public static SearchMode getOreDictSearchMode() {
        return Config.values.oreDictSearchMode;
    }

    public static SearchMode getCreativeTabSearchMode() {
        return Config.values.creativeTabSearchMode;
    }

    public static SearchMode getColorSearchMode() {
        return Config.values.colorSearchMode;
    }

    public static SearchMode getResourceIdSearchMode() {
        return Config.values.resourceIdSearchMode;
    }

    public static boolean getSearchAdvancedTooltips() {
        return Config.values.searchAdvancedTooltips;
    }

    public static boolean setFilterText(String filterText) {
        if (Config.values.filterText.equals(filterText)) {
            return false;
        }
        Config.values.filterText = filterText;
        return true;
    }

    public static String getFilterText() {
        return Config.values.filterText;
    }

    public static void saveFilterText() {
        if (worldConfig != null) {
            NetworkManager networkManager = FMLClientHandler.instance().getClientToServerNetworkManager();
            String worldCategory = SessionData.getWorldUid(networkManager);
            Property property = worldConfig.get(worldCategory, "filterText", Config.defaultValues.filterText);
            property.set(Config.values.filterText);
            if (worldConfig.hasChanged()) {
                worldConfig.save();
            }
        }
    }

    @Nullable
    public static LocalizedConfiguration getConfig() {
        return config;
    }

    @Nullable
    public static Configuration getWorldConfig() {
        return worldConfig;
    }

    public static void preInit(FMLPreInitializationEvent event) {
        File jeiConfigurationDir = new File(event.getModConfigurationDirectory(), "jei");
        if (!jeiConfigurationDir.exists()) {
            try {
                if (!jeiConfigurationDir.mkdir()) {
                    Log.get().error("Could not create config directory {}", (Object)jeiConfigurationDir);
                    return;
                }
            }
            catch (SecurityException e) {
                Log.get().error("Could not create config directory {}", (Object)jeiConfigurationDir, (Object)e);
                return;
            }
        }
        File configFile = new File(jeiConfigurationDir, "jei.cfg");
        File itemBlacklistConfigFile = new File(jeiConfigurationDir, "itemBlacklist.cfg");
        File searchColorsConfigFile = new File(jeiConfigurationDir, "searchColors.cfg");
        File worldConfigFile = new File(jeiConfigurationDir, "worldSettings.cfg");
        worldConfig = new Configuration(worldConfigFile, "0.1.0");
        config = new LocalizedConfiguration(configKeyPrefix, configFile, "0.4.0");
        itemBlacklistConfig = new LocalizedConfiguration(configKeyPrefix, itemBlacklistConfigFile, "0.1.0");
        searchColorsConfig = new LocalizedConfiguration(configKeyPrefix, searchColorsConfigFile, "0.1.0");
        Config.syncConfig();
        Config.syncItemBlacklistConfig();
        Config.syncSearchColorsConfig();
    }

    public static boolean syncAllConfig() {
        NetworkManager networkManager;
        boolean needsReload = false;
        if (Config.syncConfig()) {
            needsReload = true;
        }
        if (Config.syncItemBlacklistConfig()) {
            needsReload = true;
        }
        if (Config.syncWorldConfig(networkManager = FMLClientHandler.instance().getClientToServerNetworkManager())) {
            needsReload = true;
        }
        if (Config.syncSearchColorsConfig()) {
            needsReload = true;
        }
        return needsReload;
    }

    private static boolean syncConfig() {
        ConfigCategory interfaceCategory;
        ConfigCategory addonsCategory;
        if (config == null) {
            return false;
        }
        boolean needsReload = false;
        config.addCategory(CATEGORY_SEARCH);
        config.addCategory(CATEGORY_ADVANCED);
        ConfigCategory modeCategory = config.getCategory("mode");
        if (modeCategory != null) {
            config.removeCategory(modeCategory);
        }
        if ((addonsCategory = config.getCategory("addons")) != null) {
            config.removeCategory(addonsCategory);
        }
        if ((interfaceCategory = config.getCategory("interface")) != null) {
            config.removeCategory(interfaceCategory);
        }
        ConfigCategory searchCategory = config.getCategory(CATEGORY_SEARCH);
        searchCategory.remove((Object)"atPrefixRequiredForModName");
        searchCategory.remove((Object)"prefixRequiredForTooltipSearch");
        searchCategory.remove((Object)"prefixRequiredForOreDictSearch");
        searchCategory.remove((Object)"prefixRequiredForCreativeTabSearch");
        searchCategory.remove((Object)"prefixRequiredForColorSearch");
        Enum[] searchModes = SearchMode.values();
        String loadedConfigVersion = config.getLoadedConfigVersion();
        if (loadedConfigVersion != null && Config.versionCompare(loadedConfigVersion, "0.3.0") < 0) {
            config.setEnum("creativeTabSearchMode", CATEGORY_SEARCH, Config.defaultValues.creativeTabSearchMode, searchModes);
            config.setEnum("oreDictSearchMode", CATEGORY_SEARCH, Config.defaultValues.oreDictSearchMode, searchModes);
        }
        Config.values.modNameSearchMode = (SearchMode)config.getEnum("modNameSearchMode", CATEGORY_SEARCH, Config.defaultValues.modNameSearchMode, searchModes);
        Config.values.tooltipSearchMode = (SearchMode)config.getEnum("tooltipSearchMode", CATEGORY_SEARCH, Config.defaultValues.tooltipSearchMode, searchModes);
        Config.values.oreDictSearchMode = (SearchMode)config.getEnum("oreDictSearchMode", CATEGORY_SEARCH, Config.defaultValues.oreDictSearchMode, searchModes);
        Config.values.creativeTabSearchMode = (SearchMode)config.getEnum("creativeTabSearchMode", CATEGORY_SEARCH, Config.defaultValues.creativeTabSearchMode, searchModes);
        Config.values.colorSearchMode = (SearchMode)config.getEnum("colorSearchMode", CATEGORY_SEARCH, Config.defaultValues.colorSearchMode, searchModes);
        Config.values.resourceIdSearchMode = (SearchMode)config.getEnum("resourceIdSearchMode", CATEGORY_SEARCH, Config.defaultValues.resourceIdSearchMode, searchModes);
        if (config.getCategory(CATEGORY_SEARCH).hasChanged()) {
            needsReload = true;
        }
        Config.values.searchAdvancedTooltips = config.getBoolean("searchAdvancedTooltips", CATEGORY_SEARCH, Config.defaultValues.searchAdvancedTooltips);
        ConfigCategory categoryAdvanced = config.getCategory(CATEGORY_ADVANCED);
        categoryAdvanced.remove((Object)"nbtKeyIgnoreList");
        categoryAdvanced.remove((Object)"deleteItemsInCheatModeEnabled");
        categoryAdvanced.remove((Object)"hideLaggyModelsEnabled");
        categoryAdvanced.remove((Object)"hideMissingModelsEnabled");
        categoryAdvanced.remove((Object)"debugItemEnabled");
        categoryAdvanced.remove((Object)"colorSearchEnabled");
        categoryAdvanced.remove((Object)"maxSubtypes");
        Config.values.centerSearchBarEnabled = config.getBoolean(CATEGORY_ADVANCED, "centerSearchBarEnabled", Config.defaultValues.centerSearchBarEnabled);
        Config.values.giveMode = (GiveMode)config.getEnum("giveMode", CATEGORY_ADVANCED, Config.defaultValues.giveMode, GiveMode.values());
        Config.values.maxColumns = config.getInt("maxColumns", CATEGORY_ADVANCED, Config.defaultValues.maxColumns, 4, 100);
        Config.updateModNameFormat(config);
        Property property = config.get(CATEGORY_ADVANCED, "debugModeEnabled", Config.defaultValues.debugModeEnabled);
        property.setShowInGui(false);
        Config.values.debugModeEnabled = property.getBoolean();
        boolean configChanged = config.hasChanged();
        if (configChanged) {
            config.save();
        }
        return needsReload;
    }

    private static void updateModNameFormat(LocalizedConfiguration config) {
        EnumSet<TextFormatting> validFormatting = EnumSet.allOf(TextFormatting.class);
        validFormatting.remove(TextFormatting.RESET);
        String[] validValues = new String[validFormatting.size()];
        int i = 0;
        for (TextFormatting formatting : validFormatting) {
            validValues[i] = formatting.func_96297_d().toLowerCase(Locale.ENGLISH);
            ++i;
        }
        Property property = config.getString("modNameFormat", CATEGORY_ADVANCED, defaultModNameFormatFriendly, validValues);
        boolean showInGui = !Config.isModNameFormatOverrideActive();
        property.setShowInGui(showInGui);
        String modNameFormatFriendly = property.getString();
        Config.values.modNameFormat = Config.parseFriendlyModNameFormat(modNameFormatFriendly);
    }

    public static String parseFriendlyModNameFormat(String formatWithEnumNames) {
        String[] strings;
        if (formatWithEnumNames.isEmpty()) {
            return "";
        }
        StringBuilder format = new StringBuilder();
        for (String string : strings = formatWithEnumNames.split(" ")) {
            TextFormatting valueByName = TextFormatting.func_96300_b((String)string);
            if (valueByName != null) {
                format.append(valueByName.toString());
                continue;
            }
            Log.get().error("Invalid format: {}", (Object)string);
        }
        return format.toString();
    }

    private static boolean syncItemBlacklistConfig() {
        if (itemBlacklistConfig == null) {
            return false;
        }
        itemBlacklistConfig.addCategory(CATEGORY_ADVANCED);
        String[] itemBlacklistArray = itemBlacklistConfig.getStringList("itemBlacklist", CATEGORY_ADVANCED, defaultItemBlacklist);
        itemBlacklist.clear();
        Collections.addAll(itemBlacklist, itemBlacklistArray);
        boolean configChanged = itemBlacklistConfig.hasChanged();
        if (configChanged) {
            itemBlacklistConfig.save();
        }
        return configChanged;
    }

    public static boolean syncWorldConfig(@Nullable NetworkManager networkManager) {
        if (worldConfig == null) {
            return false;
        }
        String worldCategory = SessionData.getWorldUid(networkManager);
        Property property = worldConfig.get(worldCategory, "overlayEnabled", Config.defaultValues.overlayEnabled);
        property.setLanguageKey("config.jei.interface.overlayEnabled");
        property.setComment(Translator.translateToLocal("config.jei.interface.overlayEnabled.comment"));
        property.setShowInGui(false);
        Config.values.overlayEnabled = property.getBoolean();
        property = worldConfig.get(worldCategory, "cheatItemsEnabled", Config.defaultValues.cheatItemsEnabled);
        property.setLanguageKey("config.jei.mode.cheatItemsEnabled");
        property.setComment(Translator.translateToLocal("config.jei.mode.cheatItemsEnabled.comment"));
        Config.values.cheatItemsEnabled = property.getBoolean();
        property = worldConfig.get(worldCategory, "editEnabled", Config.defaultValues.editModeEnabled);
        property.setLanguageKey("config.jei.mode.editEnabled");
        property.setComment(Translator.translateToLocal("config.jei.mode.editEnabled.comment"));
        Config.values.editModeEnabled = property.getBoolean();
        if (property.hasChanged()) {
            MinecraftForge.EVENT_BUS.post((Event)new EditModeToggleEvent(Config.values.editModeEnabled));
        }
        property = worldConfig.get(worldCategory, "filterText", Config.defaultValues.filterText);
        property.setShowInGui(false);
        Config.values.filterText = property.getString();
        boolean configChanged = worldConfig.hasChanged();
        if (configChanged) {
            worldConfig.save();
        }
        return false;
    }

    private static boolean syncSearchColorsConfig() {
        if (searchColorsConfig == null) {
            return false;
        }
        searchColorsConfig.addCategory(CATEGORY_SEARCH_COLORS);
        String[] searchColorDefaults = ColorGetter.getColorDefaults();
        String[] searchColors = searchColorsConfig.getStringList(CATEGORY_SEARCH_COLORS, CATEGORY_SEARCH_COLORS, searchColorDefaults);
        ImmutableMap.Builder searchColorsMapBuilder = ImmutableMap.builder();
        for (String entry : searchColors) {
            String[] values = entry.split(":");
            if (values.length != 2) {
                Log.get().error("Invalid format for searchColor entry: {}", (Object)entry);
                continue;
            }
            try {
                String name = values[0];
                int colorValue = Integer.decode("0x" + values[1]);
                Color color = new Color(colorValue);
                searchColorsMapBuilder.put((Object)color, (Object)name);
            }
            catch (NumberFormatException e) {
                Log.get().error("Invalid number format for searchColor entry: {}", (Object)entry, (Object)e);
            }
        }
        ColorNamer colorNamer = new ColorNamer((ImmutableMap<Color, String>)searchColorsMapBuilder.build());
        Internal.setColorNamer(colorNamer);
        boolean configChanged = searchColorsConfig.hasChanged();
        if (configChanged) {
            searchColorsConfig.save();
        }
        return configChanged;
    }

    private static void updateBlacklist() {
        if (itemBlacklistConfig == null) {
            return;
        }
        Property property = itemBlacklistConfig.get(CATEGORY_ADVANCED, "itemBlacklist", defaultItemBlacklist);
        String[] currentBlacklist = itemBlacklist.toArray(new String[itemBlacklist.size()]);
        property.set(currentBlacklist);
        boolean changed = itemBlacklistConfig.hasChanged();
        if (changed) {
            itemBlacklistConfig.save();
        }
    }

    public static <V> void addIngredientToConfigBlacklist(V ingredient, IngredientBlacklistType blacklistType, IIngredientHelper<V> ingredientHelper) {
        String uid = Config.getIngredientUid(ingredient, blacklistType, ingredientHelper);
        if (itemBlacklist.add(uid)) {
            Config.updateBlacklist();
        }
    }

    public static <V> void removeIngredientFromConfigBlacklist(V ingredient, IngredientBlacklistType blacklistType, IIngredientHelper<V> ingredientHelper) {
        String uid = Config.getIngredientUid(ingredient, blacklistType, ingredientHelper);
        if (itemBlacklist.remove(uid)) {
            Config.updateBlacklist();
        }
    }

    public static <V> boolean isIngredientOnConfigBlacklist(V ingredient, IIngredientHelper<V> ingredientHelper) {
        for (IngredientBlacklistType ingredientBlacklistType : IngredientBlacklistType.VALUES) {
            if (!Config.isIngredientOnConfigBlacklist(ingredient, ingredientBlacklistType, ingredientHelper)) continue;
            return true;
        }
        return false;
    }

    public static <V> boolean isIngredientOnConfigBlacklist(V ingredient, IngredientBlacklistType blacklistType, IIngredientHelper<V> ingredientHelper) {
        String uid = Config.getIngredientUid(ingredient, blacklistType, ingredientHelper);
        return itemBlacklist.contains(uid);
    }

    private static <V> String getIngredientUid(V ingredient, IngredientBlacklistType blacklistType, IIngredientHelper<V> ingredientHelper) {
        switch (blacklistType) {
            case ITEM: {
                return ingredientHelper.getUniqueId(ingredient);
            }
            case WILDCARD: {
                return ingredientHelper.getWildcardId(ingredient);
            }
            case MOD_ID: {
                return ingredientHelper.getModId(ingredient);
            }
        }
        throw new IllegalStateException("Unknown blacklist type: " + (Object)((Object)blacklistType));
    }

    private static int versionCompare(String str1, String str2) {
        int i;
        String[] vals1 = str1.split("\\.");
        String[] vals2 = str2.split("\\.");
        for (i = 0; i < vals1.length && i < vals2.length && vals1[i].equals(vals2[i]); ++i) {
        }
        if (i < vals1.length && i < vals2.length) {
            int diff = Integer.valueOf(vals1[i]).compareTo(Integer.valueOf(vals2[i]));
            return Integer.signum(diff);
        }
        return Integer.signum(vals1.length - vals2.length);
    }

    static {
        defaultValues = new ConfigValues();
        values = new ConfigValues();
        itemBlacklist = new HashSet<String>();
        defaultItemBlacklist = new String[0];
    }

    public static enum IngredientBlacklistType {
        ITEM,
        WILDCARD,
        MOD_ID;

        public static final IngredientBlacklistType[] VALUES;

        static {
            VALUES = IngredientBlacklistType.values();
        }
    }

    public static enum SearchMode {
        ENABLED,
        REQUIRE_PREFIX,
        DISABLED;

    }
}

