/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui;

import javax.annotation.Nullable;
import mezz.jei.config.Config;
import mezz.jei.config.OverlayToggleEvent;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.overlay.IngredientListOverlay;
import mezz.jei.input.InputHandler;
import mezz.jei.recipes.RecipeRegistry;
import mezz.jei.runtime.JeiRuntime;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.client.event.GuiContainerEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.input.Mouse;

public class GuiEventHandler {
    private static final String showRecipesText = Translator.translateToLocal("jei.tooltip.show.recipes");
    private final JeiRuntime runtime;
    @Nullable
    private InputHandler inputHandler;
    private boolean drawnOnBackground = false;

    public GuiEventHandler(JeiRuntime runtime) {
        this.runtime = runtime;
    }

    @SubscribeEvent
    public void onOverlayToggle(OverlayToggleEvent event) {
        GuiScreen currentScreen = Minecraft.func_71410_x().field_71462_r;
        this.onNewScreen(currentScreen);
    }

    @SubscribeEvent
    public void onGuiInit(GuiScreenEvent.InitGuiEvent.Post event) {
        GuiScreen gui = event.getGui();
        this.onNewScreen(gui);
    }

    private void onNewScreen(@Nullable GuiScreen screen) {
        IngredientListOverlay ingredientListOverlay = this.runtime.getItemListOverlay();
        ingredientListOverlay.updateScreen(screen);
        if (this.inputHandler == null) {
            this.inputHandler = new InputHandler(this.runtime, ingredientListOverlay);
        }
    }

    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent event) {
        IngredientListOverlay ingredientListOverlay = this.runtime.getItemListOverlay();
        boolean wasEnabled = ingredientListOverlay.isEnabled();
        GuiScreen gui = event.getGui();
        ingredientListOverlay.updateScreen(gui);
        if (wasEnabled && !ingredientListOverlay.isEnabled()) {
            Config.saveFilterText();
        }
    }

    @SubscribeEvent
    public void onDrawBackgroundEventPost(GuiScreenEvent.BackgroundDrawnEvent event) {
        IngredientListOverlay ingredientListOverlay = this.runtime.getItemListOverlay();
        GuiScreen gui = event.getGui();
        ingredientListOverlay.updateScreen(gui);
        if (ingredientListOverlay.isEnabled()) {
            ingredientListOverlay.drawScreen(gui.field_146297_k, event.getMouseX(), event.getMouseY(), gui.field_146297_k.func_184121_ak());
            this.drawnOnBackground = true;
        }
    }

    @SubscribeEvent
    public void onDrawForegroundEvent(GuiContainerEvent.DrawForeground event) {
        IngredientListOverlay ingredientListOverlay = this.runtime.getItemListOverlay();
        GuiContainer gui = event.getGuiContainer();
        if (ingredientListOverlay.isEnabled()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(-gui.getGuiLeft()), (float)(-gui.getGuiTop()), (float)0.0f);
            ingredientListOverlay.drawOnForeground(gui.field_146297_k, event.getMouseX(), event.getMouseY());
            GlStateManager.func_179121_F();
        }
    }

    @SubscribeEvent
    public void onDrawScreenEventPost(GuiScreenEvent.DrawScreenEvent.Post event) {
        GuiScreen gui = event.getGui();
        IngredientListOverlay ingredientListOverlay = this.runtime.getItemListOverlay();
        ingredientListOverlay.updateScreen(gui);
        if (!this.drawnOnBackground && ingredientListOverlay.isEnabled()) {
            ingredientListOverlay.drawScreen(gui.field_146297_k, event.getMouseX(), event.getMouseY(), gui.field_146297_k.func_184121_ak());
        }
        this.drawnOnBackground = false;
        if (gui instanceof GuiContainer) {
            GuiContainer guiContainer = (GuiContainer)gui;
            RecipeRegistry recipeRegistry = this.runtime.getRecipeRegistry();
            if (recipeRegistry.getRecipeClickableArea(guiContainer, event.getMouseX() - guiContainer.getGuiLeft(), event.getMouseY() - guiContainer.getGuiTop()) != null) {
                TooltipRenderer.drawHoveringText(guiContainer.field_146297_k, showRecipesText, event.getMouseX(), event.getMouseY());
            }
        }
        if (ingredientListOverlay.isEnabled()) {
            ingredientListOverlay.drawTooltips(gui.field_146297_k, event.getMouseX(), event.getMouseY());
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        IngredientListOverlay ingredientListOverlay = this.runtime.getItemListOverlay();
        if (ingredientListOverlay.isEnabled()) {
            ingredientListOverlay.handleTick();
        }
    }

    @SubscribeEvent
    public void onGuiKeyboardEvent(GuiScreenEvent.KeyboardInputEvent.Pre event) {
        if (this.inputHandler != null && this.inputHandler.hasKeyboardFocus() && this.inputHandler.handleKeyEvent()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onGuiKeyboardEvent(GuiScreenEvent.KeyboardInputEvent.Post event) {
        if (this.inputHandler != null && !this.inputHandler.hasKeyboardFocus() && this.inputHandler.handleKeyEvent()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onGuiMouseEvent(GuiScreenEvent.MouseInputEvent.Pre event) {
        int y;
        int x;
        GuiScreen guiScreen = event.getGui();
        if (this.inputHandler != null && this.inputHandler.handleMouseEvent(guiScreen, x = Mouse.getEventX() * guiScreen.field_146294_l / guiScreen.field_146297_k.field_71443_c, y = guiScreen.field_146295_m - Mouse.getEventY() * guiScreen.field_146295_m / guiScreen.field_146297_k.field_71440_d - 1)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPotionShiftEvent(GuiScreenEvent.PotionShiftEvent event) {
        if (Config.isOverlayEnabled()) {
            event.setCanceled(true);
        }
    }
}

