/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.config.Constants;
import mezz.jei.gui.GuiHelper;
import mezz.jei.gui.ingredients.GuiIngredient;
import mezz.jei.gui.overlay.GuiProperties;
import mezz.jei.ingredients.IngredientRegistry;
import mezz.jei.input.ClickedIngredient;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.input.IShowsRecipeFocuses;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;

public class RecipeCatalysts
implements IShowsRecipeFocuses {
    private final IDrawable topDrawable;
    private final IDrawable middleDrawable;
    private final IDrawable bottomDrawable;
    private final List<GuiIngredient<Object>> ingredients = new ArrayList<GuiIngredient<Object>>();
    private int left = 0;
    private int top = 0;

    public RecipeCatalysts() {
        ResourceLocation recipeBackgroundResource = Constants.RECIPE_BACKGROUND;
        GuiHelper guiHelper = Internal.getHelpers().getGuiHelper();
        this.topDrawable = guiHelper.createDrawable(recipeBackgroundResource, 196, 65, 26, 6);
        this.middleDrawable = guiHelper.createDrawable(recipeBackgroundResource, 196, 71, 26, 16);
        this.bottomDrawable = guiHelper.createDrawable(recipeBackgroundResource, 196, 87, 26, 6);
    }

    public void updateLayout(List<Object> ingredients, GuiProperties guiProperties) {
        this.ingredients.clear();
        if (!ingredients.isEmpty()) {
            int i;
            int totalHeight = this.topDrawable.getHeight() + this.middleDrawable.getHeight() + this.bottomDrawable.getHeight();
            int ingredientCount = 1;
            int extraBoxHeight = this.middleDrawable.getHeight();
            for (int i2 = 1; i2 < ingredients.size() && totalHeight + extraBoxHeight <= guiProperties.getGuiYSize() - 8; ++i2) {
                totalHeight += extraBoxHeight;
                ++ingredientCount;
            }
            this.top = guiProperties.getGuiTop();
            this.left = guiProperties.getGuiLeft() - this.topDrawable.getWidth() + 4;
            ArrayList<Object> ingredientsForSlots = new ArrayList<Object>();
            for (i = 0; i < ingredients.size() && i < ingredientCount; ++i) {
                Object ingredient = ingredients.get(i);
                ingredientsForSlots.add(ingredient);
            }
            for (i = 0; i < ingredientCount; ++i) {
                Object ingredientForSlot = ingredientsForSlots.get(i);
                GuiIngredient guiIngredient = this.createGuiIngredient(ingredientForSlot, i);
                this.ingredients.add(guiIngredient);
            }
        }
    }

    private <T> GuiIngredient<T> createGuiIngredient(T ingredient, int index) {
        IngredientRegistry ingredientRegistry = Internal.getIngredientRegistry();
        IIngredientRenderer<T> ingredientRenderer = ingredientRegistry.getIngredientRenderer(ingredient);
        IIngredientHelper<T> ingredientHelper = ingredientRegistry.getIngredientHelper(ingredient);
        Rectangle rect = new Rectangle(this.left + 6, this.top + 6 + index * this.middleDrawable.getHeight(), 16, 16);
        GuiIngredient<T> guiIngredient = new GuiIngredient<T>(index, true, ingredientRenderer, ingredientHelper, rect, 0, 0, 0);
        guiIngredient.set(Collections.singletonList(ingredient), null);
        return guiIngredient;
    }

    @Nullable
    public GuiIngredient draw(Minecraft minecraft, int mouseX, int mouseY) {
        int ingredientCount = this.ingredients.size();
        if (ingredientCount > 0) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179097_i();
            GlStateManager.func_179141_d();
            int top = this.top;
            this.topDrawable.draw(minecraft, this.left, top);
            top += this.topDrawable.getHeight();
            while (ingredientCount-- > 0) {
                this.middleDrawable.draw(minecraft, this.left, top);
                top += this.middleDrawable.getHeight();
            }
            this.bottomDrawable.draw(minecraft, this.left, top);
            GlStateManager.func_179118_c();
            GlStateManager.func_179126_j();
            GuiIngredient<Object> hovered = null;
            for (GuiIngredient<Object> guiIngredient : this.ingredients) {
                if (guiIngredient.isMouseOver(0, 0, mouseX, mouseY)) {
                    hovered = guiIngredient;
                }
                guiIngredient.draw(minecraft, 0, 0);
            }
            return hovered;
        }
        return null;
    }

    @Nullable
    private GuiIngredient getHovered(int mouseX, int mouseY) {
        for (GuiIngredient<Object> guiIngredient : this.ingredients) {
            if (!guiIngredient.isMouseOver(0, 0, mouseX, mouseY)) continue;
            return guiIngredient;
        }
        return null;
    }

    @Override
    @Nullable
    public IClickedIngredient<?> getIngredientUnderMouse(int mouseX, int mouseY) {
        Object ingredientUnderMouse;
        GuiIngredient hovered = this.getHovered(mouseX, mouseY);
        if (hovered != null && (ingredientUnderMouse = hovered.getDisplayedIngredient()) != null) {
            return new ClickedIngredient(ingredientUnderMouse, hovered.getRect());
        }
        return null;
    }

    @Override
    public boolean canSetFocusWithMouse() {
        return true;
    }
}

