/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.ingredients;

import com.google.common.collect.ImmutableList;
import gnu.trove.TIntCollection;
import gnu.trove.map.TCharObjectMap;
import gnu.trove.map.hash.TCharObjectHashMap;
import gnu.trove.set.TIntSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.IIngredientFilter;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.config.Config;
import mezz.jei.config.EditModeToggleEvent;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.gui.overlay.IngredientListOverlay;
import mezz.jei.ingredients.IngredientBlacklistInternal;
import mezz.jei.ingredients.IngredientFilterBackgroundBuilder;
import mezz.jei.ingredients.IngredientListElementComparator;
import mezz.jei.ingredients.PrefixedSearchTree;
import mezz.jei.runtime.JeiRuntime;
import mezz.jei.startup.PlayerJoinedWorldEvent;
import mezz.jei.suffixtree.CombinedSearchTrees;
import mezz.jei.suffixtree.GeneralizedSuffixTree;
import mezz.jei.suffixtree.ISearchTree;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.Translator;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class IngredientFilter
implements IIngredientFilter {
    private static final Pattern QUOTE_PATTERN = Pattern.compile("\"");
    private static final Pattern FILTER_SPLIT_PATTERN = Pattern.compile("(-?\".*?(?:\"|$)|\\S+)");
    private final IngredientBlacklistInternal blacklist;
    private final NonNullList<IIngredientListElement> elementList;
    private final GeneralizedSuffixTree searchTree;
    private final TCharObjectMap<PrefixedSearchTree> prefixedSearchTrees = new TCharObjectHashMap();
    private final IngredientFilterBackgroundBuilder backgroundBuilder;
    private CombinedSearchTrees combinedSearchTrees;
    @Nullable
    private String filterCached;
    private List<IIngredientListElement> ingredientListCached = Collections.emptyList();

    public IngredientFilter(IngredientBlacklistInternal blacklist) {
        this.blacklist = blacklist;
        this.elementList = NonNullList.func_191196_a();
        this.searchTree = new GeneralizedSuffixTree();
        this.createPrefixedSearchTree('@', Config::getModNameSearchMode, IIngredientListElement::getModNameStrings);
        this.createPrefixedSearchTree('#', Config::getTooltipSearchMode, IIngredientListElement::getTooltipStrings);
        this.createPrefixedSearchTree('$', Config::getOreDictSearchMode, IIngredientListElement::getOreDictStrings);
        this.createPrefixedSearchTree('%', Config::getCreativeTabSearchMode, IIngredientListElement::getCreativeTabsStrings);
        this.createPrefixedSearchTree('^', Config::getColorSearchMode, IIngredientListElement::getColorStrings);
        this.createPrefixedSearchTree('&', Config::getResourceIdSearchMode, element -> Collections.singleton(element.getResourceId()));
        this.combinedSearchTrees = IngredientFilter.buildCombinedSearchTrees(this.searchTree, this.prefixedSearchTrees.valueCollection());
        this.backgroundBuilder = new IngredientFilterBackgroundBuilder(this.prefixedSearchTrees, this.elementList);
    }

    private static CombinedSearchTrees buildCombinedSearchTrees(ISearchTree searchTree, Collection<PrefixedSearchTree> prefixedSearchTrees) {
        CombinedSearchTrees combinedSearchTrees = new CombinedSearchTrees();
        combinedSearchTrees.addSearchTree(searchTree);
        for (PrefixedSearchTree prefixedTree : prefixedSearchTrees) {
            if (prefixedTree.getMode() != Config.SearchMode.ENABLED) continue;
            combinedSearchTrees.addSearchTree(prefixedTree.getTree());
        }
        return combinedSearchTrees;
    }

    private void createPrefixedSearchTree(char prefix, PrefixedSearchTree.IModeGetter modeGetter, PrefixedSearchTree.IStringsGetter stringsGetter) {
        GeneralizedSuffixTree tree = new GeneralizedSuffixTree();
        PrefixedSearchTree prefixedTree = new PrefixedSearchTree(tree, stringsGetter, modeGetter);
        this.prefixedSearchTrees.put(prefix, (Object)prefixedTree);
    }

    public void addIngredients(NonNullList<IIngredientListElement> ingredients) {
        ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"Indexing ingredients", (int)ingredients.size());
        for (IIngredientListElement element : ingredients) {
            progressBar.step(element.getDisplayName());
            this.addIngredient(element);
        }
        ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
    }

    public <V> void addIngredient(IIngredientListElement<V> element) {
        this.updateHiddenState(element);
        int index = this.elementList.size();
        this.elementList.add(element);
        this.searchTree.put(Translator.toLowercaseWithLocale(element.getDisplayName()), index);
        for (PrefixedSearchTree prefixedSearchTree : this.prefixedSearchTrees.valueCollection()) {
            Config.SearchMode searchMode = prefixedSearchTree.getMode();
            if (searchMode == Config.SearchMode.DISABLED) continue;
            Collection<String> strings = prefixedSearchTree.getStringsGetter().getStrings(element);
            for (String string : strings) {
                prefixedSearchTree.getTree().put(string, index);
            }
        }
        this.filterCached = null;
    }

    public void invalidateCache() {
        this.filterCached = null;
    }

    public <V> List<IIngredientListElement<V>> findMatchingElements(IIngredientListElement<V> element) {
        IIngredientHelper<Object> ingredientHelper = element.getIngredientHelper();
        V ingredient = element.getIngredient();
        String ingredientUid = ingredientHelper.getUniqueId(ingredient);
        Class<?> ingredientClass = ingredient.getClass();
        ArrayList<IIngredientListElement<V>> matchingElements = new ArrayList<IIngredientListElement<V>>();
        TIntSet matchingIndexes = this.searchTree.search(Translator.toLowercaseWithLocale(element.getDisplayName()));
        for (int index : matchingIndexes) {
            Object castMatchingIngredient;
            String matchingUid;
            IIngredientListElement matchingElement = (IIngredientListElement)this.elementList.get(index);
            Object matchingIngredient = matchingElement.getIngredient();
            if (!ingredientClass.isInstance(matchingIngredient) || !ingredientUid.equals(matchingUid = ingredientHelper.getUniqueId(castMatchingIngredient = ingredientClass.cast(matchingIngredient)))) continue;
            IIngredientListElement matchingElementCast = matchingElement;
            matchingElements.add(matchingElementCast);
        }
        return matchingElements;
    }

    public void modesChanged() {
        this.combinedSearchTrees = IngredientFilter.buildCombinedSearchTrees(this.searchTree, this.prefixedSearchTrees.valueCollection());
        this.backgroundBuilder.start();
        this.filterCached = null;
    }

    @SubscribeEvent
    public void onEditModeToggleEvent(EditModeToggleEvent event) {
        this.filterCached = null;
        this.updateHidden();
    }

    @SubscribeEvent
    public void onPlayerJoinedWorldEvent(PlayerJoinedWorldEvent event) {
        this.filterCached = null;
        this.updateHidden();
    }

    private void updateHidden() {
        for (IIngredientListElement element : this.elementList) {
            this.updateHiddenState(element);
        }
    }

    public <V> void updateHiddenState(IIngredientListElement<V> element) {
        IIngredientHelper<V> ingredientHelper;
        boolean visible;
        V ingredient = element.getIngredient();
        boolean bl = visible = !this.blacklist.isIngredientBlacklistedByApi(ingredient, ingredientHelper = element.getIngredientHelper()) && ingredientHelper.isIngredientOnServer(ingredient) && (Config.isEditModeEnabled() || !this.blacklist.isIngredientBlacklistedByConfig(ingredient, ingredientHelper));
        if (element.isVisible() != visible) {
            element.setVisible(visible);
            this.filterCached = null;
        }
    }

    public List<IIngredientListElement> getIngredientList() {
        String filterText = Translator.toLowercaseWithLocale(Config.getFilterText());
        if (!filterText.equals(this.filterCached)) {
            List<IIngredientListElement> ingredientList = this.getIngredientListUncached(filterText);
            ingredientList.sort(IngredientListElementComparator.INSTANCE);
            this.ingredientListCached = Collections.unmodifiableList(ingredientList);
            this.filterCached = filterText;
        }
        return this.ingredientListCached;
    }

    @Override
    public ImmutableList<Object> getFilteredIngredients() {
        List<IIngredientListElement> elements = this.getIngredientList();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (IIngredientListElement element : elements) {
            Object ingredient = element.getIngredient();
            builder.add(ingredient);
        }
        return builder.build();
    }

    @Override
    public String getFilterText() {
        return Config.getFilterText();
    }

    @Override
    public void setFilterText(String filterText) {
        JeiRuntime runtime;
        ErrorUtil.checkNotNull(filterText, "filterText");
        if (Config.setFilterText(filterText) && (runtime = Internal.getRuntime()) != null) {
            IngredientListOverlay ingredientListOverlay = runtime.getIngredientListOverlay();
            ingredientListOverlay.onSetFilterText(filterText);
        }
    }

    private List<IIngredientListElement> getIngredientListUncached(String filterText) {
        String[] filters = filterText.split("\\|");
        TIntSet matches = null;
        for (String filter : filters) {
            TIntSet elements = this.getElements(filter);
            if (elements == null) continue;
            if (matches == null) {
                matches = elements;
                continue;
            }
            matches.addAll((TIntCollection)elements);
        }
        ArrayList<IIngredientListElement> matchingIngredients = new ArrayList<IIngredientListElement>();
        if (matches == null) {
            for (IIngredientListElement element : this.elementList) {
                if (!element.isVisible()) continue;
                matchingIngredients.add(element);
            }
        } else {
            int[] matchesList = matches.toArray();
            Arrays.sort(matchesList);
            int[] nArray = matchesList;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Integer match = nArray[i];
                IIngredientListElement element = (IIngredientListElement)this.elementList.get(match.intValue());
                if (!element.isVisible()) continue;
                matchingIngredients.add(element);
            }
        }
        return matchingIngredients;
    }

    @Nullable
    private TIntSet getElements(String filterText) {
        Matcher filterMatcher = FILTER_SPLIT_PATTERN.matcher(filterText);
        TIntSet matches = null;
        TIntSet removeMatches = null;
        while (filterMatcher.find()) {
            TIntSet searchResults;
            String token = filterMatcher.group(1);
            boolean remove = token.startsWith("-");
            if (remove) {
                token = token.substring(1);
            }
            if ((searchResults = this.getSearchResults(token = QUOTE_PATTERN.matcher(token).replaceAll(""))) == null) continue;
            if (remove) {
                if (removeMatches == null) {
                    removeMatches = searchResults;
                    continue;
                }
                removeMatches.addAll((TIntCollection)searchResults);
                continue;
            }
            if (!(matches = matches == null ? searchResults : IngredientFilter.intersection(matches, searchResults)).isEmpty()) continue;
            break;
        }
        if (matches != null && removeMatches != null) {
            matches.removeAll(removeMatches);
        }
        return matches;
    }

    @Nullable
    private TIntSet getSearchResults(String token) {
        if (token.isEmpty()) {
            return null;
        }
        char firstChar = token.charAt(0);
        PrefixedSearchTree prefixedSearchTree = (PrefixedSearchTree)this.prefixedSearchTrees.get(firstChar);
        if (prefixedSearchTree != null && prefixedSearchTree.getMode() != Config.SearchMode.DISABLED) {
            if ((token = token.substring(1)).isEmpty()) {
                return null;
            }
            GeneralizedSuffixTree tree = prefixedSearchTree.getTree();
            return tree.search(token);
        }
        return this.combinedSearchTrees.search(token);
    }

    private static TIntSet intersection(TIntSet set1, TIntSet set2) {
        if (set1.size() > set2.size()) {
            set2.retainAll((TIntCollection)set1);
            return set2;
        }
        set1.retainAll((TIntCollection)set2);
        return set1;
    }

    public int size() {
        return this.getIngredientList().size();
    }
}

