/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.ingredients;

import gnu.trove.map.TCharObjectMap;
import java.util.Collection;
import mezz.jei.config.Config;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.ingredients.PrefixedSearchTree;
import mezz.jei.suffixtree.GeneralizedSuffixTree;
import net.minecraft.client.Minecraft;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class IngredientFilterBackgroundBuilder {
    private final TCharObjectMap<PrefixedSearchTree> prefixedSearchTrees;
    private final NonNullList<IIngredientListElement> elementList;

    public IngredientFilterBackgroundBuilder(TCharObjectMap<PrefixedSearchTree> prefixedSearchTrees, NonNullList<IIngredientListElement> elementList) {
        this.prefixedSearchTrees = prefixedSearchTrees;
        this.elementList = elementList;
    }

    public void start() {
        boolean finished = this.run(10000);
        if (!finished) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        boolean finished;
        if (event.side == Side.CLIENT && Minecraft.func_71410_x().field_71439_g != null && !(finished = this.run(20))) {
            return;
        }
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    private boolean run(int timeoutMs) {
        long startTime = System.currentTimeMillis();
        for (PrefixedSearchTree prefixedTree : this.prefixedSearchTrees.valueCollection()) {
            Config.SearchMode mode = prefixedTree.getMode();
            if (mode == Config.SearchMode.DISABLED) continue;
            PrefixedSearchTree.IStringsGetter stringsGetter = prefixedTree.getStringsGetter();
            GeneralizedSuffixTree tree = prefixedTree.getTree();
            for (int i = tree.getHighestIndex() + 1; i < this.elementList.size(); ++i) {
                IIngredientListElement element = (IIngredientListElement)this.elementList.get(i);
                Collection<String> strings = stringsGetter.getStrings(element);
                if (strings.isEmpty()) {
                    tree.put("", i);
                } else {
                    for (String string : strings) {
                        tree.put(string, i);
                    }
                }
                if (System.currentTimeMillis() - startTime < (long)timeoutMs) continue;
                return false;
            }
        }
        return true;
    }
}

