/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.ingredients;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mezz.jei.Internal;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.config.Config;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.ingredients.IngredientBlacklistInternal;
import mezz.jei.ingredients.IngredientFilter;
import mezz.jei.ingredients.IngredientListElementFactory;
import mezz.jei.startup.IModIdHelper;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.IngredientSet;
import mezz.jei.util.Log;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionHelper;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.NonNullList;

public class IngredientRegistry
implements IIngredientRegistry {
    private final IModIdHelper modIdHelper;
    private final IngredientBlacklistInternal blacklist;
    private final Map<Class, IngredientSet> ingredientsMap;
    private final ImmutableMap<Class, IIngredientHelper> ingredientHelperMap;
    private final ImmutableMap<Class, IIngredientRenderer> ingredientRendererMap;
    private final NonNullList<ItemStack> fuels = NonNullList.func_191196_a();
    private final NonNullList<ItemStack> potionIngredients = NonNullList.func_191196_a();

    public IngredientRegistry(IModIdHelper modIdHelper, IngredientBlacklistInternal blacklist, Map<Class, IngredientSet> ingredientsMap, ImmutableMap<Class, IIngredientHelper> ingredientHelperMap, ImmutableMap<Class, IIngredientRenderer> ingredientRendererMap) {
        this.modIdHelper = modIdHelper;
        this.blacklist = blacklist;
        this.ingredientsMap = ingredientsMap;
        this.ingredientHelperMap = ingredientHelperMap;
        this.ingredientRendererMap = ingredientRendererMap;
        for (ItemStack itemStack : this.getAllIngredients(ItemStack.class)) {
            this.getStackProperties(itemStack);
        }
    }

    private void getStackProperties(ItemStack itemStack) {
        String itemStackInfo;
        try {
            if (TileEntityFurnace.func_145954_b((ItemStack)itemStack)) {
                this.fuels.add((Object)itemStack);
            }
        }
        catch (LinkageError | RuntimeException e) {
            itemStackInfo = ErrorUtil.getItemStackInfo(itemStack);
            Log.get().error("Failed to check if item is fuel {}.", (Object)itemStackInfo, (Object)e);
        }
        try {
            if (PotionHelper.func_185205_a((ItemStack)itemStack)) {
                this.potionIngredients.add((Object)itemStack);
            }
        }
        catch (LinkageError | RuntimeException e) {
            itemStackInfo = ErrorUtil.getItemStackInfo(itemStack);
            Log.get().error("Failed to check if item is a potion ingredient {}.", (Object)itemStackInfo, (Object)e);
        }
    }

    @Override
    public <V> List<V> getIngredients(Class<V> ingredientClass) {
        ErrorUtil.checkNotNull(ingredientClass, "ingredientClass");
        IngredientSet ingredients = this.ingredientsMap.get(ingredientClass);
        if (ingredients == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Collection)ingredients);
    }

    @Override
    public <V> Collection<V> getAllIngredients(Class<V> ingredientClass) {
        IngredientSet ingredients = this.ingredientsMap.get(ingredientClass);
        if (ingredients == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableCollection(ingredients);
    }

    public <V> boolean isValidIngredient(V ingredient) {
        try {
            IIngredientHelper<V> ingredientHelper = this.getIngredientHelper(ingredient);
            return ingredientHelper.isValidIngredient(ingredient);
        }
        catch (RuntimeException ignored) {
            return false;
        }
    }

    @Override
    public <V> IIngredientHelper<V> getIngredientHelper(V ingredient) {
        ErrorUtil.checkNotNull(ingredient, "ingredient");
        return this.getIngredientHelper(ingredient.getClass());
    }

    @Override
    public <V> IIngredientHelper<V> getIngredientHelper(Class<? extends V> ingredientClass) {
        ErrorUtil.checkNotNull(ingredientClass, "ingredientClass");
        IIngredientHelper ingredientHelper = (IIngredientHelper)this.ingredientHelperMap.get(ingredientClass);
        if (ingredientHelper != null) {
            return ingredientHelper;
        }
        for (Map.Entry entry : this.ingredientHelperMap.entrySet()) {
            if (!((Class)entry.getKey()).isAssignableFrom(ingredientClass)) continue;
            return (IIngredientHelper)entry.getValue();
        }
        throw new IllegalArgumentException("Unknown ingredient type: " + ingredientClass);
    }

    @Override
    public <V> IIngredientRenderer<V> getIngredientRenderer(V ingredient) {
        ErrorUtil.checkNotNull(ingredient, "ingredient");
        Class<?> ingredientClass = ingredient.getClass();
        return this.getIngredientRenderer(ingredientClass);
    }

    @Override
    public <V> IIngredientRenderer<V> getIngredientRenderer(Class<? extends V> ingredientClass) {
        ErrorUtil.checkNotNull(ingredientClass, "ingredientClass");
        IIngredientRenderer ingredientRenderer = (IIngredientRenderer)this.ingredientRendererMap.get(ingredientClass);
        if (ingredientRenderer == null) {
            throw new IllegalArgumentException("Could not find ingredient renderer for " + ingredientClass);
        }
        return ingredientRenderer;
    }

    @Override
    public Collection<Class> getRegisteredIngredientClasses() {
        return Collections.unmodifiableCollection(this.ingredientsMap.keySet());
    }

    @Override
    public List<ItemStack> getFuels() {
        return Collections.unmodifiableList(this.fuels);
    }

    @Override
    public List<ItemStack> getPotionIngredients() {
        return Collections.unmodifiableList(this.potionIngredients);
    }

    @Override
    public <V> void addIngredientsAtRuntime(Class<V> ingredientClass, List<V> ingredients) {
        this.addIngredientsAtRuntime(ingredientClass, ingredients, Internal.getIngredientFilter());
    }

    @Override
    public <V> void addIngredientsAtRuntime(Class<V> ingredientClass, Collection<V> ingredients) {
        this.addIngredientsAtRuntime(ingredientClass, ingredients, Internal.getIngredientFilter());
    }

    public <V> void addIngredientsAtRuntime(Class<V> ingredientClass, Collection<V> ingredients, IngredientFilter ingredientFilter) {
        ErrorUtil.assertMainThread();
        ErrorUtil.checkNotNull(ingredientClass, "ingredientClass");
        ErrorUtil.checkNotEmpty(ingredients, "ingredients");
        Log.get().info("Ingredients are being added at runtime: {} {}", (Object)ingredients.size(), (Object)ingredientClass.getName());
        IIngredientHelper ingredientHelper = this.getIngredientHelper(ingredientClass);
        Set set = this.ingredientsMap.computeIfAbsent(ingredientClass, k -> IngredientSet.create(ingredientClass, ingredientHelper));
        for (V ingredient : ingredients) {
            set.add(ingredient);
            if (!(ingredient instanceof ItemStack)) continue;
            this.getStackProperties((ItemStack)ingredient);
        }
        NonNullList<IIngredientListElement<V>> ingredientListElements = IngredientListElementFactory.createList(this, ingredientClass, ingredients, this.modIdHelper);
        for (IIngredientListElement element : ingredientListElements) {
            List matchingElements = ingredientFilter.findMatchingElements(element);
            if (!matchingElements.isEmpty()) {
                for (IIngredientListElement matchingElement : matchingElements) {
                    this.blacklist.removeIngredientFromBlacklist(matchingElement.getIngredient(), ingredientHelper);
                    ingredientFilter.updateHiddenState(matchingElement);
                }
                if (!Config.isDebugModeEnabled()) continue;
                Log.get().debug("Updated ingredient: {}", (Object)ingredientHelper.getErrorInfo(element.getIngredient()));
                continue;
            }
            this.blacklist.removeIngredientFromBlacklist(element.getIngredient(), ingredientHelper);
            ingredientFilter.addIngredient(element);
            if (!Config.isDebugModeEnabled()) continue;
            Log.get().debug("Added ingredient: {}", (Object)ingredientHelper.getErrorInfo(element.getIngredient()));
        }
        ingredientFilter.invalidateCache();
    }

    @Override
    public <V> void removeIngredientsAtRuntime(Class<V> ingredientClass, List<V> ingredients) {
        this.removeIngredientsAtRuntime(ingredientClass, ingredients, Internal.getIngredientFilter());
    }

    @Override
    public <V> void removeIngredientsAtRuntime(Class<V> ingredientClass, Collection<V> ingredients) {
        this.removeIngredientsAtRuntime(ingredientClass, ingredients, Internal.getIngredientFilter());
    }

    public <V> void removeIngredientsAtRuntime(Class<V> ingredientClass, Collection<V> ingredients, IngredientFilter ingredientFilter) {
        ErrorUtil.assertMainThread();
        ErrorUtil.checkNotNull(ingredientClass, "ingredientClass");
        ErrorUtil.checkNotEmpty(ingredients, "ingredients");
        Log.get().info("Ingredients are being removed at runtime: {} {}", (Object)ingredients.size(), (Object)ingredientClass.getName());
        IngredientSet set = this.ingredientsMap.get(ingredientClass);
        if (set != null) {
            set.removeAll(ingredients);
        }
        IIngredientHelper ingredientHelper = this.getIngredientHelper(ingredientClass);
        NonNullList<IIngredientListElement<V>> ingredientListElements = IngredientListElementFactory.createList(this, ingredientClass, ingredients, this.modIdHelper);
        for (IIngredientListElement element : ingredientListElements) {
            List matchingElements = ingredientFilter.findMatchingElements(element);
            if (matchingElements.isEmpty()) {
                Object ingredient = element.getIngredient();
                String errorInfo = ingredientHelper.getErrorInfo(ingredient);
                Log.get().error("Could not find any matching ingredients to remove: {}", (Object)errorInfo);
            } else if (Config.isDebugModeEnabled()) {
                Log.get().debug("Removed ingredient: {}", (Object)ingredientHelper.getErrorInfo(element.getIngredient()));
            }
            for (IIngredientListElement matchingElement : matchingElements) {
                this.blacklist.addIngredientToBlacklist(matchingElement.getIngredient(), ingredientHelper);
                matchingElement.setVisible(false);
            }
        }
        ingredientFilter.invalidateCache();
    }

    public <V> boolean isIngredientInvisible(V ingredient, IngredientFilter ingredientFilter) {
        Class<?> ingredientClass = ingredient.getClass();
        IIngredientListElement<?> element = IngredientListElementFactory.createElement(this, ingredientClass, ingredient, this.modIdHelper);
        if (element == null) {
            return true;
        }
        List<IIngredientListElement<?>> matchingElements = ingredientFilter.findMatchingElements(element);
        if (matchingElements.isEmpty()) {
            return false;
        }
        for (IIngredientListElement<?> matchingElement : matchingElements) {
            if (!matchingElement.isVisible()) continue;
            return false;
        }
        return true;
    }
}

