/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.input;

import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.config.Config;
import mezz.jei.config.KeyBindings;
import mezz.jei.gui.Focus;
import mezz.jei.gui.overlay.IngredientListOverlay;
import mezz.jei.gui.recipes.RecipeClickableArea;
import mezz.jei.gui.recipes.RecipesGui;
import mezz.jei.input.GuiContainerWrapper;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.input.IShowsRecipeFocuses;
import mezz.jei.input.MouseHelper;
import mezz.jei.recipes.RecipeRegistry;
import mezz.jei.runtime.JeiRuntime;
import mezz.jei.util.ReflectionUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class InputHandler {
    private final RecipeRegistry recipeRegistry;
    private final IIngredientRegistry ingredientRegistry;
    private final RecipesGui recipesGui;
    private final IngredientListOverlay ingredientListOverlay;
    private final List<IShowsRecipeFocuses> showsRecipeFocuses = new ArrayList<IShowsRecipeFocuses>();
    private final IntSet clickHandled = new IntArraySet();

    public InputHandler(JeiRuntime runtime, IngredientListOverlay ingredientListOverlay) {
        this.recipeRegistry = runtime.getRecipeRegistry();
        this.ingredientRegistry = runtime.getIngredientRegistry();
        this.recipesGui = runtime.getRecipesGui();
        this.ingredientListOverlay = ingredientListOverlay;
        this.showsRecipeFocuses.add(this.recipesGui);
        this.showsRecipeFocuses.add(ingredientListOverlay);
        this.showsRecipeFocuses.add(new GuiContainerWrapper());
    }

    public boolean handleMouseEvent(GuiScreen guiScreen, int mouseX, int mouseY) {
        boolean cancelEvent = false;
        int eventButton = Mouse.getEventButton();
        if (eventButton > -1) {
            if (Mouse.getEventButtonState()) {
                if (!this.clickHandled.contains(eventButton) && (cancelEvent = this.handleMouseClick(guiScreen, eventButton, mouseX, mouseY))) {
                    this.clickHandled.add(eventButton);
                }
            } else if (this.clickHandled.contains(eventButton)) {
                this.clickHandled.remove(eventButton);
                cancelEvent = true;
            }
        } else if (Mouse.getEventDWheel() != 0) {
            cancelEvent = this.handleMouseScroll(Mouse.getEventDWheel(), mouseX, mouseY);
        }
        return cancelEvent;
    }

    private boolean handleMouseScroll(int dWheel, int mouseX, int mouseY) {
        return this.ingredientListOverlay.handleMouseScrolled(mouseX, mouseY, dWheel);
    }

    private boolean handleMouseClick(GuiScreen guiScreen, int mouseButton, int mouseX, int mouseY) {
        GuiContainer guiContainer;
        RecipeClickableArea clickableArea;
        IClickedIngredient<?> clicked = this.getFocusUnderMouseForClick(mouseX, mouseY);
        if (Config.isEditModeEnabled() && clicked != null && this.handleClickEdit(mouseButton, clicked)) {
            return true;
        }
        if (this.ingredientListOverlay.handleMouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (clicked != null && this.handleMouseClickedFocus(mouseButton, clicked)) {
            return true;
        }
        if (this.handleFocusKeybinds(mouseButton - 100)) {
            return true;
        }
        if (guiScreen instanceof GuiContainer && (clickableArea = this.recipeRegistry.getRecipeClickableArea(guiContainer = (GuiContainer)guiScreen, mouseX - guiContainer.getGuiLeft(), mouseY - guiContainer.getGuiTop())) != null) {
            List<String> recipeCategoryUids = clickableArea.getRecipeCategoryUids();
            this.recipesGui.showCategories(recipeCategoryUids);
            return true;
        }
        return this.handleGlobalKeybinds(mouseButton - 100);
    }

    @Nullable
    private IClickedIngredient<?> getFocusUnderMouseForClick(int mouseX, int mouseY) {
        for (IShowsRecipeFocuses gui : this.showsRecipeFocuses) {
            IClickedIngredient<?> clicked;
            if (!gui.canSetFocusWithMouse() || (clicked = gui.getIngredientUnderMouse(mouseX, mouseY)) == null) continue;
            return clicked;
        }
        return null;
    }

    @Nullable
    private IClickedIngredient<?> getIngredientUnderMouseForKey(int mouseX, int mouseY) {
        for (IShowsRecipeFocuses gui : this.showsRecipeFocuses) {
            IClickedIngredient<?> clicked = gui.getIngredientUnderMouse(mouseX, mouseY);
            if (clicked == null) continue;
            return clicked;
        }
        return null;
    }

    private <V> boolean handleMouseClickedFocus(int mouseButton, IClickedIngredient<V> clicked) {
        if (mouseButton == 0) {
            Focus<V> focus = new Focus<V>(IFocus.Mode.OUTPUT, clicked.getValue());
            this.recipesGui.show(focus);
            clicked.onClickHandled();
            return true;
        }
        if (mouseButton == 1) {
            Focus<V> focus = new Focus<V>(IFocus.Mode.INPUT, clicked.getValue());
            this.recipesGui.show(focus);
            clicked.onClickHandled();
            return true;
        }
        return false;
    }

    private <V> boolean handleClickEdit(int mouseButton, IClickedIngredient<V> clicked) {
        V ingredient = clicked.getValue();
        Config.IngredientBlacklistType blacklistType = null;
        if (GuiScreen.func_146271_m()) {
            if (GuiScreen.func_146272_n()) {
                if (mouseButton == 0) {
                    blacklistType = Config.IngredientBlacklistType.MOD_ID;
                }
            } else if (mouseButton == 0) {
                blacklistType = Config.IngredientBlacklistType.ITEM;
            } else if (mouseButton == 1) {
                blacklistType = Config.IngredientBlacklistType.WILDCARD;
            }
        }
        if (blacklistType == null) {
            return false;
        }
        IIngredientHelper<V> ingredientHelper = this.ingredientRegistry.getIngredientHelper(ingredient);
        if (Config.isIngredientOnConfigBlacklist(ingredient, blacklistType, ingredientHelper)) {
            Config.removeIngredientFromConfigBlacklist(ingredient, blacklistType, ingredientHelper);
        } else {
            Config.addIngredientToConfigBlacklist(ingredient, blacklistType, ingredientHelper);
        }
        clicked.onClickHandled();
        return true;
    }

    public boolean hasKeyboardFocus() {
        return this.ingredientListOverlay.isEnabled() && this.ingredientListOverlay.hasKeyboardFocus();
    }

    public boolean handleKeyEvent() {
        char typedChar = Keyboard.getEventCharacter();
        int eventKey = Keyboard.getEventKey();
        return (eventKey == 0 && typedChar >= ' ' || Keyboard.getEventKeyState()) && this.handleKeyDown(typedChar, eventKey);
    }

    private boolean handleKeyDown(char typedChar, int eventKey) {
        if (this.ingredientListOverlay.isEnabled() && this.ingredientListOverlay.hasKeyboardFocus()) {
            if (InputHandler.isInventoryCloseKey(eventKey) || InputHandler.isEnterKey(eventKey)) {
                this.ingredientListOverlay.setKeyboardFocus(false);
                return true;
            }
            if (this.ingredientListOverlay.onKeyPressed(typedChar, eventKey)) {
                return true;
            }
        }
        if (this.handleGlobalKeybinds(eventKey)) {
            return true;
        }
        if (!this.isContainerTextFieldFocused()) {
            if (this.handleFocusKeybinds(eventKey)) {
                return true;
            }
            if (this.ingredientListOverlay.isEnabled()) {
                return this.ingredientListOverlay.onKeyPressed(typedChar, eventKey);
            }
            return false;
        }
        return false;
    }

    private boolean handleGlobalKeybinds(int eventKey) {
        if (KeyBindings.toggleOverlay.isActiveAndMatches(eventKey)) {
            Config.toggleOverlayEnabled();
            return false;
        }
        if (this.ingredientListOverlay.isEnabled()) {
            if (KeyBindings.toggleCheatMode.isActiveAndMatches(eventKey)) {
                Config.toggleCheatItemsEnabled();
                return true;
            }
            if (KeyBindings.focusSearch.isActiveAndMatches(eventKey)) {
                this.ingredientListOverlay.setKeyboardFocus(true);
                return true;
            }
        }
        return false;
    }

    private boolean handleFocusKeybinds(int eventKey) {
        IClickedIngredient<?> clicked;
        boolean showRecipe = KeyBindings.showRecipe.isActiveAndMatches(eventKey);
        boolean showUses = KeyBindings.showUses.isActiveAndMatches(eventKey);
        if ((showRecipe || showUses) && (clicked = this.getIngredientUnderMouseForKey(MouseHelper.getX(), MouseHelper.getY())) != null) {
            IFocus.Mode mode = showRecipe ? IFocus.Mode.OUTPUT : IFocus.Mode.INPUT;
            this.recipesGui.show(new Focus(mode, clicked.getValue()));
            clicked.onClickHandled();
            return true;
        }
        return false;
    }

    private boolean isContainerTextFieldFocused() {
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        if (gui == null) {
            return false;
        }
        GuiTextField textField = ReflectionUtil.getFieldWithClass(gui, GuiTextField.class);
        return textField != null && textField.func_146176_q() && textField.func_146206_l();
    }

    public static boolean isInventoryToggleKey(int keyCode) {
        return Minecraft.func_71410_x().field_71474_y.field_151445_Q.isActiveAndMatches(keyCode);
    }

    public static boolean isInventoryCloseKey(int keyCode) {
        return keyCode == 1;
    }

    public static boolean isEnterKey(int keyCode) {
        return keyCode == 28;
    }
}

