/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.crafting;

import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IStackHelper;
import mezz.jei.api.recipe.wrapper.ICraftingRecipeWrapper;
import mezz.jei.recipes.BrokenCraftingRecipeException;
import mezz.jei.util.ErrorUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;

public class ShapelessRecipeWrapper<T extends IRecipe>
implements ICraftingRecipeWrapper {
    private final IJeiHelpers jeiHelpers;
    protected final T recipe;

    public ShapelessRecipeWrapper(IJeiHelpers jeiHelpers, T recipe) {
        this.jeiHelpers = jeiHelpers;
        this.recipe = recipe;
    }

    @Override
    public void getIngredients(IIngredients ingredients) {
        ItemStack recipeOutput = this.recipe.func_77571_b();
        IStackHelper stackHelper = this.jeiHelpers.getStackHelper();
        try {
            List inputLists = stackHelper.expandRecipeItemStackInputs((List)this.recipe.func_192400_c());
            ingredients.setInputLists(ItemStack.class, inputLists);
            ingredients.setOutput(ItemStack.class, recipeOutput);
        }
        catch (RuntimeException e) {
            String info = ErrorUtil.getInfoFromBrokenCraftingRecipe(this.recipe, (List)this.recipe.func_192400_c(), recipeOutput);
            throw new BrokenCraftingRecipeException(info, e);
        }
    }

    @Override
    @Nullable
    public ResourceLocation getRegistryName() {
        return this.recipe.getRegistryName();
    }
}

