/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.transfer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import mezz.jei.JustEnoughItems;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.config.SessionData;
import mezz.jei.network.packets.PacketRecipeTransfer;
import mezz.jei.startup.StackHelper;
import mezz.jei.util.Log;
import mezz.jei.util.Translator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class BasicRecipeTransferHandler<C extends Container>
implements IRecipeTransferHandler<C> {
    private final StackHelper stackHelper;
    private final IRecipeTransferHandlerHelper handlerHelper;
    private final IRecipeTransferInfo<C> transferHelper;

    public BasicRecipeTransferHandler(StackHelper stackHelper, IRecipeTransferHandlerHelper handlerHelper, IRecipeTransferInfo<C> transferHelper) {
        this.stackHelper = stackHelper;
        this.handlerHelper = handlerHelper;
        this.transferHelper = transferHelper;
    }

    @Override
    public Class<C> getContainerClass() {
        return this.transferHelper.getContainerClass();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public IRecipeTransferError transferRecipe(C container, IRecipeLayout recipeLayout, EntityPlayer player, boolean maxTransfer, boolean doTransfer) {
        ItemStack stack;
        void var8_12;
        if (!SessionData.isJeiOnServer()) {
            String tooltipMessage = Translator.translateToLocal("jei.tooltip.error.recipe.transfer.no.server");
            return this.handlerHelper.createUserErrorWithTooltip(tooltipMessage);
        }
        if (!this.transferHelper.canHandle(container)) {
            return this.handlerHelper.createInternalError();
        }
        HashMap<Integer, Slot> inventorySlots = new HashMap<Integer, Slot>();
        for (Slot slot : this.transferHelper.getInventorySlots(container)) {
            inventorySlots.put(slot.field_75222_d, slot);
        }
        HashMap<Integer, Slot> craftingSlots = new HashMap<Integer, Slot>();
        for (Slot slot : this.transferHelper.getRecipeSlots(container)) {
            craftingSlots.put(slot.field_75222_d, slot);
        }
        boolean bl = false;
        IGuiItemStackGroup itemStackGroup = recipeLayout.getItemStacks();
        for (IGuiIngredient ingredient : itemStackGroup.getGuiIngredients().values()) {
            if (!ingredient.isInput() || ingredient.getAllIngredients().isEmpty()) continue;
            ++var8_12;
        }
        if (var8_12 > craftingSlots.size()) {
            Log.get().error("Recipe Transfer helper {} does not work for container {}", this.transferHelper.getClass(), container.getClass());
            return this.handlerHelper.createInternalError();
        }
        HashMap<Integer, ItemStack> availableItemStacks = new HashMap<Integer, ItemStack>();
        int filledCraftSlotCount = 0;
        int emptySlotCount = 0;
        for (Slot slot : craftingSlots.values()) {
            stack = slot.func_75211_c();
            if (stack.func_190926_b()) continue;
            if (!slot.func_82869_a(player)) {
                Log.get().error("Recipe Transfer helper {} does not work for container {}. Player can't move item out of Crafting Slot number {}", this.transferHelper.getClass(), container.getClass(), (Object)slot.field_75222_d);
                return this.handlerHelper.createInternalError();
            }
            ++filledCraftSlotCount;
            availableItemStacks.put(slot.field_75222_d, stack.func_77946_l());
        }
        for (Slot slot : inventorySlots.values()) {
            stack = slot.func_75211_c();
            if (!stack.func_190926_b()) {
                availableItemStacks.put(slot.field_75222_d, stack.func_77946_l());
                continue;
            }
            ++emptySlotCount;
        }
        if (filledCraftSlotCount - var8_12 > emptySlotCount) {
            String message = Translator.translateToLocal("jei.tooltip.error.recipe.transfer.inventory.full");
            return this.handlerHelper.createUserErrorWithTooltip(message);
        }
        StackHelper.MatchingItemsResult matchingItemsResult = this.stackHelper.getMatchingItems(availableItemStacks, itemStackGroup.getGuiIngredients());
        if (matchingItemsResult.missingItems.size() > 0) {
            String message = Translator.translateToLocal("jei.tooltip.error.recipe.transfer.missing");
            return this.handlerHelper.createUserErrorForSlots(message, matchingItemsResult.missingItems);
        }
        ArrayList<Integer> craftingSlotIndexes = new ArrayList<Integer>(craftingSlots.keySet());
        Collections.sort(craftingSlotIndexes);
        ArrayList<Integer> inventorySlotIndexes = new ArrayList<Integer>(inventorySlots.keySet());
        Collections.sort(inventorySlotIndexes);
        for (Map.Entry<Integer, Integer> entry : matchingItemsResult.matchingItems.entrySet()) {
            int craftNumber = entry.getKey();
            int slotNumber = (Integer)craftingSlotIndexes.get(craftNumber);
            if (slotNumber >= 0 && slotNumber < ((Container)container).field_75151_b.size()) continue;
            Log.get().error("Recipes Transfer Helper {} references slot {} outside of the inventory's size {}", this.transferHelper.getClass(), (Object)slotNumber, (Object)((Container)container).field_75151_b.size());
            return this.handlerHelper.createInternalError();
        }
        if (doTransfer) {
            PacketRecipeTransfer packet = new PacketRecipeTransfer(matchingItemsResult.matchingItems, craftingSlotIndexes, inventorySlotIndexes, maxTransfer, this.transferHelper.requireCompleteSets());
            JustEnoughItems.getProxy().sendPacketToServer(packet);
        }
        return null;
    }
}

