/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools;

import mcjty.lib.varia.EnergyTools;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class BlockInfo {
    private BlockPos coordinate;
    private int energyStored;
    private int maxEnergyStored;

    public BlockInfo(TileEntity tileEntity, BlockPos coordinate) {
        this.coordinate = coordinate;
        this.fetchEnergyValues(tileEntity);
    }

    public BlockInfo(BlockPos coordinate, int energyStored, int maxEnergyStored) {
        this.coordinate = coordinate;
        this.energyStored = energyStored;
        this.maxEnergyStored = maxEnergyStored;
    }

    public BlockPos getCoordinate() {
        return this.coordinate;
    }

    private void fetchEnergyValues(TileEntity tileEntity) {
        EnergyTools.EnergyLevel energyLevel = EnergyTools.getEnergyLevel((TileEntity)tileEntity);
        this.maxEnergyStored = energyLevel.getMaxEnergy();
        this.energyStored = energyLevel.getEnergy();
    }

    public int getEnergyStored() {
        return this.energyStored;
    }

    public int getMaxEnergyStored() {
        return this.maxEnergyStored;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockInfo blockInfo = (BlockInfo)o;
        if (this.energyStored != blockInfo.energyStored) {
            return false;
        }
        if (this.maxEnergyStored != blockInfo.maxEnergyStored) {
            return false;
        }
        return !(this.coordinate != null ? !this.coordinate.equals((Object)blockInfo.coordinate) : blockInfo.coordinate != null);
    }

    public int hashCode() {
        int result = this.coordinate != null ? this.coordinate.hashCode() : 0;
        result = 31 * result + this.energyStored;
        result = 31 * result + this.maxEnergyStored;
        return result;
    }
}

