/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mcjty.lib.api.information.IMachineInformation;
import mcjty.lib.api.smartwrench.SmartWrenchMode;
import mcjty.lib.gui.BlockOutlineRenderer;
import mcjty.lib.gui.HudRenderHelper;
import mcjty.lib.gui.RenderHelper;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.blockprotector.BlockProtectorConfiguration;
import mcjty.rftools.blocks.blockprotector.BlockProtectorTileEntity;
import mcjty.rftools.blocks.builder.BuilderSetup;
import mcjty.rftools.blocks.builder.BuilderTileEntity;
import mcjty.rftools.items.ModItems;
import mcjty.rftools.items.builder.ShapeCardItem;
import mcjty.rftools.items.netmonitor.NetworkMonitorItem;
import mcjty.rftools.items.smartwrench.SmartWrenchItem;
import mcjty.rftools.network.MachineInfo;
import mcjty.rftools.network.PacketReturnRfInRange;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.rftools.shapes.ShapeDataManagerClient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

@SideOnly(value=Side.CLIENT)
public class RenderWorldLastEventHandler {
    private static long lastTime = 0L;
    public static final ResourceLocation YELLOWGLOW = new ResourceLocation("rftools", "textures/blocks/yellowglow.png");

    public static void tick(RenderWorldLastEvent evt) {
        RenderWorldLastEventHandler.renderHilightedBlock(evt);
        RenderWorldLastEventHandler.renderBuilderProgress(evt);
        RenderWorldLastEventHandler.renderProtectedBlocks(evt);
        RenderWorldLastEventHandler.renderPower(evt);
        ShapeDataManagerClient.cleanupOldRenderers();
    }

    private static void renderProtectedBlocks(RenderWorldLastEvent evt) {
        GlobalCoordinate current;
        int mode;
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP p = mc.field_71439_g;
        ItemStack heldItem = p.func_184586_b(EnumHand.MAIN_HAND);
        if (heldItem.func_190926_b()) {
            return;
        }
        if (heldItem.func_77973_b() == ModItems.smartWrenchItem) {
            BlockProtectorTileEntity blockProtectorTileEntity;
            Set<BlockPos> coordinates;
            TileEntity te;
            GlobalCoordinate current2;
            if (BlockProtectorConfiguration.enabled && SmartWrenchItem.getCurrentMode(heldItem) == SmartWrenchMode.MODE_SELECT && (current2 = SmartWrenchItem.getCurrentBlock(heldItem)) != null && current2.getDimension() == mc.field_71441_e.field_73011_w.getDimension() && (te = mc.field_71441_e.func_175625_s(current2.getCoordinate())) instanceof BlockProtectorTileEntity && !(coordinates = (blockProtectorTileEntity = (BlockProtectorTileEntity)te).getProtectedBlocks()).isEmpty()) {
                RenderWorldLastEventHandler.renderHighlightedBlocks(evt, p, te.func_174877_v(), coordinates);
            }
        } else if (heldItem.func_77973_b() == BuilderSetup.shapeCardItem && ((mode = ShapeCardItem.getMode(heldItem)) == 1 || mode == 2) && (current = ShapeCardItem.getCurrentBlock(heldItem)) != null && current.getDimension() == mc.field_71441_e.field_73011_w.getDimension()) {
            HashSet<BlockPos> coordinates = new HashSet<BlockPos>();
            coordinates.add(new BlockPos(0, 0, 0));
            if (mode == 2) {
                BlockPos cur = current.getCoordinate();
                BlockPos c = ShapeCardItem.getCorner1(heldItem);
                if (c != null) {
                    coordinates.add(new BlockPos(c.func_177958_n() - cur.func_177958_n(), c.func_177956_o() - cur.func_177956_o(), c.func_177952_p() - cur.func_177952_p()));
                }
            }
            RenderWorldLastEventHandler.renderHighlightedBlocks(evt, p, current.getCoordinate(), coordinates);
        }
    }

    private static void renderHighlightedBlocks(RenderWorldLastEvent evt, EntityPlayerSP p, BlockPos base, Set<BlockPos> coordinates) {
        BlockOutlineRenderer.renderHighlightedBlocks((EntityPlayerSP)p, (BlockPos)base, coordinates, (ResourceLocation)YELLOWGLOW, (float)evt.getPartialTicks());
    }

    private static void renderBuilderProgress(RenderWorldLastEvent evt) {
        Map<BlockPos, Pair<Long, BlockPos>> scans = BuilderTileEntity.getScanLocClient();
        if (!scans.isEmpty()) {
            Minecraft mc = Minecraft.func_71410_x();
            EntityPlayerSP p = mc.field_71439_g;
            double doubleX = p.field_70142_S + (p.field_70165_t - p.field_70142_S) * (double)evt.getPartialTicks();
            double doubleY = p.field_70137_T + (p.field_70163_u - p.field_70137_T) * (double)evt.getPartialTicks();
            double doubleZ = p.field_70136_U + (p.field_70161_v - p.field_70136_U) * (double)evt.getPartialTicks();
            GlStateManager.func_179094_E();
            GlStateManager.func_179124_c((float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_187441_d((float)3.0f);
            GlStateManager.func_179137_b((double)(-doubleX), (double)(-doubleY), (double)(-doubleZ));
            GlStateManager.func_179097_i();
            GlStateManager.func_179090_x();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
            for (Map.Entry<BlockPos, Pair<Long, BlockPos>> entry : scans.entrySet()) {
                BlockPos c = (BlockPos)entry.getValue().getValue();
                float mx = c.func_177958_n();
                float my = c.func_177956_o();
                float mz = c.func_177952_p();
                RenderHelper.renderHighLightedBlocksOutline((BufferBuilder)buffer, (float)mx, (float)my, (float)mz, (float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            tessellator.func_78381_a();
            GlStateManager.func_179098_w();
            GlStateManager.func_179121_F();
        }
    }

    private static void renderHilightedBlock(RenderWorldLastEvent evt) {
        BlockPos c = RFTools.instance.clientInfo.getHilightedBlock();
        if (c == null) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        long time = System.currentTimeMillis();
        if (time > RFTools.instance.clientInfo.getExpireHilight()) {
            RFTools.instance.clientInfo.hilightBlock(null, -1L);
            return;
        }
        if ((time / 500L & 1L) == 0L) {
            return;
        }
        BlockOutlineRenderer.renderHilightedBlock((BlockPos)c, (float)evt.getPartialTicks());
    }

    private static void renderPower(RenderWorldLastEvent evt) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        ItemStack mainItem = player.func_184614_ca();
        ItemStack offItem = player.func_184592_cb();
        if (!mainItem.func_190926_b() && mainItem.func_77973_b() instanceof NetworkMonitorItem || !offItem.func_190926_b() && offItem.func_77973_b() instanceof NetworkMonitorItem) {
            double doubleX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)evt.getPartialTicks();
            double doubleY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)evt.getPartialTicks();
            double doubleZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)evt.getPartialTicks();
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(-doubleX), (double)(-doubleY), (double)(-doubleZ));
            GlStateManager.func_179097_i();
            GlStateManager.func_179098_w();
            if (System.currentTimeMillis() - lastTime > 500L) {
                lastTime = System.currentTimeMillis();
                RFToolsMessages.sendToServer("getRfInRange");
            }
            if (PacketReturnRfInRange.clientLevels == null) {
                return;
            }
            for (Map.Entry<BlockPos, MachineInfo> entry : PacketReturnRfInRange.clientLevels.entrySet()) {
                BlockPos pos = entry.getKey();
                ArrayList<String> log = new ArrayList<String>();
                MachineInfo info = entry.getValue();
                log.add(TextFormatting.BLUE + "RF:  " + TextFormatting.WHITE + info.getEnergy());
                log.add(TextFormatting.BLUE + "Max: " + TextFormatting.WHITE + info.getMaxEnergy());
                if (info.getEnergyPerTick() != null) {
                    int usage;
                    TileEntity te = player.func_130014_f_().func_175625_s(pos);
                    String unit = "";
                    if (te instanceof IMachineInformation && (unit = ((IMachineInformation)te).getEnergyUnitName()) == null) {
                        unit = "";
                    }
                    if ((usage = info.getEnergyPerTick().intValue()) < 0) {
                        log.add(TextFormatting.RED + "" + usage + unit + "/t");
                    } else if (usage > 0) {
                        log.add(TextFormatting.GREEN + "" + usage + unit + "/t");
                    }
                }
                HudRenderHelper.renderHud(log, (HudRenderHelper.HudPlacement)HudRenderHelper.HudPlacement.HUD_CENTER, (HudRenderHelper.HudOrientation)HudRenderHelper.HudOrientation.HUD_TOPLAYER, null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (float)2.0f);
                RenderWorldLastEventHandler.renderBoxOutline(pos);
            }
            GlStateManager.func_179126_j();
            GlStateManager.func_179121_F();
        }
    }

    private static void renderBoxOutline(BlockPos pos) {
        BlockPos c = RFTools.instance.clientInfo.getHilightedBlock();
        if (c != null && c.equals((Object)pos)) {
            return;
        }
        BlockOutlineRenderer.renderBoxOutline((BlockPos)pos);
    }
}

