/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.endergen;

import java.util.List;
import mcjty.lib.container.EmptyContainer;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.endergen.EnderMonitorMode;
import mcjty.rftools.blocks.endergen.EnderMonitorTileEntity;
import mcjty.rftools.blocks.endergen.GuiEnderMonitor;
import mcjty.rftools.blocks.logic.generic.LogicSlabBlock;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EnderMonitorBlock
extends LogicSlabBlock<EnderMonitorTileEntity, EmptyContainer> {
    public EnderMonitorBlock() {
        super(Material.field_151573_f, "ender_monitor", EnderMonitorTileEntity.class, EmptyContainer.class);
        this.func_149647_a(RFTools.tabRfTools);
    }

    @Override
    public boolean needsRedstoneCheck() {
        return false;
    }

    public int getGuiID() {
        return RFTools.GUI_ENDERMONITOR;
    }

    @SideOnly(value=Side.CLIENT)
    public Class<GuiEnderMonitor> getGuiClass() {
        return GuiEnderMonitor.class;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack itemStack, World player, List<String> list, ITooltipFlag whatIsThis) {
        super.func_190948_a(itemStack, player, list, whatIsThis);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            int mode = tagCompound.func_74762_e("mode");
            String smode = EnderMonitorMode.values()[mode].getDescription();
            list.add(TextFormatting.GREEN + "Mode: " + smode);
        }
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof EnderMonitorTileEntity) {
            EnderMonitorTileEntity tileEntity = (EnderMonitorTileEntity)te;
            EnderMonitorMode m = tileEntity.getMode();
            probeInfo.text(TextFormatting.GREEN + "Mode: " + m.getDescription());
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="waila")
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        TileEntity te = accessor.getTileEntity();
        if (te instanceof EnderMonitorTileEntity) {
            EnderMonitorTileEntity tileEntity = (EnderMonitorTileEntity)te;
            EnderMonitorMode m = tileEntity.getMode();
            currenttip.add(TextFormatting.GREEN + "Mode: " + m.getDescription());
        }
        return currenttip;
    }
}

