/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.environmental;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import mcjty.lib.api.information.IMachineInformation;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.entity.GenericEnergyReceiverTileEntity;
import mcjty.lib.network.Argument;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.RedstoneMode;
import mcjty.rftools.blocks.environmental.EnvModuleProvider;
import mcjty.rftools.blocks.environmental.EnvironmentalConfiguration;
import mcjty.rftools.blocks.environmental.EnvironmentalControllerContainer;
import mcjty.rftools.blocks.environmental.modules.EnvironmentModule;
import mcjty.typed.Type;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="opencomputers")})
public class EnvironmentalControllerTileEntity
extends GenericEnergyReceiverTileEntity
implements DefaultSidedInventory,
ITickable,
IMachineInformation,
SimpleComponent {
    public static final String CMD_SETRADIUS = "setRadius";
    public static final String CMD_SETBOUNDS = "setBounds";
    public static final String CMD_RSMODE = "rsMode";
    public static final String CMD_SETMODE = "setBlacklist";
    public static final String CMD_ADDPLAYER = "addPlayer";
    public static final String CMD_DELPLAYER = "delPlayer";
    public static final String CMD_GETPLAYERS = "getPlayers";
    public static final String CLIENTCMD_GETPLAYERS = "getPlayers";
    public static final String COMPONENT_NAME = "environmental_controller";
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, EnvironmentalControllerContainer.factory, 7);
    private List<EnvironmentModule> environmentModules = null;
    Set<String> players = new HashSet<String>();
    private EnvironmentalMode mode = EnvironmentalMode.MODE_BLACKLIST;
    private int totalRfPerTick = 0;
    private int radius = 50;
    private int miny = 30;
    private int maxy = 70;
    private int volume = -1;
    private boolean active = false;
    private int powerTimeout = 0;

    public EnvironmentalControllerTileEntity() {
        super(EnvironmentalConfiguration.ENVIRONMENTAL_MAXENERGY, EnvironmentalConfiguration.ENVIRONMENTAL_RECEIVEPERTICK);
    }

    public int getEnergyDiffPerTick() {
        return this.isActive() ? -this.getTotalRfPerTick() : 0;
    }

    @Nullable
    public String getEnergyUnitName() {
        return "RF";
    }

    public boolean isMachineActive() {
        return this.isActive();
    }

    public boolean isMachineRunning() {
        return this.isActive();
    }

    @Nullable
    public String getMachineStatus() {
        return this.isActive() ? "active" : "idle";
    }

    protected boolean needsRedstoneMode() {
        return true;
    }

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    @Optional.Method(modid="opencomputers")
    public String getComponentName() {
        return COMPONENT_NAME;
    }

    @Callback(doc="Get or set the current redstone mode. Values are 'Ignored', 'Off', or 'On'", getter=true, setter=true)
    @Optional.Method(modid="opencomputers")
    public Object[] redstoneMode(Context context, Arguments args) {
        if (args.count() == 0) {
            return new Object[]{this.getRSMode().getDescription()};
        }
        String mode = args.checkString(0);
        return this.setRedstoneMode(mode);
    }

    public EnvironmentalMode getMode() {
        return this.mode;
    }

    public void setMode(EnvironmentalMode mode) {
        this.mode = mode;
        this.markDirtyClient();
    }

    private float getPowerMultiplier() {
        switch (this.mode) {
            case MODE_BLACKLIST: 
            case MODE_WHITELIST: {
                return 1.0f;
            }
            case MODE_HOSTILE: 
            case MODE_PASSIVE: 
            case MODE_MOBS: 
            case MODE_ALL: {
                return EnvironmentalConfiguration.mobsPowerMultiplier;
            }
        }
        return 1.0f;
    }

    public boolean isEntityAffected(Entity entity) {
        switch (this.mode) {
            case MODE_BLACKLIST: {
                if (entity instanceof EntityPlayer) {
                    return this.isPlayerAffected((EntityPlayer)entity);
                }
                return false;
            }
            case MODE_WHITELIST: {
                if (entity instanceof EntityPlayer) {
                    return this.isPlayerAffected((EntityPlayer)entity);
                }
                return false;
            }
            case MODE_HOSTILE: {
                return entity instanceof IMob;
            }
            case MODE_PASSIVE: {
                return entity instanceof IAnimals && !(entity instanceof IMob);
            }
            case MODE_MOBS: {
                return entity instanceof IAnimals;
            }
            case MODE_ALL: {
                if (entity instanceof EntityPlayer) {
                    return this.isPlayerAffected((EntityPlayer)entity);
                }
                return true;
            }
        }
        return false;
    }

    public boolean isPlayerAffected(EntityPlayer player) {
        if (this.mode == EnvironmentalMode.MODE_WHITELIST) {
            return this.players.contains(player.func_70005_c_());
        }
        if (this.mode == EnvironmentalMode.MODE_BLACKLIST) {
            return !this.players.contains(player.func_70005_c_());
        }
        return this.mode == EnvironmentalMode.MODE_ALL;
    }

    private List<String> getPlayersAsList() {
        return new ArrayList<String>(this.players);
    }

    private void addPlayer(String player) {
        if (!this.players.contains(player)) {
            this.players.add(player);
            this.markDirtyClient();
        }
    }

    private void delPlayer(String player) {
        if (this.players.contains(player)) {
            this.players.remove(player);
            this.markDirtyClient();
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public int getTotalRfPerTick() {
        if (this.environmentModules == null) {
            this.getEnvironmentModules();
        }
        int rfNeeded = (int)((float)this.totalRfPerTick * this.getPowerMultiplier() * (4.0f - this.getInfusedFactor()) / 4.0f);
        if (this.environmentModules.isEmpty()) {
            return rfNeeded;
        }
        if (rfNeeded < EnvironmentalConfiguration.MIN_USAGE) {
            rfNeeded = EnvironmentalConfiguration.MIN_USAGE;
        }
        return rfNeeded;
    }

    public int getVolume() {
        if (this.volume == -1) {
            this.volume = (int)((double)(this.radius * this.radius) * Math.PI * (double)(this.maxy - this.miny + 1));
        }
        return this.volume;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
        this.volume = -1;
        this.environmentModules = null;
        this.markDirtyClient();
    }

    public int getMiny() {
        return this.miny;
    }

    public void setMiny(int miny) {
        this.miny = miny;
        this.volume = -1;
        this.environmentModules = null;
        this.markDirtyClient();
    }

    public int getMaxy() {
        return this.maxy;
    }

    public void setMaxy(int maxy) {
        this.maxy = maxy;
        this.volume = -1;
        this.environmentModules = null;
        this.markDirtyClient();
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            this.checkStateServer();
        }
    }

    private void checkStateServer() {
        if (this.powerTimeout > 0) {
            --this.powerTimeout;
            return;
        }
        int rf = this.getEnergyStored();
        if (!this.isMachineEnabled()) {
            rf = 0;
        }
        this.getEnvironmentModules();
        int rfNeeded = this.getTotalRfPerTick();
        if (rfNeeded > rf || this.environmentModules.isEmpty()) {
            this.deactivate();
            this.powerTimeout = 20;
        } else {
            this.consumeEnergy(rfNeeded);
            for (EnvironmentModule module : this.environmentModules) {
                module.activate(true);
                module.tick(this.func_145831_w(), this.func_174877_v(), this.radius, this.miny, this.maxy, this);
            }
            if (!this.active) {
                this.active = true;
                this.markDirtyClient();
            }
        }
    }

    public void deactivate() {
        for (EnvironmentModule module : this.environmentModules) {
            module.activate(false);
        }
        if (this.active) {
            this.active = false;
            this.markDirtyClient();
        }
    }

    private Object[] setRedstoneMode(String mode) {
        RedstoneMode redstoneMode = RedstoneMode.getMode((String)mode);
        if (redstoneMode == null) {
            throw new IllegalArgumentException("Not a valid mode");
        }
        this.setRSMode(redstoneMode);
        return null;
    }

    public void setPowerInput(int powered) {
        if (this.powerLevel != powered) {
            this.powerTimeout = 0;
        }
        super.setPowerInput(powered);
    }

    public List<EnvironmentModule> getEnvironmentModules() {
        if (this.environmentModules == null) {
            int volume = this.getVolume();
            this.totalRfPerTick = 0;
            this.environmentModules = new ArrayList<EnvironmentModule>();
            for (int i = 0; i < this.inventoryHelper.getCount(); ++i) {
                EnvironmentModule environmentModule;
                ItemStack itemStack = this.inventoryHelper.getStackInSlot(i);
                if (itemStack.func_190926_b() || !(itemStack.func_77973_b() instanceof EnvModuleProvider)) continue;
                EnvModuleProvider moduleProvider = (EnvModuleProvider)itemStack.func_77973_b();
                Class<? extends EnvironmentModule> moduleClass = moduleProvider.getServerEnvironmentModule();
                try {
                    environmentModule = moduleClass.newInstance();
                }
                catch (InstantiationException e) {
                    Logging.log((String)"Failed to instantiate controller module!");
                    continue;
                }
                catch (IllegalAccessException e) {
                    Logging.log((String)"Failed to instantiate controller module!");
                    continue;
                }
                this.environmentModules.add(environmentModule);
                this.totalRfPerTick += (int)(environmentModule.getRfPerTick() * (float)volume);
            }
        }
        return this.environmentModules;
    }

    public int[] func_180463_a(EnumFacing side) {
        return EnvironmentalControllerContainer.factory.getAccessibleSlots();
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return EnvironmentalControllerContainer.factory.isOutputSlot(index);
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return EnvironmentalControllerContainer.factory.isInputSlot(index);
    }

    public ItemStack func_70298_a(int index, int amount) {
        this.environmentModules = null;
        return this.inventoryHelper.decrStackSize(index, amount);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventoryHelper.setInventorySlotContents(this.func_70297_j_(), index, stack);
        this.environmentModules = null;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.totalRfPerTick = tagCompound.func_74762_e("rfPerTick");
        this.active = tagCompound.func_74767_n("active");
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
        this.radius = tagCompound.func_74762_e("radius");
        this.miny = tagCompound.func_74762_e("miny");
        this.maxy = tagCompound.func_74762_e("maxy");
        this.volume = -1;
        if (tagCompound.func_74764_b("whitelist")) {
            boolean wl = tagCompound.func_74767_n("whitelist");
            this.mode = wl ? EnvironmentalMode.MODE_WHITELIST : EnvironmentalMode.MODE_BLACKLIST;
        } else {
            int m = tagCompound.func_74762_e("mode");
            this.mode = EnvironmentalMode.values()[m];
        }
        this.players.clear();
        NBTTagList playerList = tagCompound.func_150295_c("players", 8);
        if (playerList != null) {
            for (int i = 0; i < playerList.func_74745_c(); ++i) {
                String player = playerList.func_150307_f(i);
                this.players.add(player);
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74768_a("rfPerTick", this.totalRfPerTick);
        tagCompound.func_74757_a("active", this.active);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
        tagCompound.func_74768_a("radius", this.radius);
        tagCompound.func_74768_a("miny", this.miny);
        tagCompound.func_74768_a("maxy", this.maxy);
        tagCompound.func_74768_a("mode", this.mode.ordinal());
        NBTTagList playerTagList = new NBTTagList();
        for (String player : this.players) {
            playerTagList.func_74742_a((NBTBase)new NBTTagString(player));
        }
        tagCompound.func_74782_a("players", (NBTBase)playerTagList);
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_SETRADIUS.equals(command)) {
            this.setRadius(args.get("radius").getInteger());
            return true;
        }
        if (CMD_SETBOUNDS.equals(command)) {
            int miny = args.get("miny").getInteger();
            int maxy = args.get("maxy").getInteger();
            this.setMiny(miny);
            this.setMaxy(maxy);
            return true;
        }
        if (CMD_RSMODE.equals(command)) {
            String m = args.get("rs").getString();
            this.setRSMode(RedstoneMode.getMode((String)m));
            return true;
        }
        if (CMD_ADDPLAYER.equals(command)) {
            this.addPlayer(args.get("player").getString());
            return true;
        }
        if (CMD_DELPLAYER.equals(command)) {
            this.delPlayer(args.get("player").getString());
            return true;
        }
        if (CMD_SETMODE.equals(command)) {
            Integer m = args.get("mode").getInteger();
            this.setMode(EnvironmentalMode.values()[m]);
            return true;
        }
        return false;
    }

    @Nonnull
    public <T> List<T> executeWithResultList(String command, Map<String, Argument> args, Type<T> type) {
        List rc = super.executeWithResultList(command, args, type);
        if (!rc.isEmpty()) {
            return rc;
        }
        if ("getPlayers".equals(command)) {
            return type.convert(this.getPlayersAsList());
        }
        return Collections.emptyList();
    }

    public <T> boolean execute(String command, List<T> list, Type<T> type) {
        boolean rc = super.execute(command, list, type);
        if (rc) {
            return true;
        }
        if ("getPlayers".equals(command)) {
            this.players = new HashSet<String>(Type.STRING.convert(list));
            return true;
        }
        return false;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public boolean func_191420_l() {
        return false;
    }

    public static enum EnvironmentalMode {
        MODE_BLACKLIST,
        MODE_WHITELIST,
        MODE_HOSTILE,
        MODE_PASSIVE,
        MODE_MOBS,
        MODE_ALL;

    }
}

