/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.logic.analog;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mcjty.lib.container.EmptyContainer;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.logic.analog.AnalogTileEntity;
import mcjty.rftools.blocks.logic.analog.GuiAnalog;
import mcjty.rftools.blocks.logic.generic.LogicFacing;
import mcjty.rftools.blocks.logic.generic.LogicSlabBlock;
import mcjty.rftools.blocks.logic.threelogic.ThreeLogicBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class AnalogBlock
extends LogicSlabBlock<AnalogTileEntity, EmptyContainer> {
    private Set<BlockPos> loopDetector = new HashSet<BlockPos>();

    public AnalogBlock() {
        super(Material.field_151573_f, "analog_block", AnalogTileEntity.class, EmptyContainer.class);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack itemStack, World player, List<String> list, ITooltipFlag advanced) {
        super.func_190948_a(itemStack, player, list, advanced);
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(TextFormatting.WHITE + "This logic block can do");
            list.add(TextFormatting.WHITE + "calculations on analog redstone");
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    public int getGuiID() {
        return RFTools.GUI_ANALOG;
    }

    @SideOnly(value=Side.CLIENT)
    public Class<GuiAnalog> getGuiClass() {
        return GuiAnalog.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void checkRedstone(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        TileEntity te = world.func_175625_s(pos);
        if (state.func_177230_c() instanceof LogicSlabBlock && te instanceof AnalogTileEntity && this.loopDetector.add(pos)) {
            try {
                AnalogTileEntity tileEntity = (AnalogTileEntity)te;
                LogicFacing facing = tileEntity.getFacing(state);
                EnumFacing downSide = facing.getSide();
                EnumFacing inputSide = facing.getInputSide();
                EnumFacing rightSide = ThreeLogicBlock.rotateLeft(downSide, inputSide);
                EnumFacing leftSide = ThreeLogicBlock.rotateRight(downSide, inputSide);
                int inputStrength = this.getInputStrength(world, pos, inputSide);
                int inputLeft = this.getInputStrength(world, pos, leftSide);
                int inputRight = this.getInputStrength(world, pos, rightSide);
                int outputStrength = inputLeft == inputRight ? (int)((float)inputStrength * tileEntity.getMulEqual() + (float)tileEntity.getAddEqual()) : (inputLeft < inputRight ? (int)((float)inputStrength * tileEntity.getMulLess() + (float)tileEntity.getAddLess()) : (int)((float)inputStrength * tileEntity.getMulGreater() + (float)tileEntity.getAddGreater()));
                if (outputStrength > 15) {
                    outputStrength = 15;
                } else if (outputStrength < 0) {
                    outputStrength = 0;
                }
                int oldPower = tileEntity.getPowerLevel();
                tileEntity.setPowerInput(outputStrength);
                if (oldPower != outputStrength) {
                    world.func_175685_c(pos, (Block)this, false);
                }
            }
            finally {
                this.loopDetector.remove(pos);
            }
        }
    }

    @Override
    protected int getRedstoneOutput(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity te = world.func_175625_s(pos);
        if (state.func_177230_c() instanceof AnalogBlock && te instanceof AnalogTileEntity) {
            AnalogTileEntity logicTileEntity = (AnalogTileEntity)te;
            if (side == logicTileEntity.getFacing(state).getInputSide()) {
                return logicTileEntity.getPowerLevel();
            }
            return 0;
        }
        return 0;
    }
}

