/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.logic.digit;

import java.util.List;
import mcjty.lib.container.EmptyContainer;
import mcjty.rftools.blocks.logic.digit.DigitTileEntity;
import mcjty.rftools.blocks.logic.generic.LogicSlabBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class DigitBlock
extends LogicSlabBlock<DigitTileEntity, EmptyContainer> {
    public static PropertyInteger VALUE = PropertyInteger.func_177719_a((String)"value", (int)0, (int)15);

    public DigitBlock() {
        super(Material.field_151573_f, "digit_block", DigitTileEntity.class, EmptyContainer.class);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack itemStack, World player, List<String> list, ITooltipFlag advanced) {
        super.func_190948_a(itemStack, player, list, advanced);
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(TextFormatting.WHITE + "This logic block is just a simple");
            list.add(TextFormatting.WHITE + "digit that shows the redstone input value");
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    public int getGuiID() {
        return -1;
    }

    @Override
    protected void checkRedstone(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof DigitTileEntity) {
            DigitTileEntity logicTileEntity = (DigitTileEntity)te;
            EnumFacing inputSide = logicTileEntity.getFacing(world.func_180495_p(pos)).getInputSide();
            int power = this.getInputStrength(world, pos, inputSide);
            int oldPower = logicTileEntity.getPowerLevel();
            logicTileEntity.setPowerInput(power);
            if (oldPower != power) {
                logicTileEntity.markDirtyClient();
            }
        }
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return super.canRenderInLayer(state, layer) || layer == BlockRenderLayer.CUTOUT;
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof DigitTileEntity) {
            DigitTileEntity logicTileEntity = (DigitTileEntity)te;
            return super.func_176221_a(state, world, pos).func_177226_a((IProperty)VALUE, (Comparable)Integer.valueOf(logicTileEntity.getPowerLevel()));
        }
        return super.func_176221_a(state, world, pos).func_177226_a((IProperty)VALUE, (Comparable)Integer.valueOf(0));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{LOGIC_FACING, META_INTERMEDIATE, OUTPUTPOWER, VALUE});
    }
}

