/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.logic.generic;

import mcjty.lib.container.BaseBlock;
import mcjty.lib.container.GenericItemBlock;
import mcjty.lib.varia.Logging;
import mcjty.rftools.blocks.GenericRFToolsBlock;
import mcjty.rftools.blocks.logic.generic.LogicFacing;
import mcjty.rftools.blocks.logic.generic.LogicTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class LogicSlabBlock<T extends LogicTileEntity, C extends Container>
extends GenericRFToolsBlock<T, C> {
    @Deprecated
    public static PropertyBool OUTPUTPOWER = PropertyBool.func_177716_a((String)"output");
    public static PropertyInteger META_INTERMEDIATE = PropertyInteger.func_177719_a((String)"intermediate", (int)0, (int)3);
    public static PropertyEnum<LogicFacing> LOGIC_FACING = PropertyEnum.func_177709_a((String)"logic_facing", LogicFacing.class);
    public static final AxisAlignedBB BLOCK_DOWN = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)0.3f, 1.0);
    public static final AxisAlignedBB BLOCK_UP = new AxisAlignedBB(0.0, (double)0.7f, 0.0, 1.0, 1.0, 1.0);
    public static final AxisAlignedBB BLOCK_NORTH = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, (double)0.3f);
    public static final AxisAlignedBB BLOCK_SOUTH = new AxisAlignedBB(0.0, 0.0, (double)0.7f, 1.0, 1.0, 1.0);
    public static final AxisAlignedBB BLOCK_WEST = new AxisAlignedBB(0.0, 0.0, 0.0, (double)0.3f, 1.0, 1.0);
    public static final AxisAlignedBB BLOCK_EAST = new AxisAlignedBB((double)0.7f, 0.0, 0.0, 1.0, 1.0, 1.0);

    public LogicSlabBlock(Material material, String name, Class<? extends T> tileEntityClass, Class<? extends C> containerClass) {
        super(material, tileEntityClass, containerClass, GenericItemBlock.class, name, false);
    }

    public LogicSlabBlock(Material material, String name, Class<? extends T> tileEntityClass, Class<? extends C> containerClass, boolean container) {
        super(material, tileEntityClass, containerClass, GenericItemBlock.class, name, container);
    }

    public BaseBlock.RotationType getRotationType() {
        return BaseBlock.RotationType.NONE;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        LogicFacing facing;
        float dx = Math.abs(0.5f - hitX);
        float dy = Math.abs(0.5f - hitY);
        float dz = Math.abs(0.5f - hitZ);
        side = side.func_176734_d();
        switch (side) {
            case DOWN: {
                if (dx < dz) {
                    facing = (double)hitZ < 0.5 ? LogicFacing.DOWN_TOSOUTH : LogicFacing.DOWN_TONORTH;
                    break;
                }
                facing = (double)hitX < 0.5 ? LogicFacing.DOWN_TOEAST : LogicFacing.DOWN_TOWEST;
                break;
            }
            case UP: {
                if (dx < dz) {
                    facing = (double)hitZ < 0.5 ? LogicFacing.UP_TOSOUTH : LogicFacing.UP_TONORTH;
                    break;
                }
                facing = (double)hitX < 0.5 ? LogicFacing.UP_TOEAST : LogicFacing.UP_TOWEST;
                break;
            }
            case NORTH: {
                if (dx < dy) {
                    facing = (double)hitY < 0.5 ? LogicFacing.NORTH_TOUP : LogicFacing.NORTH_TODOWN;
                    break;
                }
                facing = (double)hitX < 0.5 ? LogicFacing.NORTH_TOEAST : LogicFacing.NORTH_TOWEST;
                break;
            }
            case SOUTH: {
                if (dx < dy) {
                    facing = (double)hitY < 0.5 ? LogicFacing.SOUTH_TOUP : LogicFacing.SOUTH_TODOWN;
                    break;
                }
                facing = (double)hitX < 0.5 ? LogicFacing.SOUTH_TOEAST : LogicFacing.SOUTH_TOWEST;
                break;
            }
            case WEST: {
                if (dy < dz) {
                    facing = (double)hitZ < 0.5 ? LogicFacing.WEST_TOSOUTH : LogicFacing.WEST_TONORTH;
                    break;
                }
                facing = (double)hitY < 0.5 ? LogicFacing.WEST_TOUP : LogicFacing.WEST_TODOWN;
                break;
            }
            case EAST: {
                if (dy < dz) {
                    facing = (double)hitZ < 0.5 ? LogicFacing.EAST_TOSOUTH : LogicFacing.EAST_TONORTH;
                    break;
                }
                facing = (double)hitY < 0.5 ? LogicFacing.EAST_TOUP : LogicFacing.EAST_TODOWN;
                break;
            }
            default: {
                facing = LogicFacing.DOWN_TOWEST;
            }
        }
        return super.func_180642_a(worldIn, pos, side, hitX, hitY, hitZ, meta, placer).func_177226_a((IProperty)META_INTERMEDIATE, (Comparable)Integer.valueOf(facing.getMeta())).func_177226_a((IProperty)OUTPUTPOWER, (Comparable)Boolean.valueOf(false)).func_177226_a(LOGIC_FACING, (Comparable)((Object)facing));
    }

    public boolean hasRedstoneOutput() {
        return true;
    }

    public boolean needsRedstoneCheck() {
        return true;
    }

    public LogicSlabBlock(Material material, String name, Class<? extends T> tileEntityClass, Class<? extends C> containerClass, Class<? extends ItemBlock> itemBlockClass) {
        super(material, tileEntityClass, containerClass, itemBlockClass, name, false);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te;
        IBlockState blockState = world.func_180495_p(pos);
        if (blockState.func_177230_c() instanceof LogicSlabBlock && (te = world.func_175625_s(pos)) instanceof LogicTileEntity) {
            LogicTileEntity logicTileEntity = (LogicTileEntity)te;
            EnumFacing side = logicTileEntity.getFacing(blockState).getSide();
            switch (side) {
                case DOWN: {
                    return BLOCK_DOWN;
                }
                case UP: {
                    return BLOCK_UP;
                }
                case NORTH: {
                    return BLOCK_NORTH;
                }
                case SOUTH: {
                    return BLOCK_SOUTH;
                }
                case WEST: {
                    return BLOCK_WEST;
                }
                case EAST: {
                    return BLOCK_EAST;
                }
            }
        }
        return BLOCK_DOWN;
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        super.initModel();
        StateMap.Builder ignorePower = new StateMap.Builder().func_178442_a(new IProperty[]{OUTPUTPOWER}).func_178442_a(new IProperty[]{META_INTERMEDIATE});
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)ignorePower.func_178441_a());
    }

    protected int getInputStrength(World world, BlockPos pos, EnumFacing side) {
        IBlockState blockState;
        Block b;
        int power = world.func_175651_c(pos.func_177972_a(side), side);
        if (power < 15 && (b = (blockState = world.func_180495_p(pos.func_177972_a(side))).func_177230_c()) == Blocks.field_150488_af) {
            power = Math.max(power, (Integer)blockState.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O));
        }
        return power;
    }

    protected void checkRedstone(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof LogicTileEntity) {
            LogicTileEntity logicTileEntity = (LogicTileEntity)te;
            EnumFacing inputSide = logicTileEntity.getFacing(world.func_180495_p(pos)).getInputSide();
            int power = this.getInputStrength(world, pos, inputSide);
            logicTileEntity.setPowerInput(power);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity te = world.func_175625_s(pos);
        if (state.func_177230_c() instanceof LogicSlabBlock && te instanceof LogicTileEntity) {
            LogicTileEntity logicTileEntity = (LogicTileEntity)te;
            EnumFacing direction = logicTileEntity.getFacing(state).getInputSide();
            switch (direction) {
                case NORTH: 
                case SOUTH: {
                    return side == EnumFacing.NORTH || side == EnumFacing.SOUTH;
                }
                case WEST: 
                case EAST: {
                    return side == EnumFacing.WEST || side == EnumFacing.EAST;
                }
                case DOWN: 
                case UP: {
                    return side == EnumFacing.DOWN || side == EnumFacing.UP;
                }
            }
        }
        return false;
    }

    protected int getRedstoneOutput(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity te = world.func_175625_s(pos);
        if (state.func_177230_c() instanceof LogicSlabBlock && te instanceof LogicTileEntity) {
            LogicTileEntity logicTileEntity = (LogicTileEntity)te;
            if (side == logicTileEntity.getFacing(state).getInputSide()) {
                return logicTileEntity.getPowerOutput();
            }
            return 0;
        }
        return 0;
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        IBlockState state = world.func_180495_p(pos);
        TileEntity te = world.func_175625_s(pos);
        if (state.func_177230_c() instanceof LogicSlabBlock && te instanceof LogicTileEntity) {
            LogicTileEntity logicTileEntity = (LogicTileEntity)te;
            LogicFacing facing = logicTileEntity.getFacing(state);
            int meta = facing.getMeta();
            switch (meta) {
                case 0: {
                    meta = 2;
                    break;
                }
                case 1: {
                    meta = 3;
                    break;
                }
                case 2: {
                    meta = 1;
                    break;
                }
                case 3: {
                    meta = 0;
                }
            }
            LogicFacing newfacing = LogicFacing.getFacingWithMeta(facing, meta);
            logicTileEntity.setFacing(newfacing);
            world.func_180501_a(pos, state.func_177230_c().func_176223_P().func_177226_a((IProperty)META_INTERMEDIATE, (Comparable)Integer.valueOf(meta)).func_177226_a((IProperty)OUTPUTPOWER, (Comparable)Boolean.valueOf(false)), 3);
            return true;
        }
        return false;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te;
        int meta = (Integer)state.func_177229_b((IProperty)META_INTERMEDIATE);
        TileEntity tileEntity = te = world instanceof ChunkCache ? ((ChunkCache)world).func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK) : world.func_175625_s(pos);
        if (te instanceof LogicTileEntity) {
            LogicTileEntity logicTileEntity = (LogicTileEntity)te;
            LogicFacing facing = logicTileEntity.getFacing(state);
            facing = LogicFacing.getFacingWithMeta(facing, meta);
            return state.func_177226_a(LOGIC_FACING, (Comparable)((Object)facing));
        }
        Logging.warn(null, (String)"LogicSlabBlock missing its tile entity!");
        return state.func_177226_a(LOGIC_FACING, (Comparable)((Object)LogicFacing.DOWN_TONORTH));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)META_INTERMEDIATE, (Comparable)Integer.valueOf(meta & 3)).func_177226_a((IProperty)OUTPUTPOWER, (Comparable)Boolean.valueOf((meta & 8) != 0));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)META_INTERMEDIATE) + ((Boolean)state.func_177229_b((IProperty)OUTPUTPOWER) != false ? 8 : 0);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{LOGIC_FACING, META_INTERMEDIATE, OUTPUTPOWER});
    }
}

