/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.logic.generic;

import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.varia.Logging;
import mcjty.rftools.blocks.logic.generic.LogicFacing;
import mcjty.rftools.blocks.logic.generic.LogicSlabBlock;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class LogicTileEntity
extends GenericTileEntity {
    private LogicFacing facing;
    protected int powerOutput = 0;

    public void onLoad() {
        IBlockState state;
        if (this.facing == null && (state = this.func_145831_w().func_180495_p(this.func_174877_v())).func_177230_c() instanceof LogicSlabBlock) {
            this.setFacing((LogicFacing)((Object)state.func_177229_b(LogicSlabBlock.LOGIC_FACING)));
        }
        super.onLoad();
    }

    public LogicFacing getFacing(IBlockState state) {
        if (this.facing == null || !(state.func_177230_c() instanceof LogicSlabBlock)) {
            Logging.warn(null, (String)"LogicTileEntity has unknown/invalid facing!");
            return LogicFacing.DOWN_TOEAST;
        }
        Integer meta = (Integer)state.func_177229_b((IProperty)LogicSlabBlock.META_INTERMEDIATE);
        return LogicFacing.getFacingWithMeta(this.facing, meta);
    }

    public void setFacing(LogicFacing facing) {
        if (facing != this.facing) {
            this.facing = facing;
            this.func_70296_d();
        }
    }

    public int getPowerOutput() {
        return this.powerOutput;
    }

    protected void setRedstoneState(int newout) {
        if (this.powerOutput == newout) {
            return;
        }
        this.powerOutput = newout;
        this.func_70296_d();
        EnumFacing outputSide = this.getFacing(this.func_145831_w().func_180495_p(this.field_174879_c)).getInputSide().func_176734_d();
        this.func_145831_w().func_190524_a(this.field_174879_c.func_177972_a(outputSide), this.func_145838_q(), this.field_174879_c);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.facing = LogicFacing.VALUES[tagCompound.func_74762_e("lf")];
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74768_a("lf", this.facing.ordinal());
        return tagCompound;
    }
}

