/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.logic.sequencer;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import mcjty.lib.base.ModBase;
import mcjty.lib.container.EmptyContainer;
import mcjty.lib.container.GenericGuiContainer;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.VerticalLayout;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.network.Argument;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.logic.sequencer.SequencerMode;
import mcjty.rftools.blocks.logic.sequencer.SequencerTileEntity;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;

public class GuiSequencer
extends GenericGuiContainer<SequencerTileEntity> {
    public static final int SEQUENCER_WIDTH = 160;
    public static final int SEQUENCER_HEIGHT = 208;
    private List<ImageChoiceLabel> bits = new ArrayList<ImageChoiceLabel>();
    private ChoiceLabel mode;
    private TextField speedField;
    private TextField countField;
    private static final ResourceLocation iconGuiElements = new ResourceLocation("rftools", "textures/gui/guielements.png");

    public GuiSequencer(SequencerTileEntity sequencerTileEntity, EmptyContainer container) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, (GenericTileEntity)sequencerTileEntity, (Container)container, RFTools.GUI_MANUAL_MAIN, "sequencer");
        this.field_146999_f = 160;
        this.field_147000_g = 208;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Panel toplevel = ((Panel)new Panel(this.field_146297_k, (Gui)this).setFilledRectThickness(2)).setLayout((Layout)new VerticalLayout());
        this.initGuiGrid(toplevel);
        Button clearButton = ((Button)((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("Clear")).setTooltips(new String[]{"Clear the grid"})).setDesiredHeight(13)).setDesiredWidth(38)).addButtonEvent(parent -> this.fillGrid());
        Button flipButton = ((Button)((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("Flip")).setTooltips(new String[]{"Invert all values in the grid"})).setDesiredHeight(13)).setDesiredWidth(34)).addButtonEvent(parent -> this.flipGrid());
        Label endLabel = new Label(this.field_146297_k, (Gui)this).setText("End on:");
        ImageChoiceLabel choiceLabel = ((ImageChoiceLabel)new ImageChoiceLabel(this.field_146297_k, (Gui)this).addChoiceEvent((parent, newChoice) -> this.setEndState(newChoice)).setDesiredHeight(11)).addChoice("0", "Disabled", iconGuiElements, 160, 0).addChoice("1", "Enabled", iconGuiElements, 176, 0);
        choiceLabel.setCurrentChoice(((SequencerTileEntity)this.tileEntity).getEndState() ? 1 : 0);
        Panel buttonPanel = (Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new HorizontalLayout()).addChild((Widget)clearButton)).addChild((Widget)flipButton)).addChild((Widget)endLabel)).addChild((Widget)choiceLabel);
        toplevel.addChild((Widget)buttonPanel);
        this.initGuiMode();
        Label speedLabel = new Label(this.field_146297_k, (Gui)this).setText("Delay:");
        this.speedField = new TextField(this.field_146297_k, (Gui)this).addTextEvent((parent, newText) -> this.setDelay());
        int delay = ((SequencerTileEntity)this.tileEntity).getDelay();
        if (delay <= 0) {
            delay = 1;
        }
        this.speedField.setText(String.valueOf(delay));
        Panel bottomPanel = (Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new HorizontalLayout()).addChild((Widget)this.mode)).addChild((Widget)speedLabel)).addChild((Widget)this.speedField);
        toplevel.addChild((Widget)bottomPanel);
        Label countLabel = new Label(this.field_146297_k, (Gui)this).setText("Sequence length:");
        this.countField = new TextField(this.field_146297_k, (Gui)this).addTextEvent((parent, newText) -> this.setCount());
        int count = ((SequencerTileEntity)this.tileEntity).getStepCount();
        if (count < 1 || count > 64) {
            count = 64;
        }
        this.countField.setText(String.valueOf(count));
        Panel countPanel = (Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new HorizontalLayout()).addChild((Widget)countLabel)).addChild((Widget)this.countField);
        toplevel.addChild((Widget)countPanel);
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, 160, 208));
        this.window = new Window((GuiScreen)this, (Widget)toplevel);
    }

    private void initGuiGrid(Panel toplevel) {
        for (int row = 0; row < 8; ++row) {
            Panel rowPanel = (Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new HorizontalLayout()).setDesiredHeight(13);
            toplevel.addChild((Widget)rowPanel);
            for (int col = 0; col < 8; ++col) {
                int bit = row * 8 + col;
                ImageChoiceLabel choiceLabel = ((ImageChoiceLabel)new ImageChoiceLabel(this.field_146297_k, (Gui)this).addChoiceEvent((parent, newChoice) -> this.changeBit(bit, newChoice)).setDesiredHeight(12)).addChoice("0", "Disabled", iconGuiElements, 160, 0).addChoice("1", "Enabled", iconGuiElements, 176, 0);
                choiceLabel.setCurrentChoice(((SequencerTileEntity)this.tileEntity).getCycleBit(bit) ? 1 : 0);
                this.bits.add(choiceLabel);
                rowPanel.addChild((Widget)choiceLabel);
            }
        }
    }

    private void initGuiMode() {
        this.mode = (ChoiceLabel)((ChoiceLabel)new ChoiceLabel(this.field_146297_k, (Gui)this).setDesiredHeight(13)).setDesiredWidth(55);
        this.mode.addChoices(new String[]{SequencerMode.MODE_ONCE1.getDescription()});
        this.mode.addChoices(new String[]{SequencerMode.MODE_ONCE2.getDescription()});
        this.mode.addChoices(new String[]{SequencerMode.MODE_LOOP1.getDescription()});
        this.mode.addChoices(new String[]{SequencerMode.MODE_LOOP2.getDescription()});
        this.mode.addChoices(new String[]{SequencerMode.MODE_LOOP3.getDescription()});
        this.mode.addChoices(new String[]{SequencerMode.MODE_LOOP4.getDescription()});
        this.mode.addChoices(new String[]{SequencerMode.MODE_STEP.getDescription()});
        this.mode.setChoiceTooltip(SequencerMode.MODE_ONCE1.getDescription(), new String[]{"When a redstone signal is", "received, loop the cycle once.", "Ignore further pulses"});
        this.mode.setChoiceTooltip(SequencerMode.MODE_ONCE2.getDescription(), new String[]{"When a redstone signal is", "received, loop the cycle once.", "Restart if new pulse arrives"});
        this.mode.setChoiceTooltip(SequencerMode.MODE_LOOP1.getDescription(), new String[]{"Loop the cycle all the time.", "Ignore redstone signals"});
        this.mode.setChoiceTooltip(SequencerMode.MODE_LOOP2.getDescription(), new String[]{"Loop the cycle all the time.", "Restart on redstone pulse"});
        this.mode.setChoiceTooltip(SequencerMode.MODE_LOOP3.getDescription(), new String[]{"Loop the cycle when redstone.", "signal is present. Continue at current step"});
        this.mode.setChoiceTooltip(SequencerMode.MODE_LOOP4.getDescription(), new String[]{"Loop the cycle when redstone.", "signal is present. Restart on no signal"});
        this.mode.setChoiceTooltip(SequencerMode.MODE_STEP.getDescription(), new String[]{"Do one step in the cycle", "for every redstone pulse"});
        this.mode.setChoice(((SequencerTileEntity)this.tileEntity).getMode().getDescription());
        this.mode.addChoiceEvent((parent, newChoice) -> this.changeMode());
    }

    private void setDelay() {
        int delay;
        String d = this.speedField.getText();
        try {
            delay = Integer.parseInt(d);
        }
        catch (NumberFormatException e) {
            delay = 1;
        }
        ((SequencerTileEntity)this.tileEntity).setDelay(delay);
        this.sendServerCommand(RFToolsMessages.INSTANCE, "setDelay", new Argument[]{new Argument("delay", delay)});
    }

    private void setCount() {
        int count;
        String c = this.countField.getText();
        try {
            count = Integer.parseInt(c);
        }
        catch (NumberFormatException e) {
            count = 64;
        }
        ((SequencerTileEntity)this.tileEntity).setStepCount(count);
        this.sendServerCommand(RFToolsMessages.INSTANCE, "setCount", new Argument[]{new Argument("count", count)});
    }

    private void setEndState(String choice) {
        boolean newChoice = "1".equals(choice);
        ((SequencerTileEntity)this.tileEntity).setEndState(newChoice);
        this.sendServerCommand(RFToolsMessages.INSTANCE, "setEndState", new Argument[]{new Argument("endState", newChoice)});
    }

    private void flipGrid() {
        for (ImageChoiceLabel bit : this.bits) {
            bit.setCurrentChoice(1 - bit.getCurrentChoiceIndex());
        }
        ((SequencerTileEntity)this.tileEntity).flipCycleBits();
        this.sendServerCommand(RFToolsMessages.INSTANCE, "flipBits", new Argument[0]);
    }

    private void fillGrid() {
        for (ImageChoiceLabel bit : this.bits) {
            bit.setCurrentChoice(0);
        }
        ((SequencerTileEntity)this.tileEntity).clearCycleBits();
        this.sendServerCommand(RFToolsMessages.INSTANCE, "clearBits", new Argument[0]);
    }

    private void changeBit(int bit, String choice) {
        boolean newChoice = "1".equals(choice);
        ((SequencerTileEntity)this.tileEntity).setCycleBit(bit, newChoice);
        this.sendServerCommand(RFToolsMessages.INSTANCE, "setBit", new Argument[]{new Argument("bit", bit), new Argument("choice", newChoice)});
    }

    private void changeMode() {
        SequencerMode newMode = SequencerMode.getMode(this.mode.getCurrentChoice());
        ((SequencerTileEntity)this.tileEntity).setMode(newMode);
        this.sendServerCommand(RFToolsMessages.INSTANCE, "mode", new Argument[]{new Argument("mode", newMode.getDescription())});
    }

    protected void func_146976_a(float v, int i, int i2) {
        this.drawWindow();
    }
}

