/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.logic.sequencer;

import java.util.Map;
import mcjty.lib.network.Argument;
import mcjty.rftools.blocks.logic.generic.LogicTileEntity;
import mcjty.rftools.blocks.logic.sequencer.SequencerMode;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;

public class SequencerTileEntity
extends LogicTileEntity
implements ITickable {
    public static final String CMD_MODE = "mode";
    public static final String CMD_SETBIT = "setBit";
    public static final String CMD_FLIPBITS = "flipBits";
    public static final String CMD_CLEARBITS = "clearBits";
    public static final String CMD_SETDELAY = "setDelay";
    public static final String CMD_SETCOUNT = "setCount";
    public static final String CMD_SETENDSTATE = "setEndState";
    private SequencerMode mode = SequencerMode.MODE_ONCE1;
    private long cycleBits = 0L;
    private int currentStep = -1;
    private int stepCount = 64;
    private boolean endState = false;
    private boolean prevIn = false;
    private int delay = 1;
    private int timer = 0;

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
        this.timer = delay;
        this.markDirtyClient();
    }

    public int getStepCount() {
        return this.stepCount;
    }

    public void setStepCount(int stepCount) {
        int n = this.stepCount = stepCount >= 1 && stepCount <= 64 ? stepCount : 64;
        if (this.currentStep >= stepCount) {
            this.currentStep = stepCount - 1;
        }
        this.markDirtyClient();
    }

    public boolean getEndState() {
        return this.endState;
    }

    public void setEndState(boolean endState) {
        this.endState = endState;
        this.markDirtyClient();
    }

    public SequencerMode getMode() {
        return this.mode;
    }

    public void setMode(SequencerMode mode) {
        this.mode = mode;
        switch (mode) {
            case MODE_ONCE1: 
            case MODE_ONCE2: 
            case MODE_LOOP3: 
            case MODE_LOOP4: {
                this.currentStep = -1;
                break;
            }
            case MODE_LOOP1: 
            case MODE_LOOP2: 
            case MODE_STEP: {
                this.currentStep = 0;
            }
        }
        this.markDirtyClient();
    }

    public int getCurrentStep() {
        return this.currentStep;
    }

    public boolean getCycleBit(int bit) {
        return (this.cycleBits >> bit & 1L) == 1L;
    }

    public long getCycleBits() {
        return this.cycleBits;
    }

    public void setCycleBit(int bit, boolean flag) {
        this.cycleBits = flag ? (this.cycleBits |= 1L << bit) : (this.cycleBits &= 1L << bit ^ 0xFFFFFFFFFFFFFFFFL);
        this.markDirtyClient();
    }

    public void flipCycleBits() {
        this.cycleBits ^= 0xFFFFFFFFFFFFFFFFL;
        this.markDirtyClient();
    }

    public void clearCycleBits() {
        this.cycleBits = 0L;
        this.markDirtyClient();
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            this.checkStateServer();
        }
    }

    private void checkStateServer() {
        boolean pulse = this.powerLevel > 0 && !this.prevIn;
        boolean bl = this.prevIn = this.powerLevel > 0;
        if (pulse) {
            this.handlePulse();
        }
        this.func_70296_d();
        --this.timer;
        if (this.timer > 0) {
            return;
        }
        this.timer = this.delay;
        this.setRedstoneState(this.checkOutput() ? 15 : 0);
        this.handleCycle(this.powerLevel > 0);
    }

    public boolean checkOutput() {
        return this.currentStep == -1 ? this.endState : this.getCycleBit(this.currentStep);
    }

    private void handleCycle(boolean redstone) {
        switch (this.mode) {
            case MODE_ONCE1: 
            case MODE_ONCE2: {
                if (this.currentStep == -1) break;
                this.nextStepAndStop();
                break;
            }
            case MODE_LOOP1: {
                this.nextStep();
                break;
            }
            case MODE_LOOP2: {
                this.nextStep();
                break;
            }
            case MODE_LOOP3: {
                if (!redstone) break;
                this.nextStep();
                break;
            }
            case MODE_LOOP4: {
                if (redstone) {
                    this.nextStep();
                    break;
                }
                this.currentStep = -1;
                break;
            }
        }
    }

    private void handlePulse() {
        switch (this.mode) {
            case MODE_ONCE1: {
                if (this.currentStep != -1) break;
                this.currentStep = 0;
                break;
            }
            case MODE_ONCE2: {
                this.currentStep = 0;
                break;
            }
            case MODE_LOOP1: {
                break;
            }
            case MODE_LOOP2: {
                this.currentStep = 0;
                break;
            }
            case MODE_LOOP3: 
            case MODE_LOOP4: {
                break;
            }
            case MODE_STEP: {
                this.nextStep();
            }
        }
    }

    private void nextStep() {
        ++this.currentStep;
        if (this.currentStep >= this.stepCount) {
            this.currentStep = 0;
        }
    }

    private void nextStepAndStop() {
        ++this.currentStep;
        if (this.currentStep >= this.stepCount) {
            this.currentStep = -1;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.powerOutput = tagCompound.func_74767_n("rs") ? 15 : 0;
        this.currentStep = tagCompound.func_74762_e("step");
        this.prevIn = tagCompound.func_74767_n("prevIn");
        this.timer = tagCompound.func_74762_e("timer");
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.cycleBits = tagCompound.func_74763_f("bits");
        int m = tagCompound.func_74762_e(CMD_MODE);
        this.mode = SequencerMode.values()[m];
        this.delay = tagCompound.func_74762_e("delay");
        if (this.delay == 0) {
            this.delay = 1;
        }
        this.stepCount = tagCompound.func_74762_e("stepCount");
        if (this.stepCount == 0) {
            this.stepCount = 64;
        }
        this.endState = tagCompound.func_74767_n("endState");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74757_a("rs", this.powerOutput > 0);
        tagCompound.func_74768_a("step", this.currentStep);
        tagCompound.func_74757_a("prevIn", this.prevIn);
        tagCompound.func_74768_a("timer", this.timer);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74772_a("bits", this.cycleBits);
        tagCompound.func_74768_a(CMD_MODE, this.mode.ordinal());
        tagCompound.func_74768_a("delay", this.delay);
        tagCompound.func_74768_a("stepCount", this.stepCount);
        tagCompound.func_74757_a("endState", this.endState);
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_MODE.equals(command)) {
            String m = args.get(CMD_MODE).getString();
            this.setMode(SequencerMode.getMode(m));
            return true;
        }
        if (CMD_SETBIT.equals(command)) {
            this.setCycleBit(args.get("bit").getInteger(), args.get("choice").getBoolean());
            return true;
        }
        if (CMD_FLIPBITS.equals(command)) {
            this.flipCycleBits();
            return true;
        }
        if (CMD_CLEARBITS.equals(command)) {
            this.clearCycleBits();
            return true;
        }
        if (CMD_SETDELAY.equals(command)) {
            this.setDelay(args.get("delay").getInteger());
            return true;
        }
        if (CMD_SETCOUNT.equals(command)) {
            this.setStepCount(args.get("count").getInteger());
            return true;
        }
        if (CMD_SETENDSTATE.equals(command)) {
            this.setEndState(args.get("endState").getBoolean());
            return true;
        }
        return false;
    }
}

