/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.logic.threelogic;

import java.util.Map;
import mcjty.lib.network.Argument;
import mcjty.rftools.blocks.logic.LogicBlockSetup;
import mcjty.rftools.blocks.logic.generic.LogicTileEntity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;

public class ThreeLogicTileEntity
extends LogicTileEntity {
    public static final String CMD_SETSTATE = "setState";
    private int[] logicTable = new int[]{0, 0, 0, 0, 0, 0, 0, 0};

    public int getState(int index) {
        return this.logicTable[index];
    }

    public void checkRedstone() {
        int s = this.logicTable[this.powerLevel];
        if (s == -1) {
            return;
        }
        this.setRedstoneState(s == 1 ? 15 : 0);
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.powerOutput = tagCompound.func_74767_n("rs") ? 15 : 0;
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        for (int i = 0; i < 8; ++i) {
            this.logicTable[i] = tagCompound.func_74762_e("state" + i);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74757_a("rs", this.powerOutput > 0);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        for (int i = 0; i < 8; ++i) {
            tagCompound.func_74768_a("state" + i, this.logicTable[i]);
        }
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_SETSTATE.equals(command)) {
            this.logicTable[args.get((Object)"index").getInteger().intValue()] = args.get("state").getInteger();
            this.markDirtyClient();
            LogicBlockSetup.threeLogicBlock.checkRedstone(this.field_145850_b, this.field_174879_c);
            return true;
        }
        return false;
    }
}

