/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.logic.wireless;

import java.util.List;
import mcjty.lib.varia.Logging;
import mcjty.rftools.blocks.logic.generic.LogicSlabBlock;
import mcjty.rftools.blocks.logic.wireless.RedstoneChannelTileEntity;
import mcjty.rftools.blocks.logic.wireless.RedstoneChannels;
import mcjty.rftools.items.screenmodules.ButtonModuleItem;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class RedstoneChannelBlock<T extends RedstoneChannelTileEntity, C extends Container>
extends LogicSlabBlock<T, C> {
    public RedstoneChannelBlock(Material material, String name, Class<? extends T> tileEntityClass, Class<? extends C> containerClass, Class<? extends ItemBlock> itemBlockClass) {
        super(material, name, tileEntityClass, containerClass, itemBlockClass);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack itemStack, World player, List<String> list, ITooltipFlag whatIsThis) {
        super.func_190948_a(itemStack, player, list, whatIsThis);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            int channel = tagCompound.func_74762_e("channel");
            list.add(TextFormatting.GREEN + "Channel: " + channel);
        }
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof RedstoneChannelTileEntity) {
            probeInfo.text(TextFormatting.GREEN + "Channel: " + ((RedstoneChannelTileEntity)te).getChannel(false));
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="waila")
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        TileEntity te = accessor.getTileEntity();
        if (te instanceof RedstoneChannelTileEntity) {
            currenttip.add(TextFormatting.GREEN + "Channel: " + ((RedstoneChannelTileEntity)te).getChannel(false));
        }
        return currenttip;
    }

    private boolean isRedstoneChannelItem(Item item) {
        return item instanceof ItemBlock && ((ItemBlock)item).func_179223_d() instanceof RedstoneChannelBlock || item instanceof ButtonModuleItem;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity te;
        ItemStack stack = player.func_184586_b(hand);
        if (this.isRedstoneChannelItem(stack.func_77973_b()) && (te = world.func_175625_s(pos)) instanceof RedstoneChannelTileEntity) {
            if (!world.field_72995_K) {
                int channel;
                RedstoneChannelTileEntity rcte = (RedstoneChannelTileEntity)te;
                NBTTagCompound tagCompound = stack.func_77978_p();
                if (tagCompound == null) {
                    tagCompound = new NBTTagCompound();
                    stack.func_77982_d(tagCompound);
                }
                if (!player.func_70093_af()) {
                    channel = rcte.getChannel(true);
                    tagCompound.func_74768_a("channel", channel);
                } else {
                    channel = tagCompound.func_74764_b("channel") ? tagCompound.func_74762_e("channel") : -1;
                    if (channel == -1) {
                        RedstoneChannels redstoneChannels = RedstoneChannels.getChannels(world);
                        channel = redstoneChannels.newChannel();
                        redstoneChannels.save(world);
                        tagCompound.func_74768_a("channel", channel);
                    }
                    rcte.setChannel(channel);
                }
                Logging.message((EntityPlayer)player, (String)(TextFormatting.YELLOW + "Channel set to " + channel + "!"));
            }
            return true;
        }
        return super.func_180639_a(world, pos, state, player, hand, side, hitX, hitY, hitZ);
    }
}

