/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.logic.wireless;

import java.util.List;
import mcjty.lib.container.EmptyContainer;
import mcjty.lib.container.GenericItemBlock;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.logic.wireless.GuiRedstoneReceiver;
import mcjty.rftools.blocks.logic.wireless.RedstoneChannelBlock;
import mcjty.rftools.blocks.logic.wireless.RedstoneReceiverTileEntity;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class RedstoneReceiverBlock
extends RedstoneChannelBlock<RedstoneReceiverTileEntity, EmptyContainer> {
    public RedstoneReceiverBlock() {
        super(Material.field_151573_f, "redstone_receiver_block", RedstoneReceiverTileEntity.class, EmptyContainer.class, GenericItemBlock.class);
    }

    @SideOnly(value=Side.CLIENT)
    public Class<GuiRedstoneReceiver> getGuiClass() {
        return GuiRedstoneReceiver.class;
    }

    @Override
    public boolean needsRedstoneCheck() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack itemStack, World player, List<String> list, ITooltipFlag whatIsThis) {
        super.func_190948_a(itemStack, player, list, whatIsThis);
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(TextFormatting.WHITE + "This logic block sends redstone signals from");
            list.add(TextFormatting.WHITE + "a linked transmitter. Right click on a transmitter");
            list.add(TextFormatting.WHITE + "(or other receiver) to link");
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    @Override
    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof RedstoneReceiverTileEntity) {
            RedstoneReceiverTileEntity rrte = (RedstoneReceiverTileEntity)te;
            probeInfo.text(TextFormatting.GREEN + "Analog mode: " + rrte.getAnalog());
            probeInfo.text(TextFormatting.GREEN + "Output: " + TextFormatting.WHITE + rrte.checkOutput());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="waila")
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        TileEntity te = accessor.getTileEntity();
        if (te instanceof RedstoneReceiverTileEntity) {
            RedstoneReceiverTileEntity rrte = (RedstoneReceiverTileEntity)te;
            currenttip.add(TextFormatting.GREEN + "Analog mode: " + rrte.getAnalog());
        }
        return currenttip;
    }

    public int getGuiID() {
        return RFTools.GUI_REDSTONE_RECEIVER;
    }
}

