/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.powercell;

import com.google.common.collect.Maps;
import java.text.DecimalFormat;
import java.util.List;
import mcjty.lib.api.IModuleSupport;
import mcjty.lib.api.Infusable;
import mcjty.lib.api.smartwrench.SmartWrenchMode;
import mcjty.lib.container.BaseBlock;
import mcjty.lib.crafting.INBTPreservingIngredient;
import mcjty.lib.network.clientinfo.InfoPacketServer;
import mcjty.lib.network.clientinfo.PacketGetInfoFromServer;
import mcjty.lib.varia.ModuleSupport;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.GenericRFToolsBlock;
import mcjty.rftools.blocks.powercell.GuiPowerCell;
import mcjty.rftools.blocks.powercell.PowerCellConfiguration;
import mcjty.rftools.blocks.powercell.PowerCellContainer;
import mcjty.rftools.blocks.powercell.PowerCellInfoPacketClient;
import mcjty.rftools.blocks.powercell.PowerCellInfoPacketServer;
import mcjty.rftools.blocks.powercell.PowerCellNetwork;
import mcjty.rftools.blocks.powercell.PowerCellSetup;
import mcjty.rftools.blocks.powercell.PowerCellTileEntity;
import mcjty.rftools.items.smartwrench.SmartWrenchItem;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class PowerCellBlock
extends GenericRFToolsBlock<PowerCellTileEntity, PowerCellContainer>
implements Infusable,
INBTPreservingIngredient {
    public static final PropertyEnum<PowerCellTileEntity.Mode> NORTH = PropertyEnum.func_177709_a((String)"north", PowerCellTileEntity.Mode.class);
    public static final PropertyEnum<PowerCellTileEntity.Mode> SOUTH = PropertyEnum.func_177709_a((String)"south", PowerCellTileEntity.Mode.class);
    public static final PropertyEnum<PowerCellTileEntity.Mode> WEST = PropertyEnum.func_177709_a((String)"west", PowerCellTileEntity.Mode.class);
    public static final PropertyEnum<PowerCellTileEntity.Mode> EAST = PropertyEnum.func_177709_a((String)"east", PowerCellTileEntity.Mode.class);
    public static final PropertyEnum<PowerCellTileEntity.Mode> UP = PropertyEnum.func_177709_a((String)"up", PowerCellTileEntity.Mode.class);
    public static final PropertyEnum<PowerCellTileEntity.Mode> DOWN = PropertyEnum.func_177709_a((String)"down", PowerCellTileEntity.Mode.class);
    private static long lastTime = 0L;

    public PowerCellBlock(String name, Class<? extends PowerCellTileEntity> clazz) {
        super(Material.field_151573_f, clazz, PowerCellContainer.class, name, true);
    }

    @SideOnly(value=Side.CLIENT)
    public Class<GuiPowerCell> getGuiClass() {
        return GuiPowerCell.class;
    }

    public BaseBlock.RotationType getRotationType() {
        return BaseBlock.RotationType.NONE;
    }

    public int getGuiID() {
        return RFTools.GUI_POWERCELL;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack itemStack, World player, List<String> list, ITooltipFlag whatIsThis) {
        super.func_190948_a(itemStack, player, list, whatIsThis);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            list.add(TextFormatting.YELLOW + "Energy: " + tagCompound.func_74762_e("energy"));
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            int totpower = PowerCellConfiguration.rfPerNormalCell * this.getPowerFactory() / PowerCellConfiguration.simpleFactor;
            list.add(TextFormatting.WHITE + "This block can store power (" + totpower + " RF)");
            list.add(TextFormatting.WHITE + "Optionally in a big multi dimensional structure");
            list.add(TextFormatting.YELLOW + "Infusing bonus: reduced long distance power");
            list.add(TextFormatting.YELLOW + "extraction cost and increased RF/tick output");
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    protected IModuleSupport getModuleSupport() {
        return new ModuleSupport(0){

            public boolean isModule(ItemStack itemStack) {
                return itemStack.func_77973_b() == PowerCellSetup.powerCellCardItem;
            }
        };
    }

    private boolean isAdvanced() {
        return PowerCellBlock.isAdvanced((Block)this);
    }

    private boolean isSimple() {
        return PowerCellBlock.isSimple((Block)this);
    }

    public static boolean isAdvanced(Block block) {
        return block == PowerCellSetup.advancedPowerCellBlock || block == PowerCellSetup.creativePowerCellBlock;
    }

    public static boolean isSimple(Block block) {
        return block == PowerCellSetup.simplePowerCellBlock;
    }

    public static boolean isCreative(Block block) {
        return block == PowerCellSetup.creativePowerCellBlock;
    }

    private int getPowerFactory() {
        if (this.isSimple()) {
            return 1;
        }
        return this.isAdvanced() ? PowerCellConfiguration.advancedFactor * PowerCellConfiguration.simpleFactor : PowerCellConfiguration.simpleFactor;
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof PowerCellTileEntity) {
            PowerCellTileEntity powerCellTileEntity = (PowerCellTileEntity)te;
            int id = powerCellTileEntity.getNetworkId();
            if (mode == ProbeMode.EXTENDED) {
                if (id != -1) {
                    probeInfo.text(TextFormatting.GREEN + "ID: " + new DecimalFormat("#.##").format(id));
                } else {
                    probeInfo.text(TextFormatting.GREEN + "Local storage!");
                }
            }
            float costFactor = powerCellTileEntity.getCostFactor();
            int rfPerTick = powerCellTileEntity.getRfPerTickPerSide();
            probeInfo.text(TextFormatting.GREEN + "Input/Output: " + rfPerTick + " RF/t");
            PowerCellTileEntity.Mode powermode = powerCellTileEntity.getMode(data.getSideHit());
            if (powermode == PowerCellTileEntity.Mode.MODE_INPUT) {
                probeInfo.text(TextFormatting.YELLOW + "Side: input");
            } else if (powermode == PowerCellTileEntity.Mode.MODE_OUTPUT) {
                int cost = (int)((costFactor - 1.0f) * 1000.0f);
                probeInfo.text(TextFormatting.YELLOW + "Side: output (cost " + cost / 10 + "." + cost % 10 + "%)");
            }
            if (mode == ProbeMode.EXTENDED) {
                int rfPerTickIn = powerCellTileEntity.getLastRfPerTickIn();
                int rfPerTickOut = powerCellTileEntity.getLastRfPerTickOut();
                probeInfo.text(TextFormatting.GREEN + "In:  " + rfPerTickIn + "RF/t");
                probeInfo.text(TextFormatting.GREEN + "Out: " + rfPerTickOut + "RF/t");
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="waila")
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        TileEntity tileEntity = accessor.getTileEntity();
        if (tileEntity instanceof PowerCellTileEntity) {
            PowerCellTileEntity powerCellTileEntity = (PowerCellTileEntity)tileEntity;
            int id = powerCellTileEntity.getNetworkId();
            if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                if (id != -1) {
                    currenttip.add(TextFormatting.GREEN + "ID: " + new DecimalFormat("#.##").format(id));
                } else {
                    currenttip.add(TextFormatting.GREEN + "Local storage!");
                }
            }
            if (System.currentTimeMillis() - lastTime > 250L) {
                lastTime = System.currentTimeMillis();
                RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketGetInfoFromServer("rftools", (InfoPacketServer)new PowerCellInfoPacketServer(powerCellTileEntity)));
            }
            long total = ((long)(PowerCellInfoPacketClient.tooltipBlocks - PowerCellInfoPacketClient.tooltipAdvancedBlocks) - (long)PowerCellInfoPacketClient.tooltipSimpleBlocks) * (long)PowerCellConfiguration.rfPerNormalCell;
            total += (long)PowerCellInfoPacketClient.tooltipAdvancedBlocks * (long)PowerCellConfiguration.rfPerNormalCell * (long)PowerCellConfiguration.advancedFactor;
            if ((total += (long)PowerCellInfoPacketClient.tooltipSimpleBlocks * (long)PowerCellConfiguration.rfPerNormalCell / (long)PowerCellConfiguration.simpleFactor) > Integer.MAX_VALUE) {
                total = Integer.MAX_VALUE;
            }
            currenttip.add(TextFormatting.GREEN + "Energy: " + PowerCellInfoPacketClient.tooltipEnergy + "/" + total + " RF (" + PowerCellInfoPacketClient.tooltipRfPerTick + " RF/t)");
            PowerCellTileEntity.Mode mode = powerCellTileEntity.getMode(accessor.getSide());
            if (mode == PowerCellTileEntity.Mode.MODE_INPUT) {
                currenttip.add(TextFormatting.YELLOW + "Side: input");
            } else if (mode == PowerCellTileEntity.Mode.MODE_OUTPUT) {
                int cost = (int)((PowerCellInfoPacketClient.tooltipCostFactor - 1.0f) * 1000.0f);
                currenttip.add(TextFormatting.YELLOW + "Side: output (cost " + cost / 10 + "." + cost % 10 + "%)");
            }
        }
        return currenttip;
    }

    protected boolean wrenchSneakSelect(World world, BlockPos pos, EntityPlayer player) {
        TileEntity te;
        SmartWrenchMode currentMode;
        if (!world.field_72995_K && (currentMode = SmartWrenchItem.getCurrentMode(player.func_184586_b(EnumHand.MAIN_HAND))) == SmartWrenchMode.MODE_SELECT && (te = world.func_175625_s(pos)) instanceof PowerCellTileEntity) {
            PowerCellTileEntity powerCellTileEntity = (PowerCellTileEntity)te;
            PowerCellTileEntity.dumpNetwork(player, powerCellTileEntity);
        }
        return true;
    }

    protected boolean wrenchUse(World world, BlockPos pos, EnumFacing side, EntityPlayer player) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof PowerCellTileEntity) {
            PowerCellTileEntity powerCellTileEntity = (PowerCellTileEntity)te;
            powerCellTileEntity.toggleMode(side);
        }
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        PowerCellTileEntity powerCellTileEntity;
        super.func_180633_a(world, pos, state, placer, stack);
        if (stack.func_77942_o() && !world.field_72995_K) {
            int networkId;
            PowerCellTileEntity powerCellTileEntity2 = (PowerCellTileEntity)world.func_175625_s(pos);
            if (powerCellTileEntity2 != null && (networkId = powerCellTileEntity2.getNetworkId()) != -1) {
                int energy = stack.func_77978_p().func_74762_e("energy");
                PowerCellNetwork powerCellNetwork = PowerCellNetwork.getChannels(world);
                PowerCellNetwork.Network network = powerCellNetwork.getChannel(networkId);
                network.receiveEnergy(energy);
                Block block = world.func_180495_p(pos).func_177230_c();
                network.add(world, powerCellTileEntity2.getGlobalPos(), PowerCellBlock.isAdvanced(block), PowerCellBlock.isSimple(block));
                powerCellNetwork.save(world);
            }
        } else if (!stack.func_77942_o() && !world.field_72995_K && (powerCellTileEntity = (PowerCellTileEntity)world.func_175625_s(pos)) != null && PowerCellBlock.isCreative((Block)this)) {
            powerCellTileEntity.execute((EntityPlayerMP)placer, PowerCellTileEntity.CMD_SETOUTPUT, Maps.newHashMap());
        }
        if (placer instanceof EntityPlayer) {
            // empty if block
        }
    }

    public List<ItemStack> getDrops(IBlockAccess blockAccess, BlockPos pos, IBlockState state, int fortune) {
        PowerCellNetwork.Network network;
        TileEntity te;
        World world = (World)blockAccess;
        List drops = super.getDrops((IBlockAccess)world, pos, state, fortune);
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof PowerCellTileEntity && (network = ((PowerCellTileEntity)te).getNetwork()) != null) {
            int energy = network.getEnergySingleBlock(this.isAdvanced(), this.isSimple());
            if (!drops.isEmpty()) {
                NBTTagCompound tagCompound = ((ItemStack)drops.get(0)).func_77978_p();
                if (tagCompound == null) {
                    tagCompound = new NBTTagCompound();
                    ((ItemStack)drops.get(0)).func_77982_d(tagCompound);
                }
                tagCompound.func_74768_a("energy", energy);
            }
        }
        return drops;
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        PowerCellTileEntity cellTileEntity;
        PowerCellNetwork.Network network;
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof PowerCellTileEntity && (network = (cellTileEntity = (PowerCellTileEntity)te).getNetwork()) != null) {
            int a = network.extractEnergySingleBlock(this.isAdvanced(), this.isSimple());
            Block block = world.func_180495_p(pos).func_177230_c();
            network.remove(world, cellTileEntity.getGlobalPos(), PowerCellBlock.isAdvanced(block), PowerCellBlock.isSimple(block));
            PowerCellNetwork.getChannels(world).save(world);
            cellTileEntity.setNetworkId(-1);
        }
        super.onBlockExploded(world, pos, explosion);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        PowerCellTileEntity cellTileEntity;
        PowerCellNetwork.Network network;
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof PowerCellTileEntity && (network = (cellTileEntity = (PowerCellTileEntity)te).getNetwork()) != null) {
            int a = network.extractEnergySingleBlock(this.isAdvanced(), this.isSimple());
            Block block = world.func_180495_p(pos).func_177230_c();
            network.remove(world, cellTileEntity.getGlobalPos(), PowerCellBlock.isAdvanced(block), PowerCellBlock.isSimple(block));
            PowerCellNetwork.getChannels(world).save(world);
        }
        super.func_180663_b(world, pos, state);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity;
        TileEntity tileEntity2 = tileEntity = world instanceof ChunkCache ? ((ChunkCache)world).func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK) : world.func_175625_s(pos);
        if (tileEntity instanceof PowerCellTileEntity) {
            PowerCellTileEntity te = (PowerCellTileEntity)tileEntity;
            PowerCellTileEntity.Mode north = te.getMode(EnumFacing.NORTH);
            PowerCellTileEntity.Mode south = te.getMode(EnumFacing.SOUTH);
            PowerCellTileEntity.Mode west = te.getMode(EnumFacing.WEST);
            PowerCellTileEntity.Mode east = te.getMode(EnumFacing.EAST);
            PowerCellTileEntity.Mode up = te.getMode(EnumFacing.UP);
            PowerCellTileEntity.Mode down = te.getMode(EnumFacing.DOWN);
            return state.func_177226_a(NORTH, (Comparable)((Object)north)).func_177226_a(SOUTH, (Comparable)((Object)south)).func_177226_a(WEST, (Comparable)((Object)west)).func_177226_a(EAST, (Comparable)((Object)east)).func_177226_a(UP, (Comparable)((Object)up)).func_177226_a(DOWN, (Comparable)((Object)down));
        }
        return state.func_177226_a(NORTH, (Comparable)((Object)PowerCellTileEntity.Mode.MODE_NONE)).func_177226_a(SOUTH, (Comparable)((Object)PowerCellTileEntity.Mode.MODE_NONE)).func_177226_a(WEST, (Comparable)((Object)PowerCellTileEntity.Mode.MODE_NONE)).func_177226_a(EAST, (Comparable)((Object)PowerCellTileEntity.Mode.MODE_NONE)).func_177226_a(UP, (Comparable)((Object)PowerCellTileEntity.Mode.MODE_NONE)).func_177226_a(DOWN, (Comparable)((Object)PowerCellTileEntity.Mode.MODE_NONE));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NORTH, SOUTH, WEST, EAST, UP, DOWN});
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }
}

