/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.relay;

import java.util.List;
import mcjty.lib.container.EmptyContainer;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.GenericRFToolsBlock;
import mcjty.rftools.blocks.relay.GuiRelay;
import mcjty.rftools.blocks.relay.RelayTileEntity;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class RelayBlock
extends GenericRFToolsBlock<RelayTileEntity, EmptyContainer> {
    public static final PropertyBool ENABLED = PropertyBool.func_177716_a((String)"enabled");

    public RelayBlock() {
        super(Material.field_151573_f, RelayTileEntity.class, EmptyContainer.class, "relay", false);
    }

    public boolean needsRedstoneCheck() {
        return true;
    }

    public Class<GuiRelay> getGuiClass() {
        return GuiRelay.class;
    }

    public int getGuiID() {
        return RFTools.GUI_RELAY;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack itemStack, World player, List<String> list, ITooltipFlag whatIsThis) {
        super.func_190948_a(itemStack, player, list, whatIsThis);
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(TextFormatting.WHITE + "This device can (based on a redstone signal) limit");
            list.add(TextFormatting.WHITE + "the amount of RF that can go through this. Using this");
            list.add(TextFormatting.WHITE + "you can throttle down (or even disable) a number of");
            list.add(TextFormatting.WHITE + "machines in case power is low.");
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof RelayTileEntity && mode == ProbeMode.EXTENDED) {
            int rfPerTickIn = ((RelayTileEntity)te).getLastRfPerTickIn();
            int rfPerTickOut = ((RelayTileEntity)te).getLastRfPerTickOut();
            probeInfo.text(TextFormatting.GREEN + "In:  " + rfPerTickIn + "RF/t");
            probeInfo.text(TextFormatting.GREEN + "Out: " + rfPerTickOut + "RF/t");
        }
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te;
        boolean enabled = false;
        TileEntity tileEntity = te = world instanceof ChunkCache ? ((ChunkCache)world).func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK) : world.func_175625_s(pos);
        if (te instanceof RelayTileEntity) {
            enabled = ((RelayTileEntity)te).isPowered();
        }
        return state.func_177226_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(enabled));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, ENABLED});
    }
}

