/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.relay;

import java.util.Map;
import mcjty.lib.api.MachineInformation;
import mcjty.lib.compat.RedstoneFluxCompatibility;
import mcjty.lib.entity.GenericEnergyHandlerTileEntity;
import mcjty.lib.network.Argument;
import mcjty.lib.varia.EnergyTools;
import mcjty.lib.varia.OrientationTools;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.relay.RelayEnergyStorage;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;

public class RelayTileEntity
extends GenericEnergyHandlerTileEntity
implements ITickable,
MachineInformation {
    public static final int MAXENERGY = 50000;
    public static final int RECEIVEPERTICK = 50000;
    public static final String CMD_SETTINGS = "settings";
    private static final String[] TAGS = new String[]{"rfpertick_out", "rfpertick_in"};
    private static final String[] TAG_DESCRIPTIONS = new String[]{"The current RF/t output given by this block (last 2 seconds)", "The current RF/t input received by this block (last 2 seconds)"};
    private boolean[] inputModeOn = new boolean[]{false, false, false, false, false, false};
    private boolean[] inputModeOff = new boolean[]{false, false, false, false, false, false};
    private int[] rfOn = new int[]{1000, 1000, 1000, 1000, 1000, 1000};
    private int[] rfOff = new int[]{0, 0, 0, 0, 0, 0};
    public static final String DUNSWE = "DUBFLR";
    private int lastRfPerTickIn = 0;
    private int lastRfPerTickOut = 0;
    private int powerIn = 0;
    private int powerOut = 0;
    private long lastTime = 0L;
    private RelayEnergyStorage[] facingStorage = new RelayEnergyStorage[6];
    private RelayEnergyStorage nullStorage;

    public RelayTileEntity() {
        super(50000, 50000);
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            this.checkStateServer();
        }
    }

    public int getLastRfPerTickIn() {
        return this.lastRfPerTickIn;
    }

    public int getLastRfPerTickOut() {
        return this.lastRfPerTickOut;
    }

    public int getTagCount() {
        return TAGS.length;
    }

    public String getTagName(int index) {
        return TAGS[index];
    }

    public String getTagDescription(int index) {
        return TAG_DESCRIPTIONS[index];
    }

    public String getData(int index, long millis) {
        switch (index) {
            case 0: {
                return this.lastRfPerTickOut + "RF/t";
            }
            case 1: {
                return this.lastRfPerTickIn + "RF/t";
            }
        }
        return null;
    }

    public boolean isPowered() {
        return this.powerLevel > 0;
    }

    private void checkStateServer() {
        long time = System.currentTimeMillis();
        if (this.lastTime == 0L) {
            this.lastTime = time;
        } else if (time > this.lastTime + 2000L) {
            this.lastRfPerTickIn = (int)((long)(50 * this.powerIn) / (time - this.lastTime));
            this.lastRfPerTickOut = (int)((long)(50 * this.powerOut) / (time - this.lastTime));
            this.lastTime = time;
            this.powerIn = 0;
            this.powerOut = 0;
        }
        boolean redstoneSignal = this.powerLevel > 0;
        int[] rf = redstoneSignal ? this.rfOn : this.rfOff;
        boolean[] inputMode = redstoneSignal ? this.inputModeOn : this.inputModeOff;
        int energyStored = this.getEnergyStored();
        if (energyStored <= 0) {
            return;
        }
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            int side = OrientationTools.reorient((EnumFacing)facing, (IBlockState)state).ordinal();
            if (rf[side] <= 0 || inputMode[side]) continue;
            TileEntity te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(facing));
            EnumFacing opposite = facing.func_176734_d();
            if (!EnergyTools.isEnergyTE((TileEntity)te) && (te == null || !te.hasCapability(CapabilityEnergy.ENERGY, opposite))) continue;
            int rfToGive = rf[side] <= energyStored ? rf[side] : energyStored;
            int received = RFTools.redstoneflux && RedstoneFluxCompatibility.isEnergyConnection((TileEntity)te) ? (RedstoneFluxCompatibility.canConnectEnergy((TileEntity)te, (EnumFacing)opposite) ? EnergyTools.receiveEnergy((TileEntity)te, (EnumFacing)opposite, (int)rfToGive) : 0) : EnergyTools.receiveEnergy((TileEntity)te, (EnumFacing)opposite, (int)rfToGive);
            this.powerOut += received;
            if ((energyStored -= this.storage.extractEnergy(received, false)) > 0) continue;
            return;
        }
    }

    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        return 0;
    }

    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        IBlockState state;
        int side;
        boolean redstoneSignal = this.powerLevel > 0;
        boolean[] inputMode = redstoneSignal ? this.inputModeOn : this.inputModeOff;
        if (inputMode[side = OrientationTools.reorient((EnumFacing)from, (IBlockState)(state = this.func_145831_w().func_180495_p(this.func_174877_v()))).ordinal()]) {
            int[] rf = redstoneSignal ? this.rfOn : this.rfOff;
            int actual = super.receiveEnergy(Math.min(maxReceive, rf[side]), simulate);
            if (!simulate) {
                this.powerIn += actual;
            }
            return actual;
        }
        return 0;
    }

    public boolean isInputModeOn(int side) {
        return this.inputModeOn[side];
    }

    public boolean isInputModeOff(int side) {
        return this.inputModeOff[side];
    }

    public int getRfOn(int side) {
        return this.rfOn[side];
    }

    public int getRfOff(int side) {
        return this.rfOff[side];
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        if (tagCompound.func_74764_b("rfOn")) {
            int on = tagCompound.func_74762_e("rfOn");
            int off = tagCompound.func_74762_e("rfOff");
            for (int i = 0; i < 6; ++i) {
                this.rfOn[i] = on;
                this.rfOff[i] = off;
                this.inputModeOn[i] = false;
                this.inputModeOff[i] = false;
            }
        } else {
            int i;
            int[] on = tagCompound.func_74759_k("on");
            int[] off = tagCompound.func_74759_k("off");
            System.arraycopy(on, 0, this.rfOn, 0, Math.min(6, on.length));
            System.arraycopy(off, 0, this.rfOff, 0, Math.min(6, off.length));
            byte[] inOn = tagCompound.func_74770_j("inputOn");
            byte[] inOff = tagCompound.func_74770_j("inputOff");
            for (i = 0; i < Math.min(6, inOn.length); ++i) {
                this.inputModeOn[i] = inOn[i] > 0;
            }
            for (i = 0; i < Math.min(6, inOff.length); ++i) {
                this.inputModeOff[i] = inOff[i] > 0;
            }
        }
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74783_a("on", this.rfOn);
        tagCompound.func_74783_a("off", this.rfOff);
        byte[] inOn = new byte[6];
        byte[] inOff = new byte[6];
        for (int i = 0; i < 6; ++i) {
            inOn[i] = (byte)(this.inputModeOn[i] ? 1 : 0);
            inOff[i] = (byte)(this.inputModeOff[i] ? 1 : 0);
        }
        tagCompound.func_74773_a("inputOn", inOn);
        tagCompound.func_74773_a("inputOff", inOff);
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_SETTINGS.equals(command)) {
            for (int i = 0; i < 6; ++i) {
                char prefix = DUNSWE.charAt(i);
                this.inputModeOn[i] = args.get(prefix + "InOn").getBoolean();
                this.inputModeOff[i] = args.get(prefix + "InOff").getBoolean();
                this.rfOn[i] = args.get(prefix + "On").getInteger();
                this.rfOff[i] = args.get(prefix + "Off").getInteger();
            }
            this.markDirtyClient();
            return true;
        }
        return false;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            if (facing == null) {
                if (this.nullStorage == null) {
                    this.nullStorage = new RelayEnergyStorage(this, null);
                }
                return (T)this.nullStorage;
            }
            if (this.facingStorage[facing.ordinal()] == null) {
                this.facingStorage[facing.ordinal()] = new RelayEnergyStorage(this, facing);
            }
            return (T)this.facingStorage[facing.ordinal()];
        }
        return (T)super.getCapability(capability, facing);
    }
}

