/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.shaper;

import java.awt.Rectangle;
import java.io.IOException;
import mcjty.lib.base.ModBase;
import mcjty.lib.container.GenericGuiContainer;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.WindowManager;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.gui.widgets.Widget;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.shaper.ComposerContainer;
import mcjty.rftools.blocks.shaper.ComposerTileEntity;
import mcjty.rftools.blocks.shaper.ShapeGuiTools;
import mcjty.rftools.items.builder.GuiShapeCard;
import mcjty.rftools.items.builder.ShapeCardItem;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.rftools.shapes.IShapeParentGui;
import mcjty.rftools.shapes.PacketSendComposerData;
import mcjty.rftools.shapes.ShapeID;
import mcjty.rftools.shapes.ShapeModifier;
import mcjty.rftools.shapes.ShapeOperation;
import mcjty.rftools.shapes.ShapeRenderer;
import mcjty.rftools.shapes.ShapeRotation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Mouse;

public class GuiComposer
extends GenericGuiContainer<ComposerTileEntity>
implements IShapeParentGui {
    public static final int SIDEWIDTH = 80;
    public static final int SHAPER_WIDTH = 256;
    public static final int SHAPER_HEIGHT = 238;
    private static final ResourceLocation sideBackground = new ResourceLocation("rftools", "textures/gui/sidegui.png");
    private static final ResourceLocation iconLocation = new ResourceLocation("rftools", "textures/gui/composer.png");
    private static final ResourceLocation guiElements = new ResourceLocation("rftools", "textures/gui/guielements.png");
    private ChoiceLabel[] operationLabels = new ChoiceLabel[9];
    private ChoiceLabel[] rotationLabels = new ChoiceLabel[9];
    private ToggleButton[] flipButtons = new ToggleButton[9];
    private Button[] configButton = new Button[9];
    private Button outConfigButton;
    private ToggleButton showAxis;
    private ToggleButton showOuter;
    private ToggleButton showScan;
    private ShapeRenderer shapeRenderer = null;
    private Window sideWindow;

    public GuiComposer(ComposerTileEntity composerTileEntity, ComposerContainer container) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, (GenericTileEntity)composerTileEntity, (Container)container, RFTools.GUI_MANUAL_SHAPE, "composer");
        this.field_146999_f = 256;
        this.field_147000_g = 238;
    }

    private ShapeRenderer getShapeRenderer() {
        if (this.shapeRenderer == null) {
            this.shapeRenderer = new ShapeRenderer(this.getShapeID());
        }
        return this.shapeRenderer;
    }

    private ShapeID getShapeID() {
        Slot slot = this.field_147002_h.func_75139_a(0);
        ItemStack stack = slot.func_75216_d() ? slot.func_75211_c() : ItemStack.field_190927_a;
        return new ShapeID(((ComposerTileEntity)this.tileEntity).func_145831_w().field_73011_w.getDimension(), ((ComposerTileEntity)this.tileEntity).func_174877_v(), ShapeCardItem.getScanId(stack), false, ShapeCardItem.isSolid(stack));
    }

    public void func_73866_w_() {
        int i;
        super.func_73866_w_();
        Panel toplevel = ((Panel)new Panel(this.field_146297_k, (Gui)this).setBackground(iconLocation)).setLayout((Layout)new PositionalLayout());
        this.getShapeRenderer().initView(this.getPreviewLeft(), this.field_147009_r + 100);
        ShapeModifier[] modifiers = ((ComposerTileEntity)this.tileEntity).getModifiers();
        this.operationLabels[0] = null;
        for (i = 0; i < 9; ++i) {
            this.operationLabels[i] = new ChoiceLabel(this.field_146297_k, (Gui)this).addChoices(new String[]{ShapeOperation.UNION.getCode(), ShapeOperation.SUBTRACT.getCode(), ShapeOperation.INTERSECT.getCode()});
            for (ShapeOperation operation : ShapeOperation.values()) {
                this.operationLabels[i].setChoiceTooltip(operation.getCode(), new String[]{operation.getDescription()});
            }
            this.operationLabels[i].setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(55, 7 + i * 18, 26, 16));
            this.operationLabels[i].setChoice(modifiers[i].getOperation().getCode());
            this.operationLabels[i].addChoiceEvent((parent, newChoice) -> this.update());
            toplevel.addChild((Widget)this.operationLabels[i]);
        }
        this.operationLabels[0].setEnabled(false);
        for (i = 0; i < 9; ++i) {
            this.configButton[i] = (Button)new Button(this.field_146297_k, (Gui)this).setText("?");
            this.configButton[i].setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(3, 7 + i * 18 + 2, 13, 12));
            int finalI = i;
            this.configButton[i].addButtonEvent(parent -> this.openCardGui(finalI));
            this.configButton[i].setTooltips(new String[]{"Click to open the card gui"});
            toplevel.addChild((Widget)this.configButton[i]);
        }
        this.outConfigButton = (Button)new Button(this.field_146297_k, (Gui)this).setText("?");
        this.outConfigButton.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(3, 202, 13, 12));
        this.outConfigButton.addButtonEvent(parent -> this.openCardGui(-1));
        this.outConfigButton.setTooltips(new String[]{"Click to open the card gui"});
        toplevel.addChild((Widget)this.outConfigButton);
        this.showAxis = ShapeGuiTools.createAxisButton((Gui)this, toplevel, 5, 176);
        this.showOuter = ShapeGuiTools.createBoxButton((Gui)this, toplevel, 31, 176);
        this.showScan = ShapeGuiTools.createScanButton((Gui)this, toplevel, 57, 176);
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        Panel sidePanel = (Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new PositionalLayout()).setBackground(sideBackground);
        String[] tt = new String[]{"Drag left mouse button to rotate", "Shift drag left mouse to pan", "Use mouse wheel to zoom in/out", "Use middle click to reset rotation"};
        sidePanel.addChild((Widget)((Label)new Label(this.field_146297_k, (Gui)this).setText("E").setColor(-65536).setTooltips(tt)).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(5, 175, 15, 15)));
        sidePanel.addChild((Widget)((Label)new Label(this.field_146297_k, (Gui)this).setText("W").setColor(-65536).setTooltips(tt)).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(40, 175, 15, 15)));
        sidePanel.addChild((Widget)((Label)new Label(this.field_146297_k, (Gui)this).setText("U").setColor(-16729344).setTooltips(tt)).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(5, 190, 15, 15)));
        sidePanel.addChild((Widget)((Label)new Label(this.field_146297_k, (Gui)this).setText("D").setColor(-16729344).setTooltips(tt)).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(40, 190, 15, 15)));
        sidePanel.addChild((Widget)((Label)new Label(this.field_146297_k, (Gui)this).setText("N").setColor(-16776961).setTooltips(tt)).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(5, 205, 15, 15)));
        sidePanel.addChild((Widget)((Label)new Label(this.field_146297_k, (Gui)this).setText("S").setColor(-16776961).setTooltips(tt)).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(40, 205, 15, 15)));
        for (int i2 = 0; i2 < 9; ++i2) {
            ToggleButton flip = (ToggleButton)((ToggleButton)new ToggleButton(this.field_146297_k, (Gui)this).setText("Flip")).setCheckMarker(true).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(6, 7 + i2 * 18, 35, 16));
            flip.setPressed(modifiers[i2].isFlipY());
            flip.addButtonEvent(parent -> this.update());
            sidePanel.addChild((Widget)flip);
            this.flipButtons[i2] = flip;
            ChoiceLabel rot = (ChoiceLabel)new ChoiceLabel(this.field_146297_k, (Gui)this).addChoices(new String[]{"None", "X", "Y", "Z"}).setChoice("None").setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(45, 7 + i2 * 18, 35, 16));
            rot.setChoice(modifiers[i2].getRotation().getCode());
            rot.addChoiceEvent((parent, newChoice) -> this.update());
            sidePanel.addChild((Widget)rot);
            this.rotationLabels[i2] = rot;
        }
        sidePanel.setBounds(new Rectangle(this.field_147003_i - 80, this.field_147009_r, 80, this.field_147000_g));
        this.sideWindow = new Window((GuiScreen)this, (Widget)sidePanel);
        this.window = new Window((GuiScreen)this, (Widget)toplevel);
    }

    protected void registerWindows(WindowManager mgr) {
        super.registerWindows(mgr);
        mgr.addWindow(this.sideWindow);
    }

    @Override
    public int getPreviewLeft() {
        return this.getGuiLeft();
    }

    @Override
    public int getPreviewTop() {
        return this.getGuiTop();
    }

    private void openCardGui(int i) {
        int slot = i == -1 ? 0 : 1 + i;
        ItemStack cardStack = this.field_147002_h.func_75139_a(slot).func_75211_c();
        if (!cardStack.func_190926_b()) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            GuiShapeCard.fromTEPos = ((ComposerTileEntity)this.tileEntity).func_174877_v();
            GuiShapeCard.fromTEStackSlot = slot;
            GuiShapeCard.returnGui = this;
            player.openGui((Object)RFTools.instance, RFTools.GUI_SHAPECARD_COMPOSER, player.func_130014_f_(), (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        }
    }

    private void update() {
        ShapeModifier[] modifiers = new ShapeModifier[9];
        for (int i = 0; i < 9; ++i) {
            ShapeOperation op = ShapeOperation.getByName(this.operationLabels[i].getCurrentChoice());
            ShapeRotation rot = ShapeRotation.getByName(this.rotationLabels[i].getCurrentChoice());
            modifiers[i] = new ShapeModifier(op, this.flipButtons[i].isPressed(), rot);
        }
        this.network.sendToServer((IMessage)new PacketSendComposerData(((ComposerTileEntity)this.tileEntity).func_174877_v(), modifiers));
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        this.getShapeRenderer().handleShapeDragging(x -= this.field_147003_i, y -= this.field_147009_r);
    }

    protected void func_146976_a(float v, int x, int y) {
        ItemStack stack;
        this.getShapeRenderer().handleMouseWheel();
        this.drawWindow();
        Slot slot = this.field_147002_h.func_75139_a(0);
        if (slot.func_75216_d() && !(stack = slot.func_75211_c()).func_190926_b()) {
            this.getShapeRenderer().setShapeID(this.getShapeID());
            this.getShapeRenderer().renderShape(this, stack, this.field_147003_i, this.field_147009_r, this.showAxis.isPressed(), this.showOuter.isPressed(), this.showScan.isPressed(), true);
        }
    }
}

