/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.shaper;

import java.util.Map;
import javax.annotation.Nullable;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.entity.GenericEnergyReceiverTileEntity;
import mcjty.lib.network.Argument;
import mcjty.rftools.blocks.builder.BuilderSetup;
import mcjty.rftools.blocks.shaper.PacketProjectorClientNotification;
import mcjty.rftools.blocks.shaper.ProjectorContainer;
import mcjty.rftools.blocks.shaper.ProjectorOpcode;
import mcjty.rftools.blocks.shaper.ProjectorOperation;
import mcjty.rftools.blocks.shaper.ProjectorSounds;
import mcjty.rftools.blocks.shaper.ScannerConfiguration;
import mcjty.rftools.items.builder.ShapeCardItem;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.rftools.shapes.RenderData;
import mcjty.rftools.shapes.ShapeID;
import mcjty.rftools.shapes.ShapeRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ProjectorTileEntity
extends GenericEnergyReceiverTileEntity
implements DefaultSidedInventory,
ITickable {
    public static final String CMD_SETTINGS = "settings";
    public static final String CMD_RSSETTINGS = "rsSettings";
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, ProjectorContainer.factory, 1);
    private ShapeRenderer shapeRenderer = null;
    private ProjectorOperation[] operations = new ProjectorOperation[4];
    private boolean active = false;
    private float verticalOffset = 0.2f;
    private float scale = 0.01f;
    private float angle = 0.0f;
    private boolean autoRotate = false;
    private boolean projecting = false;
    private boolean scanline = true;
    private boolean sound = true;
    private boolean grayscale = false;
    private int counter = 0;
    private boolean scanNeeded = false;
    private boolean doNotifyClients = false;

    public ProjectorTileEntity() {
        super(ScannerConfiguration.PROJECTOR_MAXENERGY, ScannerConfiguration.PROJECTOR_RECEIVEPERTICK);
        for (int i = 0; i < this.operations.length; ++i) {
            this.operations[i] = new ProjectorOperation();
        }
        for (ProjectorOperation operation : this.operations) {
            operation.setOpcodeOn(ProjectorOpcode.NONE);
            operation.setValueOn(null);
            operation.setOpcodeOff(ProjectorOpcode.NONE);
            operation.setValueOff(null);
        }
        this.operations[0].setOpcodeOn(ProjectorOpcode.ON);
        this.operations[0].setOpcodeOff(ProjectorOpcode.ON);
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            this.updateOperations(false);
            boolean a = this.active;
            if (a && this.getEnergyStored() < ScannerConfiguration.PROJECTOR_USEPERTICK) {
                a = false;
            }
            if (a != this.projecting) {
                this.projecting = a;
                this.markForNotification();
            }
            if (this.projecting) {
                this.consumeEnergy(ScannerConfiguration.PROJECTOR_USEPERTICK);
            }
            if (this.doNotifyClients) {
                this.doNotifyClients = false;
                this.notifyClients();
            }
        } else {
            if (this.scanNeeded) {
                this.scanNeeded = false;
                RenderData data = ShapeRenderer.getRenderDataAndCreate(this.getShapeID());
                data.setWantData(true);
            }
            if (this.autoRotate) {
                this.angle += 1.0f;
                if (this.angle >= 360.0f) {
                    this.angle = 0.0f;
                }
            }
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.func_145831_w().field_72995_K) {
            this.stopSounds();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void stopSounds() {
        ProjectorSounds.stopSound(this.func_174877_v());
    }

    public ShapeID getShapeID() {
        int scanId = ShapeCardItem.getScanId(this.getRenderStack());
        boolean isSolid = ShapeCardItem.isSolid(this.getRenderStack());
        if (scanId == 0) {
            return new ShapeID(this.func_145831_w().field_73011_w.getDimension(), this.func_174877_v(), scanId, this.isGrayscale(), isSolid);
        }
        return new ShapeID(0, null, scanId, this.isGrayscale(), isSolid);
    }

    public void setPowerInput(int powered) {
        boolean changed = this.powerLevel != powered;
        super.setPowerInput(powered);
        if (changed) {
            this.updateOperations(true);
        }
    }

    private void updateOperations(boolean pulse) {
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            int index = facing.ordinal() - 2;
            ProjectorOperation op = this.operations[index];
            int pl = index ^ 1;
            if ((this.powerLevel >> pl & 1) != 0) {
                this.handleOpcode(op.getOpcodeOn(), op.getValueOn(), pulse);
                continue;
            }
            this.handleOpcode(op.getOpcodeOff(), op.getValueOff(), pulse);
        }
    }

    private void handleOpcode(ProjectorOpcode op, @Nullable Double val, boolean pulse) {
        if (op == null) {
            op = ProjectorOpcode.NONE;
        }
        switch (op) {
            case NONE: {
                break;
            }
            case ON: {
                this.setActive(true);
                break;
            }
            case OFF: {
                this.setActive(false);
                break;
            }
            case SCAN: {
                if (!pulse) break;
                ++this.counter;
                this.markForNotification();
                break;
            }
            case OFFSET: {
                double o = this.getOffsetDouble();
                if (val == null || !(Math.abs(o - val) > 0.3)) break;
                o = o < val ? (o += 1.0) : (o -= 1.0);
                this.setOffsetInt(o);
                this.markForNotification();
                break;
            }
            case ROT: {
                int o = this.getAngleInt();
                if (val == null || (double)o == val) break;
                o = (double)o < val ? ++o : --o;
                this.setAngleInt(o);
                this.markForNotification();
                break;
            }
            case SCALE: {
                double o = this.getScaleDouble();
                if (val == null || !(Math.abs(o - val) > 0.3)) break;
                o = o < val ? (o += 1.0) : (o -= 1.0);
                this.setScaleInt(o);
                this.markForNotification();
                break;
            }
            case GRAYON: {
                this.grayscale = true;
                this.markForNotification();
                break;
            }
            case GRAYOFF: {
                this.grayscale = false;
                this.markForNotification();
            }
        }
    }

    private void setActive(boolean a) {
        if (a == this.active) {
            return;
        }
        this.active = a;
        this.markDirtyQuick();
    }

    public ProjectorOperation[] getOperations() {
        return this.operations;
    }

    public int getCounter() {
        return this.counter;
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public boolean func_191420_l() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return stack.func_77973_b() == BuilderSetup.shapeCardItem;
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
        this.verticalOffset = tagCompound.func_74764_b("offs") ? tagCompound.func_74760_g("offs") : 0.2f;
        this.scale = tagCompound.func_74764_b("scale") ? tagCompound.func_74760_g("scale") : 0.01f;
        this.angle = tagCompound.func_74764_b("angle") ? tagCompound.func_74760_g("angle") : 0.0f;
        this.autoRotate = tagCompound.func_74767_n("rot");
        this.scanline = tagCompound.func_74767_n("scan");
        this.sound = tagCompound.func_74767_n("sound");
        boolean gs = tagCompound.func_74767_n("grayscale");
        if (gs != this.grayscale) {
            this.grayscale = gs;
            this.shapeRenderer = null;
            this.scanNeeded = true;
        }
        this.projecting = tagCompound.func_74767_n("projecting");
        this.active = tagCompound.func_74767_n("active");
        this.counter = tagCompound.func_74762_e("counter");
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            if (!tagCompound.func_74764_b("op_" + facing.func_176610_l())) continue;
            int index = facing.ordinal() - 2;
            ProjectorOperation op = this.operations[index];
            NBTTagCompound tc = (NBTTagCompound)tagCompound.func_74781_a("op_" + facing.func_176610_l());
            String on = tc.func_74779_i("on");
            Double von = null;
            if (tc.func_74764_b("von")) {
                von = tc.func_74769_h("von");
            }
            String off = tc.func_74779_i("off");
            Double voff = null;
            if (tc.func_74764_b("voff")) {
                voff = tc.func_74769_h("voff");
            }
            op.setOpcodeOn(ProjectorOpcode.getByCode(on));
            op.setOpcodeOff(ProjectorOpcode.getByCode(off));
            op.setValueOn(von);
            op.setValueOff(voff);
        }
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
        tagCompound.func_74776_a("offs", this.verticalOffset);
        tagCompound.func_74776_a("scale", this.scale);
        tagCompound.func_74776_a("angle", this.angle);
        tagCompound.func_74757_a("rot", this.autoRotate);
        tagCompound.func_74757_a("scan", this.scanline);
        tagCompound.func_74757_a("sound", this.sound);
        tagCompound.func_74757_a("grayscale", this.grayscale);
        tagCompound.func_74757_a("projecting", this.projecting);
        tagCompound.func_74757_a("active", this.active);
        tagCompound.func_74768_a("counter", this.counter);
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            int index = facing.ordinal() - 2;
            ProjectorOperation op = this.operations[index];
            NBTTagCompound tc = new NBTTagCompound();
            tc.func_74778_a("on", op.getOpcodeOn().getCode());
            if (op.getValueOn() != null) {
                tc.func_74780_a("von", op.getValueOn().doubleValue());
            }
            tc.func_74778_a("off", op.getOpcodeOff().getCode());
            if (op.getValueOff() != null) {
                tc.func_74780_a("voff", op.getValueOff().doubleValue());
            }
            tagCompound.func_74782_a("op_" + facing.func_176610_l(), (NBTBase)tc);
        }
    }

    public float getVerticalOffset() {
        return this.verticalOffset;
    }

    public int getOffsetInt() {
        return (int)this.getOffsetDouble();
    }

    private float getOffsetDouble() {
        return this.verticalOffset * 20.0f;
    }

    private void setOffsetInt(double o) {
        this.verticalOffset = (float)(o / 20.0);
    }

    public float getScale() {
        return this.scale;
    }

    public int getScaleInt() {
        return (int)this.getScaleDouble();
    }

    private double getScaleDouble() {
        return 20.0 * Math.log((this.scale - 0.001f) / 0.1f * 147.4131f + 1.0f);
    }

    private void setScaleInt(double s) {
        this.scale = ((float)Math.exp(s / 20.0) - 1.0f) / 147.4131f * 0.1f + 0.001f;
    }

    public float getAngle() {
        return this.angle;
    }

    public int getAngleInt() {
        return (int)this.angle;
    }

    private void setAngleInt(int a) {
        this.angle = a;
    }

    public boolean isAutoRotate() {
        return this.autoRotate;
    }

    public boolean isScanline() {
        return this.scanline;
    }

    public boolean isSound() {
        return this.sound;
    }

    public boolean isGrayscale() {
        return this.grayscale;
    }

    public boolean isProjecting() {
        return this.projecting;
    }

    public ItemStack getRenderStack() {
        return this.inventoryHelper.getStackInSlot(0);
    }

    public ShapeRenderer getShapeRenderer() {
        if (this.shapeRenderer == null) {
            this.shapeRenderer = new ShapeRenderer(this.getShapeID());
        }
        return this.shapeRenderer;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(-5, 0, -5), this.field_174879_c.func_177982_a(6, 5, 6));
    }

    private void markForNotification() {
        this.markDirtyQuick();
        this.doNotifyClients = true;
    }

    private void notifyClients() {
        int dimension = this.func_145831_w().field_73011_w.getDimension();
        double x = this.func_174877_v().func_177958_n();
        double y = this.func_174877_v().func_177956_o();
        double z = this.func_174877_v().func_177952_p();
        double sqradius = 1600.0;
        for (EntityPlayerMP player : this.func_145831_w().func_73046_m().func_184103_al().func_181057_v()) {
            double d2;
            double d1;
            double d0;
            if (player.field_71093_bK != dimension || !((d0 = x - player.field_70165_t) * d0 + (d1 = y - player.field_70163_u) * d1 + (d2 = z - player.field_70161_v) * d2 < sqradius)) continue;
            RFToolsMessages.INSTANCE.sendTo((IMessage)new PacketProjectorClientNotification(this), player);
        }
    }

    public void updateFromServer(PacketProjectorClientNotification message) {
        this.verticalOffset = message.getVerticalOffset();
        this.scale = message.getScale();
        this.angle = message.getAngle();
        this.autoRotate = message.isAutoRotate();
        this.projecting = message.isProjecting();
        this.scanline = message.isScanline();
        this.sound = message.isSound();
        if (this.grayscale != message.isGrayscale()) {
            this.grayscale = message.isGrayscale();
            this.shapeRenderer = null;
            this.scanNeeded = true;
        }
        if (this.counter != message.getCounter()) {
            this.counter = message.getCounter();
            this.scanNeeded = true;
        }
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_RSSETTINGS.equals(command)) {
            for (EnumFacing facing : EnumFacing.field_176754_o) {
                int idx = facing.ordinal() - 2;
                String opOn = args.get("opOn" + idx).getString();
                String opOff = args.get("opOff" + idx).getString();
                Double valOn = null;
                Double valOff = null;
                if (args.containsKey("valOn" + idx)) {
                    valOn = args.get("valOn" + idx).getDouble();
                }
                if (args.containsKey("valOff" + idx)) {
                    valOff = args.get("valOff" + idx).getDouble();
                }
                this.operations[idx].setOpcodeOn(ProjectorOpcode.getByCode(opOn));
                this.operations[idx].setOpcodeOff(ProjectorOpcode.getByCode(opOff));
                this.operations[idx].setValueOn(valOn);
                this.operations[idx].setValueOff(valOff);
            }
            this.markDirtyClient();
            this.updateOperations(false);
            return true;
        }
        if (CMD_SETTINGS.equals(command)) {
            int scaleInt = args.get("scale").getInteger();
            int offsetInt = args.get("offset").getInteger();
            int angleInt = args.get("angle").getInteger();
            this.setScaleInt(scaleInt);
            this.setOffsetInt(offsetInt);
            this.setAngleInt(angleInt);
            this.autoRotate = args.get("auto").getBoolean();
            this.scanline = args.get("scan").getBoolean();
            this.sound = args.get("sound").getBoolean();
            this.grayscale = args.get("grayscale").getBoolean();
            this.markDirtyClient();
            return true;
        }
        return false;
    }
}

