/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.spawner;

import java.awt.Rectangle;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.List;
import mcjty.lib.base.ModBase;
import mcjty.lib.container.GenericGuiContainer;
import mcjty.lib.entity.GenericEnergyStorageTileEntity;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.network.clientinfo.InfoPacketServer;
import mcjty.lib.network.clientinfo.PacketGetInfoFromServer;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.spawner.SpawnerConfiguration;
import mcjty.rftools.blocks.spawner.SpawnerContainer;
import mcjty.rftools.blocks.spawner.SpawnerInfoPacketClient;
import mcjty.rftools.blocks.spawner.SpawnerInfoPacketServer;
import mcjty.rftools.blocks.spawner.SpawnerTileEntity;
import mcjty.rftools.items.SyringeItem;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.block.Block;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiSpawner
extends GenericGuiContainer<SpawnerTileEntity> {
    private static final int SPAWNER_WIDTH = 180;
    private static final int SPAWNER_HEIGHT = 152;
    private EnergyBar energyBar;
    private BlockRender[] blocks = new BlockRender[3];
    private Label[] labels = new Label[3];
    private Label name;
    private Label rfTick;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftools", "textures/gui/spawner.png");
    private static long lastTime = 0L;

    public GuiSpawner(SpawnerTileEntity spawnerTileEntity, SpawnerContainer container) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, (GenericTileEntity)spawnerTileEntity, (Container)container, RFTools.GUI_MANUAL_MAIN, "spawner");
        GenericEnergyStorageTileEntity.setCurrentRF((int)spawnerTileEntity.getEnergyStored());
        this.field_146999_f = 180;
        this.field_147000_g = 152;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int maxEnergyStored = ((SpawnerTileEntity)this.tileEntity).getMaxEnergyStored();
        this.energyBar = ((EnergyBar)new EnergyBar(this.field_146297_k, (Gui)this).setVertical().setMaxValue(maxEnergyStored).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(10, 7, 8, 54))).setShowText(false);
        this.energyBar.setValue(GenericEnergyStorageTileEntity.getCurrentRF());
        this.blocks[0] = (BlockRender)new BlockRender(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(80, 5, 18, 18));
        this.blocks[1] = (BlockRender)new BlockRender(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(80, 25, 18, 18));
        this.blocks[2] = (BlockRender)new BlockRender(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(80, 45, 18, 18));
        this.labels[0] = new Label(this.field_146297_k, (Gui)this).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT);
        this.labels[0].setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(100, 5, 74, 18));
        this.labels[1] = new Label(this.field_146297_k, (Gui)this).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT);
        this.labels[1].setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(100, 25, 74, 18));
        this.labels[2] = new Label(this.field_146297_k, (Gui)this).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT);
        this.labels[2].setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(100, 45, 74, 18));
        this.name = new Label(this.field_146297_k, (Gui)this).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT);
        this.name.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(22, 31, 78, 16));
        this.rfTick = new Label(this.field_146297_k, (Gui)this).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT);
        this.rfTick.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(22, 47, 78, 16));
        Panel toplevel = (Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setBackground(iconLocation)).setLayout((Layout)new PositionalLayout()).addChild((Widget)this.energyBar)).addChild((Widget)this.blocks[0])).addChild((Widget)this.labels[0])).addChild((Widget)this.blocks[1])).addChild((Widget)this.labels[1])).addChild((Widget)this.blocks[2])).addChild((Widget)this.labels[2])).addChild((Widget)this.rfTick)).addChild((Widget)this.name);
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        this.window = new Window((GuiScreen)this, (Widget)toplevel);
        ((SpawnerTileEntity)this.tileEntity).requestRfFromServer("rftools");
    }

    private void showSyringeInfo() {
        for (int i = 0; i < 3; ++i) {
            this.blocks[i].setRenderItem(null);
            this.labels[i].setText("");
        }
        this.name.setText("");
        this.rfTick.setText("");
        ItemStack stack = ((SpawnerTileEntity)this.tileEntity).func_70301_a(0);
        if (stack.func_190926_b()) {
            return;
        }
        String mobId = SyringeItem.getMobId(stack);
        if (mobId != null) {
            String mobName = SyringeItem.getMobName(stack);
            this.name.setText(mobName);
            this.rfTick.setText(SpawnerConfiguration.mobSpawnRf.get(mobId) + "RF");
            int i = 0;
            List<SpawnerConfiguration.MobSpawnAmount> list = SpawnerConfiguration.mobSpawnAmounts.get(mobId);
            if (list != null) {
                float[] matter;
                if (System.currentTimeMillis() - lastTime > 100L) {
                    lastTime = System.currentTimeMillis();
                    RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketGetInfoFromServer("rftools", (InfoPacketServer)new SpawnerInfoPacketServer(((SpawnerTileEntity)this.tileEntity).func_145831_w().field_73011_w.getDimension(), ((SpawnerTileEntity)this.tileEntity).func_174877_v())));
                }
                if ((matter = SpawnerInfoPacketClient.matterReceived) == null || matter.length != 3) {
                    matter = new float[]{0.0f, 0.0f, 0.0f};
                }
                for (SpawnerConfiguration.MobSpawnAmount spawnAmount : list) {
                    ItemStack b = spawnAmount.getObject();
                    float amount = spawnAmount.getAmount();
                    if (b.func_190926_b()) {
                        Object[] blocks = new Object[]{Blocks.field_150362_t, Blocks.field_150423_aK, Items.field_151015_O, Items.field_151174_bG, Items.field_151082_bd};
                        int index = (int)(System.currentTimeMillis() / 500L % (long)blocks.length);
                        if (blocks[index] instanceof Block) {
                            this.blocks[i].setRenderItem((Object)new ItemStack((Block)blocks[index], 1, 0));
                        } else {
                            this.blocks[i].setRenderItem((Object)new ItemStack((Item)blocks[index], 1, 0));
                        }
                    } else {
                        this.blocks[i].setRenderItem((Object)b);
                    }
                    DecimalFormat format = new DecimalFormat("#.##");
                    format.setRoundingMode(RoundingMode.DOWN);
                    String mf = format.format(matter[i]);
                    this.labels[i].setText(mf + "/" + Float.toString(amount));
                    ++i;
                }
            }
        }
    }

    protected void func_146976_a(float v, int i, int i2) {
        this.showSyringeInfo();
        this.drawWindow();
        int currentRF = GenericEnergyStorageTileEntity.getCurrentRF();
        this.energyBar.setValue(currentRF);
        ((SpawnerTileEntity)this.tileEntity).requestRfFromServer("rftools");
    }
}

