/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storage;

import java.util.List;
import mcjty.lib.api.IModuleSupport;
import mcjty.lib.varia.ModuleSupport;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.logic.generic.LogicSlabBlock;
import mcjty.rftools.blocks.screens.ScreenSetup;
import mcjty.rftools.blocks.storage.GuiLevelEmitter;
import mcjty.rftools.blocks.storage.LevelEmitterContainer;
import mcjty.rftools.blocks.storage.LevelEmitterTileEntity;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class LevelEmitterBlock
extends LogicSlabBlock<LevelEmitterTileEntity, LevelEmitterContainer> {
    public static final PropertyBool MODULE = PropertyBool.func_177716_a((String)"module");

    public LevelEmitterBlock() {
        super(Material.field_151573_f, "level_emitter", LevelEmitterTileEntity.class, LevelEmitterContainer.class, true);
    }

    @SideOnly(value=Side.CLIENT)
    public Class<GuiLevelEmitter> getGuiClass() {
        return GuiLevelEmitter.class;
    }

    protected IModuleSupport getModuleSupport() {
        return new ModuleSupport(0){

            public boolean isModule(ItemStack itemStack) {
                return itemStack.func_77973_b() == ScreenSetup.storageControlModuleItem;
            }
        };
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack itemStack, World player, List<String> list, ITooltipFlag whatIsThis) {
        super.func_190948_a(itemStack, player, list, whatIsThis);
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(TextFormatting.WHITE + "This block can be retrofitted with a");
            list.add(TextFormatting.WHITE + "Storage Control Screen Module so that");
            list.add(TextFormatting.WHITE + "you can count items in your storage");
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        ItemStack module = LevelEmitterBlock.getModule(world.func_175625_s(data.getPos()));
        if (module.func_190926_b()) {
            probeInfo.text(TextFormatting.GREEN + "Install storage control screen module first");
        } else {
            TileEntity te = world.func_175625_s(data.getPos());
            if (te instanceof LevelEmitterTileEntity) {
                LevelEmitterTileEntity emitterTileEntity = (LevelEmitterTileEntity)te;
                int count = emitterTileEntity.getCurrentCount();
                ItemStack toCount = emitterTileEntity.getInventoryHelper().getStackInSlot(1);
                if (!toCount.func_190926_b()) {
                    probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).item(toCount).text(TextFormatting.BLUE + "Count: " + TextFormatting.WHITE + count);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="waila")
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        ItemStack module = LevelEmitterBlock.getModule(accessor.getTileEntity());
        if (module.func_190926_b()) {
            currenttip.add(TextFormatting.GREEN + "Install storage control screen module first");
        }
        return currenttip;
    }

    @Override
    public boolean needsRedstoneCheck() {
        return false;
    }

    public int getGuiID() {
        return RFTools.GUI_STORAGE_TERMINAL;
    }

    private static ItemStack getModule(TileEntity tileEntity) {
        if (tileEntity instanceof LevelEmitterTileEntity) {
            LevelEmitterTileEntity emitterTileEntity = (LevelEmitterTileEntity)tileEntity;
            return emitterTileEntity.func_70301_a(0);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        ItemStack module = LevelEmitterBlock.getModule(world.func_175625_s(pos));
        return super.func_176221_a(state, world, pos).func_177226_a((IProperty)MODULE, (Comparable)Boolean.valueOf(!module.func_190926_b()));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{LOGIC_FACING, META_INTERMEDIATE, OUTPUTPOWER, MODULE});
    }
}

