/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storagemonitor;

import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import mcjty.lib.base.ModBase;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.container.GenericGuiContainer;
import mcjty.lib.container.GhostOutputSlot;
import mcjty.lib.entity.GenericEnergyStorageTileEntity;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.gui.Scrollable;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.events.BlockRenderEvent;
import mcjty.lib.gui.events.DefaultSelectionEvent;
import mcjty.lib.gui.events.SelectionEvent;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.layout.VerticalLayout;
import mcjty.lib.gui.widgets.AbstractWidget;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.gui.widgets.ImageLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.ScrollableLabel;
import mcjty.lib.gui.widgets.Slider;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.network.Argument;
import mcjty.lib.network.Arguments;
import mcjty.lib.network.clientinfo.InfoPacketServer;
import mcjty.lib.network.clientinfo.PacketGetInfoFromServer;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.Logging;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.storagemonitor.GetContentsInfoPacketServer;
import mcjty.rftools.blocks.storagemonitor.InventoriesInfoPacketClient;
import mcjty.rftools.blocks.storagemonitor.InventoriesInfoPacketServer;
import mcjty.rftools.blocks.storagemonitor.PacketRequestItem;
import mcjty.rftools.blocks.storagemonitor.ScannerInfoPacketClient;
import mcjty.rftools.blocks.storagemonitor.ScannerInfoPacketServer;
import mcjty.rftools.blocks.storagemonitor.SearchItemsInfoPacketServer;
import mcjty.rftools.blocks.storagemonitor.StorageScannerConfiguration;
import mcjty.rftools.blocks.storagemonitor.StorageScannerContainer;
import mcjty.rftools.blocks.storagemonitor.StorageScannerTileEntity;
import mcjty.rftools.craftinggrid.GuiCraftingGrid;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiStorageScanner
extends GenericGuiContainer<StorageScannerTileEntity> {
    private static final int STORAGE_MONITOR_WIDTH = 256;
    private static final int STORAGE_MONITOR_HEIGHT = 244;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftools", "textures/gui/storagescanner.png");
    private static final ResourceLocation guielements = new ResourceLocation("rftools", "textures/gui/guielements.png");
    private WidgetList storageList;
    private WidgetList itemList;
    private ToggleButton openViewButton;
    private EnergyBar energyBar;
    private Button topButton;
    private Button upButton;
    private Button downButton;
    private Button bottomButton;
    private Button removeButton;
    private TextField searchField;
    private ImageChoiceLabel exportToStarred;
    private Panel storagePanel;
    private Panel itemPanel;
    private ScrollableLabel radiusLabel;
    private Label visibleRadiusLabel;
    private GuiCraftingGrid craftingGrid;
    private long prevTime = -1L;
    private int listDirty = 0;
    private boolean init = false;
    public static List<InventoriesInfoPacketClient.InventoryInfo> fromServer_inventories = new ArrayList<InventoriesInfoPacketClient.InventoryInfo>();
    public static Set<BlockPos> fromServer_foundInventories = new HashSet<BlockPos>();
    public static List<ItemStack> fromServer_inventory = new ArrayList<ItemStack>();
    private static long lastTime = 0L;

    public GuiStorageScanner(StorageScannerTileEntity storageScannerTileEntity, StorageScannerContainer storageScannerContainer) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, (GenericTileEntity)storageScannerTileEntity, (Container)storageScannerContainer, RFTools.GUI_MANUAL_MAIN, "stomon");
        GenericEnergyStorageTileEntity.setCurrentRF((int)storageScannerTileEntity.getEnergyStored());
        this.craftingGrid = new GuiCraftingGrid();
        this.field_146999_f = 256;
        this.field_147000_g = 244;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int maxEnergyStored = ((StorageScannerTileEntity)this.tileEntity).getMaxEnergyStored();
        this.energyBar = ((EnergyBar)((EnergyBar)((EnergyBar)new EnergyBar(this.field_146297_k, (Gui)this).setFilledRectThickness(1)).setVertical().setDesiredWidth(10)).setDesiredHeight(50)).setMaxValue(maxEnergyStored).setShowText(false);
        this.energyBar.setValue(GenericEnergyStorageTileEntity.getCurrentRF());
        this.openViewButton = (ToggleButton)((ToggleButton)new ToggleButton(this.field_146297_k, (Gui)this).setCheckMarker(false).setText("V")).setTooltips(new String[]{"Toggle wide storage list"});
        this.openViewButton.setPressed(((StorageScannerTileEntity)this.tileEntity).isOpenWideView());
        this.openViewButton.addButtonEvent(widget -> this.toggleView());
        this.upButton = ((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("U")).setTooltips(new String[]{"Move inventory up"})).addButtonEvent(widget -> this.moveUp());
        this.topButton = ((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("T")).setTooltips(new String[]{"Move inventory to the top"})).addButtonEvent(widget -> this.moveTop());
        this.downButton = ((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("D")).setTooltips(new String[]{"Move inventory down"})).addButtonEvent(widget -> this.moveDown());
        this.bottomButton = ((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("B")).setTooltips(new String[]{"Move inventory to the bottom"})).addButtonEvent(widget -> this.moveBottom());
        this.removeButton = ((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("R")).setTooltips(new String[]{"Remove inventory from list"})).addButtonEvent(widget -> this.removeFromList());
        Panel energyPanel = (Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)((VerticalLayout)new VerticalLayout().setVerticalMargin(0)).setSpacing(1)).setDesiredWidth(10);
        ((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)energyPanel.addChild((Widget)this.openViewButton)).addChild((Widget)this.energyBar)).addChild((Widget)this.topButton)).addChild((Widget)this.upButton)).addChild((Widget)this.downButton)).addChild((Widget)this.bottomButton)).addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText(" "))).addChild((Widget)this.removeButton);
        this.exportToStarred = ((ImageChoiceLabel)new ImageChoiceLabel(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(12, 223, 13, 13))).addChoiceEvent((parent, newChoice) -> this.changeExportMode());
        this.exportToStarred.addChoice("No", "Export to current container", guielements, 131, 19);
        this.exportToStarred.addChoice("Yes", "Export to first routable container", guielements, 115, 19);
        this.storagePanel = this.makeStoragePanel(energyPanel);
        this.itemPanel = this.makeItemPanel();
        Button scanButton = ((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("Scan")).setDesiredWidth(50)).setDesiredHeight(14)).addButtonEvent(parent -> RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketGetInfoFromServer("rftools", (InfoPacketServer)new InventoriesInfoPacketServer(((StorageScannerTileEntity)this.tileEntity).getDimension(), ((StorageScannerTileEntity)this.tileEntity).getStorageScannerPos(), true))));
        if (RFTools.instance.xnet) {
            if (StorageScannerConfiguration.xnetRequired) {
                scanButton.setTooltips(new String[]{"Do a scan of all", "storage units connected", "with an active XNet channel"});
            } else {
                scanButton.setTooltips(new String[]{"Do a scan of all", "storage units in radius", "Use 'xnet' radius to", "restrict to XNet only"});
            }
        } else {
            scanButton.setTooltips(new String[]{"Do a scan of all", "storage units in radius"});
        }
        this.radiusLabel = new ScrollableLabel(this.field_146297_k, (Gui)this).addValueEvent((parent, newValue) -> this.changeRadius(newValue)).setRealMinimum(RFTools.instance.xnet ? 0 : 1).setRealMaximum(20);
        this.radiusLabel.setRealValue(((StorageScannerTileEntity)this.tileEntity).getRadius());
        this.visibleRadiusLabel = new Label(this.field_146297_k, (Gui)this);
        this.visibleRadiusLabel.setDesiredWidth(40);
        this.searchField = new TextField(this.field_146297_k, (Gui)this).addTextEvent((parent, newText) -> {
            this.storageList.clearHilightedRows();
            fromServer_foundInventories.clear();
            this.startSearch(newText);
        });
        Panel searchPanel = (Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(8, 142, 245, 18))).setLayout((Layout)new HorizontalLayout()).setDesiredHeight(18)).addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText("Search:"))).addChild((Widget)this.searchField);
        Slider radiusSlider = ((Slider)((Slider)new Slider(this.field_146297_k, (Gui)this).setHorizontal().setTooltips(new String[]{"Radius of scan"})).setMinimumKnobSize(12).setDesiredHeight(14)).setScrollable((Scrollable)this.radiusLabel);
        Panel scanPanel = (Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(8, 162, 74, 54))).setFilledRectThickness(-2)).setFilledBackground(StyleConfig.colorListBackground)).setLayout((Layout)((VerticalLayout)new VerticalLayout().setVerticalMargin(6)).setSpacing(1)).addChild((Widget)scanButton);
        if (!RFTools.instance.xnet || !StorageScannerConfiguration.xnetRequired) {
            scanPanel.addChild((Widget)radiusSlider);
        }
        scanPanel.addChild((Widget)this.visibleRadiusLabel);
        if (((StorageScannerTileEntity)this.tileEntity).isDummy()) {
            scanButton.setEnabled(false);
            this.radiusLabel.setVisible(false);
            radiusSlider.setVisible(false);
        }
        Panel toplevel = (Panel)((Panel)((Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setBackground(iconLocation)).setLayout((Layout)new PositionalLayout()).addChild((Widget)this.storagePanel)).addChild((Widget)this.itemPanel)).addChild((Widget)searchPanel)).addChild((Widget)scanPanel)).addChild((Widget)this.exportToStarred);
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        this.window = new Window((GuiScreen)this, (Widget)toplevel);
        Keyboard.enableRepeatEvents((boolean)true);
        fromServer_foundInventories.clear();
        fromServer_inventory.clear();
        if (((StorageScannerTileEntity)this.tileEntity).isDummy()) {
            fromServer_inventories.clear();
        } else {
            ((StorageScannerTileEntity)this.tileEntity).requestRfFromServer("rftools");
        }
        BlockPos pos = ((StorageScannerTileEntity)this.tileEntity).getCraftingGridContainerPos();
        this.craftingGrid.initGui(this.modBase, this.network, this.field_146297_k, this, pos, ((StorageScannerTileEntity)this.tileEntity).getCraftingGridProvider(), this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g);
        this.sendServerCommand("rftools", "requestGridSync", Arguments.builder().value(pos).build());
        if (StorageScannerConfiguration.hilightStarredOnGuiOpen) {
            this.storageList.setSelected(0);
        }
        this.init = true;
    }

    private int getStoragePanelWidth() {
        return this.openViewButton.isPressed() ? 130 : 50;
    }

    private Panel makeItemPanel() {
        this.itemList = new WidgetList(this.field_146297_k, (Gui)this).setPropagateEventsToChildren(true).setInvisibleSelection(true);
        Slider itemListSlider = ((Slider)new Slider(this.field_146297_k, (Gui)this).setDesiredWidth(10)).setVertical().setScrollable((Scrollable)this.itemList);
        return (Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)((HorizontalLayout)new HorizontalLayout().setSpacing(1)).setHorizontalMargin(1)).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(this.getStoragePanelWidth() + 6, 4, 256 - this.getStoragePanelWidth() - 12, 140))).addChild((Widget)this.itemList)).addChild((Widget)itemListSlider);
    }

    private Panel makeStoragePanel(Panel energyPanel) {
        this.storageList = new WidgetList(this.field_146297_k, (Gui)this).addSelectionEvent((SelectionEvent)new DefaultSelectionEvent(){

            public void select(Widget parent, int index) {
                GuiStorageScanner.this.getInventoryOnServer();
            }

            public void doubleClick(Widget parent, int index) {
                GuiStorageScanner.this.hilightSelectedContainer(index);
            }
        }).setPropagateEventsToChildren(true);
        Slider storageListSlider = ((Slider)new Slider(this.field_146297_k, (Gui)this).setDesiredWidth(10)).setVertical().setScrollable((Scrollable)this.storageList);
        return (Panel)((Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)((HorizontalLayout)new HorizontalLayout().setSpacing(1)).setHorizontalMargin(1)).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(3, 4, this.getStoragePanelWidth(), 140))).setDesiredHeight(140)).addChild((Widget)energyPanel)).addChild((Widget)this.storageList)).addChild((Widget)storageListSlider);
    }

    private void toggleView() {
        this.storagePanel.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(3, 4, this.getStoragePanelWidth(), 140));
        this.itemPanel.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(this.getStoragePanelWidth() + 6, 4, 256 - this.getStoragePanelWidth() - 12, 140));
        this.window.getToplevel().setBounds(this.window.getToplevel().getBounds());
        this.listDirty = 0;
        this.requestListsIfNeeded();
        this.sendServerCommand(RFToolsMessages.INSTANCE, ((StorageScannerTileEntity)this.tileEntity).getDimension(), "setView", new Argument[]{new Argument("b", this.openViewButton.isPressed())});
    }

    protected void func_73864_a(int x, int y, int button) throws IOException {
        Slot slot;
        super.func_73864_a(x, y, button);
        this.craftingGrid.getWindow().mouseClicked(x, y, button);
        if (button == 1 && (slot = this.func_146975_c(x, y)) instanceof GhostOutputSlot) {
            this.sendServerCommand(RFToolsMessages.INSTANCE, "clearGrid", new Argument[0]);
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.craftingGrid.getWindow().handleMouseInput();
    }

    protected void func_146286_b(int x, int y, int state) {
        super.func_146286_b(x, y, state);
        this.craftingGrid.getWindow().mouseMovedOrUp(x, y, state);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        this.craftingGrid.getWindow().keyTyped(typedChar, keyCode);
    }

    private void moveUp() {
        this.sendServerCommand(RFToolsMessages.INSTANCE, ((StorageScannerTileEntity)this.tileEntity).getDimension(), "up", new Argument[]{new Argument("index", this.storageList.getSelected() - 1)});
        this.storageList.setSelected(this.storageList.getSelected() - 1);
        this.listDirty = 0;
    }

    private void moveTop() {
        this.sendServerCommand(RFToolsMessages.INSTANCE, ((StorageScannerTileEntity)this.tileEntity).getDimension(), "top", new Argument[]{new Argument("index", this.storageList.getSelected() - 1)});
        this.storageList.setSelected(1);
        this.listDirty = 0;
    }

    private void moveDown() {
        this.sendServerCommand(RFToolsMessages.INSTANCE, ((StorageScannerTileEntity)this.tileEntity).getDimension(), "down", new Argument[]{new Argument("index", this.storageList.getSelected() - 1)});
        this.storageList.setSelected(this.storageList.getSelected() + 1);
        this.listDirty = 0;
    }

    private void moveBottom() {
        this.sendServerCommand(RFToolsMessages.INSTANCE, ((StorageScannerTileEntity)this.tileEntity).getDimension(), "bottom", new Argument[]{new Argument("index", this.storageList.getSelected() - 1)});
        this.storageList.setSelected(this.storageList.getChildCount() - 1);
        this.listDirty = 0;
    }

    private void removeFromList() {
        this.sendServerCommand(RFToolsMessages.INSTANCE, ((StorageScannerTileEntity)this.tileEntity).getDimension(), "remove", new Argument[]{new Argument("index", this.storageList.getSelected() - 1)});
        this.listDirty = 0;
    }

    private void changeExportMode() {
        this.sendServerCommand(RFToolsMessages.INSTANCE, ((StorageScannerTileEntity)this.tileEntity).getDimension(), "toggleExport", new Argument[0]);
    }

    private void hilightSelectedContainer(int index) {
        if (index == -1) {
            return;
        }
        if (index == 0) {
            return;
        }
        InventoriesInfoPacketClient.InventoryInfo c = fromServer_inventories.get(index - 1);
        if (c != null) {
            RFTools.instance.clientInfo.hilightBlock(c.getPos(), System.currentTimeMillis() + (long)(1000 * StorageScannerConfiguration.hilightTime));
            Logging.message((EntityPlayer)this.field_146297_k.field_71439_g, (String)"The inventory is now highlighted");
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }

    private void changeRadius(int r) {
        this.sendServerCommand(RFToolsMessages.INSTANCE, ((StorageScannerTileEntity)this.tileEntity).getDimension(), "setRadius", new Argument[]{new Argument("r", r)});
    }

    private void startSearch(String text) {
        if (!text.isEmpty()) {
            RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketGetInfoFromServer("rftools", (InfoPacketServer)new SearchItemsInfoPacketServer(((StorageScannerTileEntity)this.tileEntity).getDimension(), ((StorageScannerTileEntity)this.tileEntity).getStorageScannerPos(), text)));
        }
    }

    private void getInventoryOnServer() {
        BlockPos c = this.getSelectedContainerPos();
        if (c != null) {
            RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketGetInfoFromServer("rftools", (InfoPacketServer)new GetContentsInfoPacketServer(((StorageScannerTileEntity)this.tileEntity).getDimension(), ((StorageScannerTileEntity)this.tileEntity).getStorageScannerPos(), c)));
        }
    }

    private BlockPos getSelectedContainerPos() {
        int selected = this.storageList.getSelected();
        if (selected != -1) {
            if (selected == 0) {
                return new BlockPos(-1, -1, -1);
            }
            if (--selected < fromServer_inventories.size()) {
                InventoriesInfoPacketClient.InventoryInfo info = fromServer_inventories.get(selected);
                if (info == null) {
                    return null;
                }
                return info.getPos();
            }
        }
        return null;
    }

    private void requestListsIfNeeded() {
        --this.listDirty;
        if (this.listDirty <= 0) {
            RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketGetInfoFromServer("rftools", (InfoPacketServer)new InventoriesInfoPacketServer(((StorageScannerTileEntity)this.tileEntity).getDimension(), ((StorageScannerTileEntity)this.tileEntity).getStorageScannerPos(), false)));
            this.getInventoryOnServer();
            this.listDirty = 20;
        }
    }

    private void updateContentsList() {
        this.itemList.removeChildren();
        Pair<Panel, Integer> currentPos = MutablePair.of(null, (Object)0);
        int numcolumns = this.openViewButton.isPressed() ? 5 : 9;
        int spacing = 3;
        Collections.sort(fromServer_inventory, Comparator.comparing(ItemStack::func_82833_r));
        String filterText = this.searchField.getText().toLowerCase();
        Predicate<ItemStack> matcher = StorageScannerTileEntity.getMatcher(filterText);
        for (ItemStack item : fromServer_inventory) {
            if (!filterText.isEmpty() && !matcher.test(item)) continue;
            currentPos = this.addItemToList(item, this.itemList, currentPos, numcolumns, spacing);
        }
    }

    private Pair<Panel, Integer> addItemToList(ItemStack item, WidgetList itemList, Pair<Panel, Integer> currentPos, int numcolumns, int spacing) {
        Panel panel = (Panel)currentPos.getKey();
        if (panel == null || (Integer)currentPos.getValue() >= numcolumns) {
            panel = (Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)((HorizontalLayout)new HorizontalLayout().setSpacing(spacing)).setHorizontalMargin(1)).setDesiredHeight(12)).setUserObject((Object)new Integer(-1))).setDesiredHeight(16);
            currentPos = MutablePair.of((Object)panel, (Object)0);
            itemList.addChild((Widget)panel);
        }
        BlockRender blockRender = ((BlockRender)new BlockRender(this.field_146297_k, (Gui)this).setRenderItem((Object)item).setUserObject((Object)1)).setOffsetX(-1).setOffsetY(-1).setHilightOnHover(true);
        blockRender.addSelectionEvent(new BlockRenderEvent(){

            public void select(Widget widget) {
                BlockRender br = (BlockRender)widget;
                Object item = br.getRenderItem();
                if (item != null) {
                    boolean shift = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
                    GuiStorageScanner.this.requestItem((ItemStack)item, shift ? 1 : -1);
                }
            }

            public void doubleClick(Widget widget) {
            }
        });
        panel.addChild((Widget)blockRender);
        currentPos.setValue((Object)((Integer)currentPos.getValue() + 1));
        return currentPos;
    }

    private void requestItem(ItemStack stack, int amount) {
        BlockPos selectedContainerPos = this.getSelectedContainerPos();
        if (selectedContainerPos == null) {
            return;
        }
        this.network.sendToServer((IMessage)new PacketRequestItem(((StorageScannerTileEntity)this.tileEntity).getDimension(), ((StorageScannerTileEntity)this.tileEntity).getStorageScannerPos(), selectedContainerPos, stack, amount));
        this.getInventoryOnServer();
    }

    private void changeRoutable(BlockPos c) {
        this.sendServerCommand(RFToolsMessages.INSTANCE, ((StorageScannerTileEntity)this.tileEntity).getDimension(), "toggleRoutable", new Argument[]{new Argument("pos", c)});
        this.listDirty = 0;
    }

    private void updateStorageList() {
        this.storageList.removeChildren();
        this.addStorageLine(null, "All routable", false);
        for (InventoriesInfoPacketClient.InventoryInfo c : fromServer_inventories) {
            String displayName = c.getName();
            boolean routable = c.isRoutable();
            this.addStorageLine(c, displayName, routable);
        }
        this.storageList.clearHilightedRows();
        int i = 0;
        for (InventoriesInfoPacketClient.InventoryInfo c : fromServer_inventories) {
            if (fromServer_foundInventories.contains(c.getPos())) {
                this.storageList.addHilightedRow(i + 1);
            }
            ++i;
        }
    }

    private void addStorageLine(InventoriesInfoPacketClient.InventoryInfo c, String displayName, boolean routable) {
        Panel panel;
        if (c == null) {
            panel = new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)((HorizontalLayout)new HorizontalLayout().setSpacing(8)).setHorizontalMargin(5));
            panel.addChild((Widget)new ImageLabel(this.field_146297_k, (Gui)this).setImage(guielements, 115, 19).setDesiredWidth(13).setDesiredHeight(13));
        } else {
            HorizontalLayout layout = new HorizontalLayout();
            if (!this.openViewButton.isPressed()) {
                layout.setHorizontalMargin(2);
            }
            panel = new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)layout);
            panel.addChild((Widget)new BlockRender(this.field_146297_k, (Gui)this).setRenderItem((Object)c.getBlock()));
        }
        if (this.openViewButton.isPressed()) {
            AbstractWidget label = new Label(this.field_146297_k, (Gui)this).setColor(StyleConfig.colorTextInListNormal).setText(displayName).setDynamic(true).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT).setDesiredWidth(58);
            if (c == null) {
                label.setTooltips(new String[]{TextFormatting.GREEN + "All routable inventories"}).setDesiredWidth(74);
            } else {
                label.setTooltips(new String[]{TextFormatting.GREEN + "Block at: " + TextFormatting.WHITE + BlockPosTools.toString((BlockPos)c.getPos()), TextFormatting.GREEN + "Name: " + TextFormatting.WHITE + displayName, "(doubleclick to highlight)"});
            }
            panel.addChild((Widget)label);
            if (c != null) {
                ImageChoiceLabel choiceLabel = (ImageChoiceLabel)new ImageChoiceLabel(this.field_146297_k, (Gui)this).addChoiceEvent((parent, newChoice) -> this.changeRoutable(c.getPos())).setDesiredWidth(13);
                choiceLabel.addChoice("No", "Not routable", guielements, 131, 19);
                choiceLabel.addChoice("Yes", "Routable", guielements, 115, 19);
                choiceLabel.setCurrentChoice(routable ? 1 : 0);
                panel.addChild((Widget)choiceLabel);
            }
        }
        this.storageList.addChild((Widget)panel);
    }

    protected void func_146976_a(float v, int i, int i2) {
        if (!this.init) {
            return;
        }
        this.updateStorageList();
        this.updateContentsList();
        this.requestListsIfNeeded();
        String text = this.radiusLabel.getText();
        if ("0".equals(text)) {
            text = "XNet";
        }
        this.visibleRadiusLabel.setText(text);
        int selected = this.storageList.getSelected();
        this.removeButton.setEnabled(selected != -1);
        if (selected <= 0 || this.storageList.getChildCount() <= 2) {
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
            this.topButton.setEnabled(false);
            this.bottomButton.setEnabled(false);
        } else if (selected == 1) {
            this.topButton.setEnabled(false);
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(true);
            this.bottomButton.setEnabled(true);
        } else if (selected == this.storageList.getChildCount() - 1) {
            this.topButton.setEnabled(true);
            this.upButton.setEnabled(true);
            this.downButton.setEnabled(false);
            this.bottomButton.setEnabled(false);
        } else {
            this.topButton.setEnabled(true);
            this.upButton.setEnabled(true);
            this.downButton.setEnabled(true);
            this.bottomButton.setEnabled(true);
        }
        if (!((StorageScannerTileEntity)this.tileEntity).isDummy()) {
            ((StorageScannerTileEntity)this.tileEntity).requestRfFromServer("rftools");
            int currentRF = GenericEnergyStorageTileEntity.getCurrentRF();
            this.energyBar.setValue(currentRF);
            this.exportToStarred.setCurrentChoice(((StorageScannerTileEntity)this.tileEntity).isExportToCurrent() ? 0 : 1);
        } else {
            if (System.currentTimeMillis() - lastTime > 300L) {
                lastTime = System.currentTimeMillis();
                RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketGetInfoFromServer("rftools", (InfoPacketServer)new ScannerInfoPacketServer(((StorageScannerTileEntity)this.tileEntity).getDimension(), ((StorageScannerTileEntity)this.tileEntity).func_174877_v())));
            }
            this.energyBar.setValue(ScannerInfoPacketClient.rfReceived);
            this.exportToStarred.setCurrentChoice(ScannerInfoPacketClient.exportToCurrentReceived ? 0 : 1);
        }
        this.drawWindow();
    }

    protected void func_146979_b(int i1, int i2) {
        if (!this.init) {
            return;
        }
        int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        List tooltips = this.craftingGrid.getWindow().getTooltips();
        if (tooltips != null) {
            this.drawHoveringText(tooltips, this.window.getTooltipItems(), x - this.field_147003_i, y - this.field_147009_r, this.field_146297_k.field_71466_p);
        }
        super.func_146979_b(i1, i2);
    }

    protected void drawStackTooltips(int mouseX, int mouseY) {
        if (this.init) {
            super.drawStackTooltips(mouseX, mouseY);
        }
    }

    protected List<String> addCustomLines(List<String> oldList, BlockRender blockRender, ItemStack stack) {
        if (blockRender.getUserObject() instanceof Integer) {
            ArrayList<String> newlist = new ArrayList<String>();
            newlist.add(TextFormatting.GREEN + "Click: " + TextFormatting.WHITE + "full stack");
            newlist.add(TextFormatting.GREEN + "Shift + click: " + TextFormatting.WHITE + "single item");
            newlist.add("");
            newlist.addAll(oldList);
            return newlist;
        }
        return oldList;
    }

    protected void drawWindow() {
        if (!this.init) {
            return;
        }
        super.drawWindow();
        this.craftingGrid.draw();
    }
}

