/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.teleporter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mcjty.lib.entity.GenericEnergyReceiverTileEntity;
import mcjty.lib.network.Argument;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.rftools.blocks.teleporter.GuiDialingDevice;
import mcjty.rftools.blocks.teleporter.MatterReceiverTileEntity;
import mcjty.rftools.blocks.teleporter.MatterTransmitterTileEntity;
import mcjty.rftools.blocks.teleporter.TeleportConfiguration;
import mcjty.rftools.blocks.teleporter.TeleportDestination;
import mcjty.rftools.blocks.teleporter.TeleportDestinationClientInfo;
import mcjty.rftools.blocks.teleporter.TeleportDestinations;
import mcjty.rftools.blocks.teleporter.TeleportationTools;
import mcjty.rftools.blocks.teleporter.TeleporterSetup;
import mcjty.rftools.blocks.teleporter.TransmitterInfo;
import mcjty.rftools.playerprops.FavoriteDestinationsProperties;
import mcjty.rftools.playerprops.PlayerExtendedProperties;
import mcjty.typed.Type;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class DialingDeviceTileEntity
extends GenericEnergyReceiverTileEntity {
    public static final String CMD_TELEPORT = "tp";
    public static final String CMD_GETRECEIVERS = "getReceivers";
    public static final String CLIENTCMD_GETRECEIVERS = "getReceivers";
    public static final String CMD_DIAL = "dial";
    public static final String CMD_DIALONCE = "dialOnce";
    public static final String CMD_FAVORITE = "favorite";
    public static final String CMD_SHOWFAVORITE = "showFavorite";
    public static final String CLIENTCMD_DIAL = "dialResult";
    public static final String CMD_GETTRANSMITTERS = "getTransmitters";
    public static final String CLIENTCMD_GETTRANSMITTERS = "getTransmitters";
    public static final String CMD_CHECKSTATUS = "checkStatus";
    public static final String CLIENTCMD_STATUS = "status";
    public static final int DIAL_RECEIVER_BLOCKED_MASK = 1;
    public static final int DIAL_TRANSMITTER_BLOCKED_MASK = 2;
    public static final int DIAL_INVALID_DESTINATION_MASK = 4;
    public static final int DIAL_DIALER_POWER_LOW_MASK = 8;
    public static final int DIAL_RECEIVER_POWER_LOW_MASK = 16;
    public static final int DIAL_TRANSMITTER_NOACCESS = 32;
    public static final int DIAL_RECEIVER_NOACCESS = 64;
    public static final int DIAL_INTERRUPTED = 128;
    public static final int DIAL_INVALID_SOURCE_MASK = 256;
    public static final int DIAL_DIMENSION_POWER_LOW_MASK = 512;
    public static final int DIAL_INVALID_TRANSMITTER = 1024;
    public static final int DIAL_OK = 0;
    public static final String COMPONENT_NAME = "dialing_device";
    private boolean showOnlyFavorites = false;

    public DialingDeviceTileEntity() {
        super(TeleportConfiguration.DIALER_MAXENERGY, TeleportConfiguration.DIALER_RECEIVEPERTICK);
    }

    public static String calculateDistance(World world, TransmitterInfo transmitterInfo, TeleportDestination teleportDestination) {
        if (world.field_73011_w.getDimension() != teleportDestination.getDimension()) {
            return "dimension warp";
        }
        BlockPos c1 = transmitterInfo.getCoordinate();
        BlockPos c2 = teleportDestination.getCoordinate();
        double dist = new Vec3d((double)c1.func_177958_n(), (double)c1.func_177956_o(), (double)c1.func_177952_p()).func_72438_d(new Vec3d((double)c2.func_177958_n(), (double)c2.func_177956_o(), (double)c2.func_177952_p()));
        return Integer.toString((int)dist);
    }

    public static boolean isMatterBoosterAvailable(World world, BlockPos pos) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (!((Object)((Object)TeleporterSetup.matterBoosterBlock)).equals(world.func_180495_p(pos.func_177972_a(facing)).func_177230_c())) continue;
            return true;
        }
        return false;
    }

    public static boolean isDestinationAnalyzerAvailable(World world, BlockPos pos) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (!((Object)((Object)TeleporterSetup.destinationAnalyzerBlock)).equals(world.func_180495_p(pos.func_177972_a(facing)).func_177230_c())) continue;
            return true;
        }
        return false;
    }

    public boolean isShowOnlyFavorites() {
        return this.showOnlyFavorites;
    }

    public void setShowOnlyFavorites(boolean showOnlyFavorites) {
        this.showOnlyFavorites = showOnlyFavorites;
        this.markDirtyClient();
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.showOnlyFavorites = tagCompound.func_74767_n("showFav");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74757_a("showFav", this.showOnlyFavorites);
    }

    private List<TeleportDestinationClientInfo> searchReceivers(String playerName) {
        TeleportDestinations destinations = TeleportDestinations.getDestinations(this.func_145831_w());
        return new ArrayList<TeleportDestinationClientInfo>(destinations.getValidDestinations(this.func_145831_w(), playerName));
    }

    public List<TransmitterInfo> searchTransmitters() {
        int x = this.func_174877_v().func_177958_n();
        int y = this.func_174877_v().func_177956_o();
        int z = this.func_174877_v().func_177952_p();
        int hrange = TeleportConfiguration.horizontalDialerRange;
        int vrange = TeleportConfiguration.verticalDialerRange;
        ArrayList<TransmitterInfo> transmitters = new ArrayList<TransmitterInfo>();
        for (int dy = -vrange; dy <= vrange; ++dy) {
            int yy = y + dy;
            if (yy < 0 || yy >= this.func_145831_w().func_72800_K()) continue;
            for (int dz = -hrange; dz <= hrange; ++dz) {
                int zz = z + dz;
                for (int dx = -hrange; dx <= hrange; ++dx) {
                    int xx = x + dx;
                    if (dx == 0 && dy == 0 && dz == 0) continue;
                    BlockPos c = new BlockPos(xx, yy, zz);
                    TileEntity tileEntity = this.func_145831_w().func_175625_s(c);
                    if (!(tileEntity instanceof MatterTransmitterTileEntity)) continue;
                    MatterTransmitterTileEntity matterTransmitterTileEntity = (MatterTransmitterTileEntity)tileEntity;
                    transmitters.add(new TransmitterInfo(c, matterTransmitterTileEntity.getName(), matterTransmitterTileEntity.getTeleportDestination()));
                }
            }
        }
        return transmitters;
    }

    private void changeFavorite(String playerName, BlockPos receiver, int dimension, boolean favorite) {
        List list = ((WorldServer)this.func_145831_w()).func_73046_m().func_184103_al().func_181057_v();
        for (EntityPlayerMP entityplayermp : list) {
            if (!playerName.equals(entityplayermp.func_70005_c_())) continue;
            FavoriteDestinationsProperties favoriteDestinations = PlayerExtendedProperties.getFavoriteDestinations((EntityPlayer)entityplayermp);
            favoriteDestinations.setDestinationFavorite(new GlobalCoordinate(receiver, dimension), favorite);
            return;
        }
    }

    private int dial(String player, BlockPos transmitter, int transDim, BlockPos coordinate, int dimension, boolean once) {
        return TeleportationTools.dial(this.func_145831_w(), this, player, transmitter, transDim, coordinate, dimension, once);
    }

    private int checkStatus(BlockPos c, int dim) {
        int cost = TeleportConfiguration.rfPerCheck;
        cost = (int)((float)cost * (2.0f - this.getInfusedFactor()) / 2.0f);
        if (this.getEnergyStored() < cost) {
            return 8;
        }
        this.consumeEnergy(cost);
        World w = mcjty.lib.varia.TeleportationTools.getWorldForDimension((int)dim);
        if (w == null) {
            TeleportDestinations destinations = TeleportDestinations.getDestinations(this.func_145831_w());
            destinations.cleanupInvalid(this.func_145831_w());
            return 4;
        }
        TileEntity tileEntity = w.func_175625_s(c);
        if (!(tileEntity instanceof MatterReceiverTileEntity)) {
            TeleportDestinations destinations = TeleportDestinations.getDestinations(this.func_145831_w());
            destinations.cleanupInvalid(this.func_145831_w());
            return 4;
        }
        MatterReceiverTileEntity matterReceiverTileEntity = (MatterReceiverTileEntity)tileEntity;
        return matterReceiverTileEntity.checkStatus();
    }

    @Nonnull
    public <T> List<T> executeWithResultList(String command, Map<String, Argument> args, Type<T> type) {
        List rc = super.executeWithResultList(command, args, type);
        if (!rc.isEmpty()) {
            return rc;
        }
        if ("getReceivers".equals(command)) {
            String playerName = args.get("player").getString();
            return type.convert(this.searchReceivers(playerName));
        }
        if ("getTransmitters".equals(command)) {
            return type.convert(this.searchTransmitters());
        }
        return Collections.emptyList();
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return rc;
        }
        if (CMD_FAVORITE.equals(command)) {
            String player = args.get("player").getString();
            BlockPos receiver = args.get("receiver").getCoordinate();
            int dimension = args.get("dimension").getInteger();
            boolean favorite = args.get(CMD_FAVORITE).getBoolean();
            this.changeFavorite(player, receiver, dimension, favorite);
            return true;
        }
        if (CMD_SHOWFAVORITE.equals(command)) {
            boolean favorite = args.get(CMD_FAVORITE).getBoolean();
            this.setShowOnlyFavorites(favorite);
            return true;
        }
        return false;
    }

    public Integer executeWithResultInteger(String command, Map<String, Argument> args) {
        Integer rc = super.executeWithResultInteger(command, args);
        if (rc != null) {
            return rc;
        }
        if (CMD_CHECKSTATUS.equals(command)) {
            BlockPos c = args.get("c").getCoordinate();
            int dim = args.get("dim").getInteger();
            return this.checkStatus(c, dim);
        }
        if (CMD_DIAL.equals(command)) {
            String player = args.get("player").getString();
            BlockPos transmitter = args.get("trans").getCoordinate();
            int transDim = args.get("transDim").getInteger();
            BlockPos c = args.get("c").getCoordinate();
            int dim = args.get("dim").getInteger();
            return this.dial(player, transmitter, transDim, c, dim, false);
        }
        if (CMD_DIALONCE.equals(command)) {
            String player = args.get("player").getString();
            BlockPos transmitter = args.get("trans").getCoordinate();
            int transDim = args.get("transDim").getInteger();
            BlockPos c = args.get("c").getCoordinate();
            int dim = args.get("dim").getInteger();
            return this.dial(player, transmitter, transDim, c, dim, true);
        }
        return null;
    }

    public <T> boolean execute(String command, List<T> list, Type<T> type) {
        boolean rc = super.execute(command, list, type);
        if (rc) {
            return true;
        }
        if ("getReceivers".equals(command)) {
            GuiDialingDevice.fromServer_receivers = Type.create(TeleportDestinationClientInfo.class).convert(list);
            return true;
        }
        if ("getTransmitters".equals(command)) {
            GuiDialingDevice.fromServer_transmitters = Type.create(TransmitterInfo.class).convert(list);
            return true;
        }
        return false;
    }

    public boolean execute(String command, Integer result) {
        boolean rc = super.execute(command, result);
        if (rc) {
            return true;
        }
        if (CLIENTCMD_STATUS.equals(command)) {
            GuiDialingDevice.fromServer_receiverStatus = result;
            return true;
        }
        if (CLIENTCMD_DIAL.equals(command)) {
            GuiDialingDevice.fromServer_dialResult = result;
            return true;
        }
        return false;
    }
}

