/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.teleporter;

import java.util.List;
import mcjty.lib.api.Infusable;
import mcjty.lib.container.BaseBlock;
import mcjty.lib.container.EmptyContainer;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.GenericRFToolsBlock;
import mcjty.rftools.blocks.teleporter.GuiMatterReceiver;
import mcjty.rftools.blocks.teleporter.MatterReceiverTileEntity;
import mcjty.rftools.blocks.teleporter.TeleportDestinations;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class MatterReceiverBlock
extends GenericRFToolsBlock<MatterReceiverTileEntity, EmptyContainer>
implements Infusable {
    public MatterReceiverBlock() {
        super(Material.field_151573_f, MatterReceiverTileEntity.class, EmptyContainer.class, "matter_receiver", false);
        this.func_180632_j(this.field_176227_L.func_177621_b());
    }

    @SideOnly(value=Side.CLIENT)
    public Class<GuiMatterReceiver> getGuiClass() {
        return GuiMatterReceiver.class;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack itemStack, World player, List<String> list, ITooltipFlag whatIsThis) {
        super.func_190948_a(itemStack, player, list, whatIsThis);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            String name = tagCompound.func_74779_i("tpName");
            int id = tagCompound.func_74762_e("destinationId");
            list.add(TextFormatting.GREEN + "Name: " + name + (id == -1 ? "" : ", Id: " + id));
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(TextFormatting.WHITE + "If you place this block anywhere in the world then");
            list.add(TextFormatting.WHITE + "you can dial to it using a Dialing Device. Before");
            list.add(TextFormatting.WHITE + "teleporting to this block make sure to give it power!");
            list.add(TextFormatting.YELLOW + "Infusing bonus: reduced power consumption.");
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof MatterReceiverTileEntity) {
            MatterReceiverTileEntity matterReceiverTileEntity = (MatterReceiverTileEntity)te;
            String name = matterReceiverTileEntity.getName();
            int id = matterReceiverTileEntity.getId();
            if (name == null || name.isEmpty()) {
                probeInfo.text(TextFormatting.GREEN + (id == -1 ? "" : "Id: " + id));
            } else {
                probeInfo.text(TextFormatting.GREEN + "Name: " + name + (id == -1 ? "" : ", Id: " + id));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="waila")
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        TileEntity te = accessor.getTileEntity();
        if (te instanceof MatterReceiverTileEntity) {
            MatterReceiverTileEntity matterReceiverTileEntity = (MatterReceiverTileEntity)te;
            String name = matterReceiverTileEntity.getName();
            int id = matterReceiverTileEntity.getId();
            if (name == null || name.isEmpty()) {
                currenttip.add(TextFormatting.GREEN + (id == -1 ? "" : "Id: " + id));
            } else {
                currenttip.add(TextFormatting.GREEN + "Name: " + name + (id == -1 ? "" : ", Id: " + id));
            }
        }
        return currenttip;
    }

    public int getGuiID() {
        return RFTools.GUI_MATTER_RECEIVER;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState state = super.func_180642_a(world, pos, facing, hitX, hitY, hitZ, meta, placer);
        if (world.field_72995_K) {
            return state;
        }
        TeleportDestinations destinations = TeleportDestinations.getDestinations(world);
        GlobalCoordinate gc = new GlobalCoordinate(pos, world.field_73011_w.getDimension());
        destinations.getNewId(gc);
        destinations.addDestination(gc);
        destinations.save(world);
        return state;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        this.restoreBlockFromNBT(world, pos, stack);
        if (!world.field_72995_K) {
            MatterReceiverTileEntity matterReceiverTileEntity = (MatterReceiverTileEntity)world.func_175625_s(pos);
            matterReceiverTileEntity.getOrCalculateID();
            matterReceiverTileEntity.updateDestination();
        }
        this.setOwner(world, pos, placer);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        super.func_180663_b(world, pos, state);
        if (world.field_72995_K) {
            return;
        }
        TeleportDestinations destinations = TeleportDestinations.getDestinations(world);
        destinations.removeDestination(pos, world.field_73011_w.getDimension());
        destinations.save(world);
    }

    public BaseBlock.RotationType getRotationType() {
        return BaseBlock.RotationType.NONE;
    }
}

